#!/bin/bash

#CUR=$(dirname `readlink -f ${0}`)

#cd $CUR

if [[ -z "$1" ]];then
    exit
fi
if [[ -z "$2" ]];then
    exit
fi
if [[ -z "$3" ]];then
    exit
fi
if [[ -z "$4" ]];then
    exit
fi

data=$1
output=$2
title=$3
fittitle=$4

gnuplot << EOF
set terminal pngcairo  
set output "$output"
set multiplot

plot "$data" using 1:2  title "" with linespoints ls 3
xm=GPVAL_DATA_X_MIN
xa=GPVAL_DATA_X_MAX
ym=GPVAL_DATA_Y_MIN
ya=GPVAL_DATA_Y_MAX
clear
set grid
#set xlabel "Wavelength"
set ylabel "PhysicValue"
set key samplen 1
set title "$title"

t=(xa-xm)/2
t2=(ya-ym)/20
set xtics t

f(x)=a*(x-xm)+b
fit f(x) '$data' via a,b
str=sprintf("Wavelength\nf ( x ) = %g * ( x - %g ) + %g", a, xm, b) 
#set label "f(x) =" at xm-t/4,ya
#set label str at xm-t/4,ya-t2
set xlabel str
#plot f(x) title "f(x)", "$data" using 1:2 notitle with linespoints ls 3
plot f(x) title "$fittitle", "$data" using 1:2 notitle with linespoints ls 3

quit
EOF
