#!/bin/bash

CUR=$(dirname `readlink -f ${0}`)
cd $CUR

VER=`echo $PWD | awk -F"/" '{print $(NF-1)}'`

SASVR_IP="112.74.80.60"
SASVR_PATH="/sa/centos/update/"
VER_FILE="version.json"
UPDATE_FILE="sa.update.tar.gz"

DEBIAN_LABEL=`sudo cat /etc/issue | grep "Debian"`

#sed -n 1p /etc/issue | awk '{print $1}' | tr '[A-Z]' '[a-z]'

if [ -n "$DEBIAN_LABEL" ]; then
    SASVR_PATH="/sa/debian/update/"
fi 

RAS_LABEL=`sudo cat /etc/issue | grep "Raspbian"`
if [ -n "$RAS_LABEL" ]; then
    SASVR_PATH="/sa/raspbian/update/"
fi 

#Get app version in server
rm -rf $VER_FILE
wget "http://"${SASVR_IP}${SASVR_PATH}${VER_FILE}
SAVER=`cat $VER_FILE | grep "\"Version\"" | awk -F'[' '{print $2}' | awk -F']' '{print $1}'`
SAVER_CN=`cat $VER_FILE | grep "\"cn\"" | awk -F'[' '{print $2}' | awk -F']' '{print $1}' | sed "s/\"/ /g"`
SAVER_EN=`cat $VER_FILE | grep "\"en\"" | awk -F'[' '{print $2}' | awk -F']' '{print $1}' | sed "s/\"/ /g"`

#echo $SAVER_CN
#echo $SAVER_EN
#exit

if [[ ! $SAVER ]];then
    echo "Server Error!"
    exit
fi
rm -rf $VER_FILE
let V1=`echo $SAVER | awk -F',' '{print $1}'`
let V2=`echo $SAVER | awk -F',' '{print $2}'`
let V3=`echo $SAVER | awk -F',' '{print $3}'`
let V4=`echo $SAVER | awk -F',' '{print $4}'`
let V5=`echo $SAVER | awk -F',' '{print $5}'`
let VN=$V1*1000000+$V2*100000+$V3*10000+$V4*1000+$V5

#Get app version at local
SAVER2=`cat ../conf/$VER_FILE | grep "\"Version\"" | awk -F'[' '{print $2}' | awk -F']' '{print $1}'`

if [ $SAVER2 ];then
    let V1=`echo $SAVER2 | awk -F',' '{print $1}'`
    let V2=`echo $SAVER2 | awk -F',' '{print $2}'`
    let V3=`echo $SAVER2 | awk -F',' '{print $3}'`
    let V4=`echo $SAVER2 | awk -F',' '{print $4}'`
    let V5=`echo $SAVER2 | awk -F',' '{print $5}'`
    let VN2=$V1*1000000+$V2*100000+$V3*10000+$V4*1000+$V5
else
    let VN2=0
fi

WEB_MSG="Version: $VN2\nUpdate: 0"

if [ $VN -gt $VN2 ];then
    WEB_MSG="Version: ${VN2}\nUpdate: ${VN}\n${SAVER_EN}\n${SAVER_CN}"
fi

rm -rf ../conf/update_web.txt
echo -e $WEB_MSG > ../conf/update_web.txt

if [ ! $1 ];then
    exit
fi

cd ../../

#Download update gz file from server
rm -rf $UPDATE_FILE
wget "http://"${SASVR_IP}${SASVR_PATH}${UPDATE_FILE}

tar -zxvf $UPDATE_FILE
cd sa.update

bash install.sh $VER

cd ~/sa
rm -rf $UPDATE_FILE
rm -rf sa.update

echo "------------"
echo "Update OK!"
echo "------------"

if [ ! $2 ];then
    exit
fi

echo "Reboot now..."
sleep 3
sudo reboot

