
var play_dts=[];
var play_len=0;
var play_cur=0;
var play_rate=1;
var play_frq=1;
var play_speed=play_rate*play_frq;
var play_title=[];
var play_start=true;
var play_pause=false;
var play_files=[];
var play_file_idx=0;

var rangeFrom = 0;
var rangeTo = 20;

function sa_data_play_data_read(fn){
    var nowTime = new Date().getTime();
    $.ajax({url: fn+"?time="+nowTime,type: "GET",dataType:'text',async:true,cache:true,timeout:5000,success:sa_data_play_data_read_success});
}

function sa_data_play_columns(title){
    play_title = [];
   for(var i=0;i<title.length;i++){
        var line = title[i];
        if(line.indexOf("=") >= 0){
           var l=line.replace(/(^\s*)|(\s*$)/g, "");
           var col = parseInt(l.split("=")[0].split("Column")[1]);  
           if(col >=3){
               var col_data = l.split("=")[1]; 
               var id = parseInt(col_data.split(",")[0].split(":")[1]);
               var sn = col_data.split(",")[1].split(":")[1];
               play_title.push(id+"."+sn);  
           }
        }
   }
}

function sa_data_play_data_read_success(fn_data){
    if(fn_data == null)return;
    var fn_data_2 = fn_data.split("*End*");
    var title = fn_data_2[0].split("\n");
    sa_data_play_columns(title);
    play_dts=[]; 
    var data = fn_data_2[1].split("\n");
    for(var i=0;i<data.length;i++){
       var dt=data[i].split(/\t/g);
       if(parseInt(dt[0]) >=0 && parseInt(dt[1]) >=0){
            play_dts.push(dt); 
       }
    }
    play_len = play_dts.length;
    document.getElementById("saCounter_max").innerHTML= play_len-1;
    play_cur = 0;
    play_frq=sa_data_play_frq(play_dts);
    play_speed = play_frq*play_rate;
    document.getElementById("playbackFRQ").innerHTML= play_frq;
    
    play_start=true;
    play_pause=false;
    document.getElementById("start_chk").checked="checked";
    
    sa_data_play_data_draw();
}

function sa_data_play_data_draw(){
    if(play_cur>=play_len-1 || play_start == false){
        play_file_idx +=1;
        play_start = false;
        return;
    }

    if(play_pause){
        setTimeout("sa_data_play_data_draw()",parseInt(1000/play_speed));
        return;
    }

    for(var i=0;i< play_title.length;i++){
        if(i<rangeFrom || i>rangeTo)continue;
        //Check sensor ID
        var d = i;
        var v_str = play_dts[play_cur][2+i];
        if(v_str==null)continue;
        var v = parseFloat(v_str);

        var j=0;
        for(var k=0;k< chartDatas.length;k++){
            if(chartDatas[k]["name"] == play_title[d]){
                chartDatas[k]["data"].push(v);
                if(chartDatas[k]["data"].length > dataLength){
                    chartDatas[k]["data"].shift();
                    if(chartDatas[k]["data"].length > dataLength){
                        chartDatas[k]["data"].shift();
                    } 
                }
                j=1;
                break;
            }
        }
        if(j==0){
            chartDatas.push({name: play_title[d],data:[v]});
        }
    }
    ChartRT("en");
    play_cur +=1;
    document.getElementById("saCounter").innerHTML= play_cur;
    setTimeout("sa_data_play_data_draw()",parseInt(1000/play_speed));
    return;
}

function sa_data_play_frq(dts){
   var counts=[];
   var count =1;
   for(var i=1;i<dts.length;i++){
        if(dts[i][0] == dts[i-1][0]){
            count+=1; 
        }
        else{
            counts.push(count);
            count =1;
        }
   }
   var start=0;
   var end=0;
   var len = counts.length;
   if(len >2){
       start = 1;
       end = len-2;
   }
   else{
       start = 0;
       end = len-1;
   }
   var s=0;
   for(var i=start;i<=end;i++){
        s = parseInt(s)+parseInt(counts[i]);
   }
   return parseInt(1.0*s/(end-start));
}

function playbackRate_changed(me){
    var val = parseInt(me.value);
    if(val <=0)return;
    play_rate = val; 
    play_speed = play_rate * play_frq;
    document.getElementById("playbackSpeed").value=play_speed;
}
function playbackSpeed_changed(me){
    var val = parseInt(me.value);
    if(val <=0)return;
    play_speed = val; 
    play_rate = parseInt(play_speed/play_frq);
    document.getElementById("playbackRate").value=play_rate;
}

function datalength_changed(me){
    dataLength = me.value;
}

function rangefrom_changed(me){
    rangeFrom = me.value;
    chartDatas=[];
}

function rangeto_changed(me){
    rangeTo = me.value;
    chartDatas=[];
}

function start_checked(me){
    play_start = me.checked;
    if(play_start){
        play_start = false;
        play_file_idx=0;
        sa_playnow();
    }
}

function pause_checked(me){
    play_pause = me.checked;
}

function sa_play_text_create(f){
    var sf = f;
    var fa = f.split("/");
    var df_part=fa[fa.length-1].split(".")[0];
    var df_short=df_part+"_pv.txt";
    var df="../../data/rt-exports/"+df_short;  
    var com = "../../bin/dt-export "+sf+" "+df+" 0 0 1";
    var httpcommand = "/command_std?par="+com;
    $.get(httpcommand,function(data){
        sa_data_play_data_read("/data/rt-exports/"+df_short);    
        document.getElementById("play_file").innerHTML= df_part;
    });
}

function sa_playback_reset(){
    play_dts=[];
    play_len=0;
    play_cur=0;
    play_rate=1;
    play_frq=1;
    play_speed=play_rate*play_frq;
    play_title=[];
    play_start=false;
    play_pause=false;
    play_files=[];
    play_file_idx=0;
}

function sa_playnow(){

    if(play_start ==false){
        if(play_file_idx > play_files.length-1)return;
        sa_play_text_create(play_files[play_file_idx]);
    }
    setTimeout("sa_playnow()",5000);
}

function sa_playback(){
    sa_playback_reset();
    sa_playback_files();
    $('#myTab li:eq(1) a').tab('show');
    sa_playnow();
    
}

function sa_playback_files(){
    play_files=[];
    play_file_idx=0;

    for(var i=de_lines.length-1;i>=0;i--){
        var l = de_lines[i];
        if(l.length < 10)continue;
        if(l[5] == "1" || l[6] == "1" || l[7] == "1" || l[8] == "1" || l[9] == "1"){
            play_files.push(l[4]);
        }
    }
}
