
var ip = window.location.host.split(":")[0];

var rwlessCounter=-1;
var sensorList = [];

var counter_old=0;

function Refresh_new(){
    lng = lng+1;
    var nowTime = new Date().getTime();
    var url= "/data?time="+nowTime+"."+lng;
    $.ajax({url: url,type: "GET",dataType:'json',async:true,cache:true,timeout:5000,success:processData,complete:processData_complete});
}

function processData_complete(){
    setTimeout("Refresh_new()",dataRefreshInterval);
}

function processData(obj){
    
    $("#refCount").html(lng);
    if(refreshStart == 0){
        return;
    }
    if(rwlessCounter != obj.Value.Counter){
        rwlessCounter = obj.Value.Counter;
        $("#saCounter").html(obj.Value.Counter);
        $("#saCounter_diff").html(obj.Value.Counter - counter_old);
        counter_old = obj.Value.Counter;
        for(var i=0;i< obj.Value.dt.length;i++){
            //Check sensor matched
            if(obj.Value.dt[i][0] == 1){
                for(var k=0;k<lines2.Items.length;k++){
                    if(obj.Value.dt[i][1] == lines2.Items[k].s.id){
                        lines2.Items[k].s.val = obj.Value.dt[i][4];
                         //break;
                    }
                }
            }
        }
    }
}

function ls_run_draw(){
    
    if(refreshStart == 0){
        setTimeout("ls_run_draw()",dataRefreshInterval);
        return;
    }
    
    ctx.drawImage(img,0,0,canvas_size.w,canvas_size.h);
    for(var i=0;i<lines2.Items.length;i++){
        var l = lines2.Items[i];
        if(l.type == 0){
            l_run_draw(l,get_line_style(l));
        }
        else{
            if(l.type == 1){
                l_run_draw_line(l,get_line_style(l));
            }
            else{
                l_run_draw_line2(l,get_line_style(l));
            }
        }
    }
    setTimeout("ls_run_draw()",dataRefreshInterval);
}

function start_checked_equ(me){
   if(me.checked){
        refreshStart = 1;
   }
   else{
        refreshStart = 0;
    }
}
function startTimer(){
    refreshStart = 1;
    Refresh_new();
    ls_run_draw();
}

function stopTimer(){
    refreshStart = 0;
}

    var catch_start=0;
    var count_click=0;
    var count_start=1;
    var full=0;
    var line=[];
    var lines=[];

    function mouseDown(event){
        if(catch_start==0)return;
        count_click = parseInt(count_click) + 1;
        if(count_click == 1){
            line=[];
            full=0;
            count_start=1;
            ctx.beginPath();
        }
        if(count_click == 2){
            count_click = 0;
            full=1;
            line_active.points = line;
            //lines.push(line);
            count_start=0;
            stopCatch();
            drawActiveLine();
        }
    }

    function mousePosition(ev){
        if(ev.pageX || ev.pageY){//firefox、chrome等浏览器
            return {x:ev.pageX,y:ev.pageY};
        }
        return {// IE浏览器
            x:ev.clientX + document.body.scrollLeft - document.body.clientLeft,
            y:ev.clientY + document.body.scrollTop - document.body.clientTop
        };
    }

    function drawActiveLine(){
        var la = line_active;
        var p = la.points;
        if(la.type == 0 )return;
        ctx.beginPath();
        ctx.lineWidth = la.width;
        ctx.lineCap=la.cap;
        ctx.strokeStyle = la.style;
        ctx.moveTo(p[0].x,p[0].y);
        ctx.lineTo(p[p.length-1].x,p[p.length-1].y);       
        ctx.stroke();
    }
    
    function mouseMove(ev){
        if(catch_start==0)return;
        ev = ev || window.event;
        var mousePos = mousePosition(ev);
        //document.getElementById('x').innerHTML = mousePos.x;
        //document.getElementById('y').innerHTML = mousePos.y;
        var x = mousePos.x;
        var y = mousePos.y;
        var xo = x - c.offsetLeft;
        var yo = y - c.offsetTop;
        
        var la = line_active;
        var p = la.points;

        ctx.lineWidth = la.width;
        ctx.lineCap=la.cap;
        ctx.strokeStyle = la.style;
        
        if(x < c.offsetLeft || x > c.offsetLeft + c.offsetWidth || y < c.offsetTop || y > c.offsetTop + c.offsetHeight)return;
        if(count_click==1 && full==0){
            if(la.type == 0){
                if(count_start == 1){
                    ctx.moveTo(xo,yo);
                    count_start = 0;
                }
                else{
                    ctx.lineTo(xo,yo);       
                }
                ctx.stroke();
            }
            line.push({x:xo,y:yo});        
        }
    }

    document.onmousemove = mouseMove;
    document.onmousedown = mouseDown;
    
    function startCatch(){
        catch_start = 1;
        count_click = 0;
    }
    function stopCatch(){
        catch_start = 0;
    }

var label_font_txt = "px Arial";
var label_font = 12;
var lines2;
var lines2_null={Items:[
    {id:1,name:"start1",s:{id:1,val:0,min:0,max:100,gy:60,yr:80},labels:{id:true,val:true,float:true,line:true},font:label_font,type:0,style:"rgba(0,0,255,0.5)",cap:"round",width:5,points:[{x:0,y:0}]},
        {id:2,name:"start2",s:{id:2,val:0,min:0,max:100,gy:60,yr:80},labels:{id:true,val:true,float:true,line:true},font:label_font,type:1,style:"rgba(0,0,255,0.5)",cap:"round",width:5,points:[{x:0,y:0}]},
        {id:3,name:"start3",s:{id:3,val:0,min:0,max:100,gy:60,yr:80},labels:{id:true,val:true,float:true,line:true},font:label_font,type:2,style:"rgba(0,0,255,0.5)",cap:"round",width:5,points:[{x:0,y:0}]},
        {id:4,name:"start4",s:{id:4,val:0,min:0,max:100,gy:60,yr:80},labels:{id:true,val:true,float:true,line:true},font:label_font,type:0,style:"rgba(0,0,255,0.5)",cap:"round",width:5,points:[{x:0,y:0}]},
        {id:5,name:"start5",s:{id:5,val:0,min:0,max:100,gy:60,yr:80},labels:{id:true,val:true,float:true,line:true},font:label_font,type:1,style:"rgba(0,0,255,0.5)",cap:"round",width:5,points:[{x:0,y:0}]},
        {id:6,name:"start6",s:{id:6,val:0,min:0,max:100,gy:60,yr:80},labels:{id:true,val:true,float:true,line:true},font:label_font,type:2,style:"rgba(0,0,255,0.5)",cap:"round",width:5,points:[{x:0,y:0}]}
]};

var line_style_g = "rgba(0,255,0,0.5)";
var line_style_y = "rgba(255,255,0,0.5)";
var line_style_r = "rgba(255,0,0,0.5)";

var line_new;

function get_lines(){
    return lines2;
}

var line_active_index=0;
var line_active;
//var line_new = new Object();

function l_draw(i){
    //Stop all
    stopTimer();
    document.getElementById("start_chk").checked = false;

   if(catch_start==0){
       line_active = lines2.Items[i];
       startCatch();
   }
   else{
        stopCatch();
   }
   ls_changed();
}

function get_line_style(l){
    var s = l.s;
    var p = parseFloat(parseFloat(100.0)*parseFloat(s.val-s.min)/parseFloat(s.max-s.min));
    if(p <= s.gy){
        return line_style_g;
    }
    else{
        if(p <= s.yr){
            return line_style_y;
        }
        else{
            return line_style_r;
        }
    }
}


function draw_text(la,style,vp){
    var p = la.points;
    var f = la.font;
    if(p.length <=1)return;
    if(la.labels.id == false && la.labels.val == false)return;
    var li = p.length-1;
    var x1 = p[0].x - parseInt(parseInt(p[1].x)-parseInt(p[0].x)) - parseInt(f);  
    var y1 = p[0].y + parseInt(parseInt(p[0].y)-parseInt(p[1].y)) + parseInt(f*1.5);
    
    ctx.font = la.font+label_font_txt;
    var y_offset=0;
    if(la.labels.float == false)y_offset = la.font;
    if(la.labels.id){
        ctx.fillStyle="#0000FF";
        ctx.fillText(la.s.min+" ~ "+la.s.max,x1,y1+y_offset); 
        ctx.fillText("("+la.id+","+la.name+" : "+la.s.id+")",x1-parseInt(f),y1+parseInt(f)+y_offset); 
    }
   
    if(la.labels.val){
        if(style == line_style_g){
            ctx.fillStyle="#00FF00";
        }
        else{
            if(style == line_style_y){
                ctx.fillStyle="#FFFF00";
            }
            else{
                ctx.fillStyle="#FF0000";
            }
        }
        if(la.labels.float){
            ctx.fillText(la.s.val,vp.x,vp.y);
        }
        else{
            ctx.fillText(la.s.val,x1,y1);
        }
    }
}

function l_run_draw_line2(la,style){
    var p = la.points;
    if(p.length <=1)return;
    var li = p.length-1;

    var x0 = p[0].x;
    var y0 = p[0].y;
    var xe = p[li].x;
    var ye = p[li].y;
    var x = parseInt(parseFloat(parseFloat(xe-x0)*parseFloat(parseFloat(la.s.val-la.s.min)/parseFloat(la.s.max-la.s.min)))+parseFloat(x0));
    var y = parseInt(((ye - y0)/(xe-x0))*(x-x0) + parseFloat(y0));

    //Redraw line
    if(la.labels.line){
        ctx.beginPath();
        ctx.lineWidth = la.width;
        ctx.lineCap=la.cap;
        ctx.strokeStyle = style;
        ctx.moveTo(p[0].x,p[0].y);
        ctx.lineTo(x,y);
        ctx.stroke();
    }
    //Draw Text
    draw_text(la,style,{x:x,y:y}); 

}
function l_run_draw_line(la,style){
    var p = la.points;
    if(p.length <=1)return;
    var li = p.length-1;

    var j = parseInt(parseFloat(parseFloat(la.s.val-la.s.min)/parseFloat(la.s.max-la.s.min))*parseFloat(p.length-1));
    var x = p[j].x;
    var x0 = p[0].x;
    var y0 = p[0].y;
    var xe = p[li].x;
    var ye = p[li].y;
    var y = parseInt(((ye - y0)/(xe-x0))*(x-x0) + parseFloat(y0));

    //Redraw line
    if(la.labels.line){
        ctx.beginPath();
        ctx.lineWidth = la.width;
        ctx.lineCap=la.cap;
        ctx.strokeStyle = style;
        ctx.moveTo(p[0].x,p[0].y);
        ctx.lineTo(x,y);
        ctx.stroke();
    }
    //Draw Text
    draw_text(la,style,{x:x,y:y}); 
}

function l_run_draw(la,style){
    var p = la.points;
    if(p.length <=1)return;
    //Redraw line
    if(la.labels.line){
        ctx.beginPath();
        ctx.lineWidth = la.width;
        ctx.lineCap=la.cap;
        ctx.strokeStyle = style;

        ctx.moveTo(p[0].x,p[0].y);
    }
    var j = parseInt(((la.s.val-la.s.min)/(la.s.max-la.s.min))*(p.length-1));
    for(var i=0;i<j;i++){
        if(la.labels.line)ctx.lineTo(p[i].x,p[i].y);
    }
    if(la.labels.line)ctx.stroke();
    //Draw Text
    draw_text(la,style,{x:p[i-1].x,y:p[i-1].y}); 
}
var myTimer_run;

function ls_changed(){
    line_get_data_base(lines2);
    document.getElementById("ls_save_button").disabled=false;
    document.getElementById("ls_save_button").style.color="FF0000";
}

function ls_save(){
    $.get("/setconf?name=equ-web.conf&data="+JSON.stringify(lines2)+"&type=json", function(data) {
        if(data != null){
            alert("Setting saved!");
            document.getElementById("ls_save_button").disabled=true;
            document.getElementById("ls_save_button").style.color="#FF0000";
        }
    });
}

function l_del(idx){
    if(idx<0)return;
    var i = lines2.Items;
    var x = parseInt(idx);
    lines2.Items = i.slice(0,x).concat(i.slice((x+1),i.length));
    line_create_list();
    ls_changed();
}

function l_add(){
    lines2.Items.push(line_new);
    line_create_list();
    ls_changed();
}

function l_changed_name(i,me){
    if(i>=lines2.Items.length){
        line_new.name= me.value;
        return;
    }
    lines2.Items[i].name = me.value;
    ls_changed();
}

function l_changed_sid(i,me){
    var v = parseInt(me.value);
    if(i>=lines2.Items.length){
        line_new.s.id= v;
        return;
    }
    lines2.Items[i].s.id = v;
    ls_changed();
}

function l_changed_type(i,me){
    var v = parseInt(me.value);
    if(i>=lines2.Items.length){
        line_new.type = v;
        return;
    }
    lines2.Items[i].type = v;
    ls_changed();
}

function l_changed_cap(i,me){
    if(i>=lines2.Items.length){
        line_new.cap = me.value;
        return;
    }
    lines2.Items[i].cap = me.value;
    ls_changed();
}

function l_changed_width(i,me){
    var v = parseInt(me.value);
    if(i>=lines2.Items.length){
        line_new.width = v;
        return;
    }
    lines2.Items[i].width = v;
    ls_changed();
}

function l_changed_font(i,me){
    var v = parseInt(me.value);
    if(i>=lines2.Items.length){
        line_new.font = v;
        return;
    }
    lines2.Items[i].font = v;
    ls_changed();
}

function l_changed_chk_id(i,me){
    if(i>=lines2.Items.length){
        line_new.labels.id = me.checked;
        return;
    }
    lines2.Items[i].labels.id = me.checked;
    ls_changed();
}

function l_changed_chk_val(i,me){
    if(i>=lines2.Items.length){
        line_new.labels.val = me.checked;
        return;
    }
    lines2.Items[i].labels.val = me.checked;
    ls_changed();
}

function l_changed_chk_float(i,me){
    if(i>=lines2.Items.length){
        line_new.labels.float = me.checked;
        return;
    }
    lines2.Items[i].labels.float = me.checked;
    ls_changed();
}

function l_changed_chk_line(i,me){
    if(i>=lines2.Items.length){
        line_new.labels.line = me.checked;
        return;
    }
    lines2.Items[i].labels.line = me.checked;
    ls_changed();
}
function l_changed_id_va(me){
    line_new.id = parseInt(me.value);
}
var count=2;
function create_test_data(){
    var ss = get_lines();
    for(var i=0;i<ss.Items.length;i++){
        s = ss.Items[i];
        s.s.val = s.s.val + parseInt(count);
        if(s.s.val <= s.s.min)s.s.val = s.s.min;
        if(s.s.val >= s.s.max)s.s.val = s.s.min;
    } 
}

function line_create_list(){
    var ss = get_lines();
    var tb_list = "<table class='table table-striped table-condensed'><thead><tr><th>#</th></th><th>ID</th><th>Name</th><th>SensorID</th><th>LineType<th>LineWidth<th>Font</th><th>ID Label</th><th>Value Label</th><th>Value Float</th><th>Line Show</th><th></th><th></th></tr></thead><tbody>";
    for(var i=0;i<ss.Items.length;i++){
         var s = ss.Items[i];
         var chk_id = "";
         var chk_val = "";
         var chk_float = "";
         var chk_line = "";
         if(s.labels.id)chk_id="checked";
         if(s.labels.val)chk_val="checked";
         if(s.labels.float)chk_float="checked";
         if(s.labels.line)chk_line="checked";
tb_list = tb_list + "<tr id='tr_id_"+i+"'> \
<td>"+i+"</td>\
<td>"+s.id+"</td>\
<td><input type='text' id='l_name_"+s.id+"' style='width: 80px' value='"+s.name+"' onChange='l_changed_name("+i+",this)'></td>\
<td><input type='number' id='l_sid_"+s.id+"' style='width: 40px' value='"+s.s.id+"' step='1' min='1' max='10000' onChange='l_changed_sid("+i+",this)'>\
<button type='button' id='l_sid_s_'"+s.id+" onclick='l_sid_s_clicked("+i+",this)'>.</button></td>\
<td><input type='number' id='l_type_"+s.id+"' style='width: 40px' value='"+s.type+"' step='1' min='0' max='1000' onChange='l_changed_type("+i+",this)'></td>\
<td><input type='number' id='l_width_"+s.id+"' style='width: 40px' value='"+s.width+"' step='1' min='1' max='200' onChange='l_changed_width("+i+",this)'></td>\
<td><input type='number' id='l_font_"+s.id+"' style='width: 40px' value='"+s.font+"' step='1' min='1' max='50' onChange='l_changed_font("+i+",this)'></td>\
<td><input type='checkbox' id='l_chk_id_"+s.id+"' style='width: 40px' "+chk_id+" onChange='l_changed_chk_id("+i+",this)'></td>\
<td><input type='checkbox' id='l_chk_val_"+s.id+"' style='width: 40px' "+chk_val+" onChange='l_changed_chk_val("+i+",this)'></td>\
<td><input type='checkbox' id='l_chk_float_"+s.id+"' style='width: 40px' "+chk_float+" onChange='l_changed_chk_float("+i+",this)'></td>\
<td><input type='checkbox' id='l_chk_line_"+s.id+"' style='width: 40px' "+chk_line+" onChange='l_changed_chk_line("+i+",this)'></td>\
<td><button type='button' name='bt' onclick='l_draw("+i+")'><font color='0000FF' size='3'>Draw</font></button></td>\
<td><button type='button' name='bt' onclick='l_del("+i+")'><font color='FF0000' size='3'>DEL</font></button></td>\
</tr>";
    }
    if(i>0){
        var n = ss.Items[i-1];
        var j = parseInt(1) + parseInt(n.id);
        var j2 = parseInt(n.id) + ".";
        var k = parseInt(1) + parseInt(n.s.id);
        var nm = n.name.substring(0,n.name.length-j2.length+parseInt(1))+j;
        
        line_new={id:j,name:nm,s:{id:k,val:0,min:0,max:100,gy:60,yr:80},labels:{id:n.labels.id,val:n.labels.val,float:n.labels.float,line:n.labels.line},font:n.font,type:n.type,style:n.style,cap:n.cap,width:n.width,points:[]};
    }
    else{
        line_new={id:1,name:"null;",s:{id:1,val:0,min:0,max:100,gy:60,yr:80},labels:{id:true,val:true,float:true,line:true},font:label_font,type:0,style:"rgba(0,255,0,0.5)",cap:"round",width:5,points:[]};
    }

    chk_id = "";
    chk_val = "";
    chk_float = "";
    chk_line = "";
    if(line_new.labels.id)chk_id="checked";
    if(line_new.labels.val)chk_val="checked";
    if(line_new.labels.float)chk_float="checked";
    if(line_new.labels.line)chk_line="checked";

tb_list = tb_list + "<tr id='tr_id_"+i+"'> \
<td>"+i+"</td>\
<td><input type='number' id='l_id_va' style='width: 40px' value='"+line_new.id+"' step='1' min='1' max='10000' onChange='l_changed_id_va(this)'></td>\
<td><input type='text' id='l_name_va' style='width: 80px' value='"+line_new.name+"' onChange='l_changed_name("+i+",this)'></td>\
<td><input type='number' id='l_sid_va' style='width: 40px' value='"+line_new.s.id+"' step='1' max='10000' onChange='l_changed_sid("+i+",this)'>\
<button type='button' id='l_sid_s_va' onclick='l_sid_s_clicked("+i+",this)'>.</button></td>\
<td><input type='number' id='l_type_va' style='width: 40px' value='"+line_new.type+"' step='1' min='0' max='1000' onChange='l_changed_type("+i+",this)'></td>\
<td><input type='number' id='l_width_va' style='width: 40px' value='"+line_new.width+"' step='1' min='1' max='200' onChange='l_changed_width("+i+",this)'></td>\
<td><input type='number' id='l_font_va' style='width: 40px' value='"+line_new.font+"' step='1' min='1' max='50' onChange='l_changed_font("+i+",this)'></td>\
<td><input type='checkbox' id='l_chk_id_va' style='width: 40px' "+chk_id+" onChange='l_changed_chk_id("+i+",this)'></td>\
<td><input type='checkbox' id='l_chk_val_va' style='width: 40px' "+chk_val+" onChange='l_changed_chk_val("+i+",this)'></td>\
<td><input type='checkbox' id='l_chk_float_va' style='width: 40px' "+chk_float+" onChange='l_changed_chk_float("+i+",this)'></td>\
<td><input type='checkbox' id='l_chk_line_va' style='width: 40px' "+chk_line+" onChange='l_changed_chk_line("+i+",this)'></td>\
<td><button name='bt' type='button'><font color='0000FF' size='3'>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</font></button></td>\
<td><button name='bt' type='button' onclick='l_add("+i+")'><font color='0000FF' size='3'>Add</font></button></td>\
</tr>";


   tb_list = tb_list + "</tbody></table>";
   document.getElementById("lineList").innerHTML=tb_list;

}

var canvas_size = {w:800,h:400};

function c_save(){
    
    $.get("/setconf?name=equ-web-canvas.conf.conf&data="+JSON.stringify(canvas_size)+"&type=json", function(data) {
        if(data != null){
            alert("Canvas size saved!");
        }
    });
}

function c_redraw(){
    c.width = canvas_size.w;
    c.height = canvas_size.h;
    ctx.clearRect(0,0,canvas_size.w,canvas_size.h);
    ctx.drawImage(img,0,0,canvas_size.w,canvas_size.h);
    c_save();
}

function c_changed_w(me){
    canvas_size.w = parseInt(me.value);
    c_redraw();
}
function c_changed_h(me){
    canvas_size.h = parseInt(me.value);
    c_redraw();
}

function chart_display_clicked(me){
    var ui =document.getElementById("myCanvas");
    if(me.value[0] =="+"){
        me.value = "- 图表";
        ui.style.display="block";

    }
    else{
        me.value = "+ 图表";
        ui.style.display="none";
    }
}
function list_display_clicked(me){
    var ui =document.getElementById("lineList");
    if(me.value[0] =="+"){
        me.value = "- 列表";
        ui.style.display="block";

    }
    else{
        me.value = "+ 列表";
        ui.style.display="none";
    }
}

var alarms_cur;
var regs;
function register_init(data){
    regs = data;
    $.ajax({url: "/conf/equ-web.conf",type: "GET",dataType:'json',success:ls_init,error:ls_init_error});
}
function alarm_init(data){
    alarms_cur = data;
    $.ajax({url: "/conf/register.conf",type: "GET",dataType:'json',success:register_init});
}

function canvas_init_error(){
    document.getElementById("c_w").value = canvas_size.w;
    document.getElementById("c_h").value = canvas_size.h;
    c.width = canvas_size.w;
    c.height = canvas_size.h;
}
function canvas_init(data){
    canvas_size = data;
    document.getElementById("c_w").value = canvas_size.w;
    document.getElementById("c_h").value = canvas_size.h;
    c.width = canvas_size.w;
    c.height = canvas_size.h;
}

function ls_init_error(){
    lines2=lines2_null;
    line_get_data_base(lines2);
    line_create_list();
    startTimer();
}
function ls_init(data){
    if(data != null && data.Items.length > 0){
        lines2 = {Items:[]};
        lines2 = data;
    }
    
    line_get_data_base(lines2);
    line_create_list();
    startTimer();
}

function line_get_data_base(ls){
    for(var i=0;i<ls.Items.length;i++){
        line_setting_alarm(ls.Items[i]);
    }    
}

function line_setting_alarm_bk(l){
    for(var i=0;i<regs.Sensors.Items.length;i++){
        var reg = regs.Sensors.Items[i];
        if(l.s.id==reg.ID){
            var aid = reg.AlarmID;
            for(var j=0;j<alarms_cur.Items.length;j++){
                var a = alarms_cur.Items[j];
                if(a.D == aid){
                    if((a.I != l.s.min) || (a.A != l.s.max) || (a.G != l.s.gy) || (a.Y != l.s.yr)){
                       l.s.min = a.I;
                       l.s.max = a.A;
                       l.s.gy = a.G;
                       l.s.yr = a.Y;
                        //Need redraw gauge with new value
                      //redrawAllNoInitGauge();
                    }
                }
            }
        }
    }
}

function line_setting_alarm(l){
    for(var i=0;i<regs.Sensors.Items.length;i++){
        var reg = regs.Sensors.Items[i];
        if(l.s.id==reg.ID){
            var aid = reg.AlarmID;
            for(var j=0;j<alarms_cur.Items.length;j++){
                var a = alarms_cur.Items[j];
                if(a[0] == aid){
                    if((a[1] != l.s.min) || (a[2] != l.s.max) || (a[3] != l.s.gy) || (a[4] != l.s.yr)){
                       l.s.min = a[1];
                       l.s.max = a[2];
                       l.s.gy = a[3];
                       l.s.yr = a[4];
                        //Need redraw gauge with new value
                      //redrawAllNoInitGauge();
                    }
                }
            }
        }
    }
}

function preview(file){
    var prevDiv = document.getElementById('pic');
    if (file.files && file.files[0]){
         var reader = new FileReader();
         reader.onload = function(evt){
            prevDiv.innerHTML = '<img id="equ" src="' + evt.target.result + '" />';
            img=document.getElementById("equ");
            ctx.drawImage(img,0,0,canvas_size.w,canvas_size.h);
         }  
         reader.readAsDataURL(file.files[0]);
    }
}

$(function(){

    var obj = document.getElementById("ct");
    if(obj)obj.innerHTML = sa_menu_get_all_without_view_data_with_equ_lines();
    $("#saLogo").load("logo2.txt");
    
    ctrl_dsp_changed3(document.getElementById("lines_display"),"<span>Lines</span>","saLines");

    $("[data-toggle='tooltip']").tooltip();
    msg_new_number_get_dsp();
    sa_lang_version(sa_lang_load_conf);
    sa_functions_control();
});
