
var rangeFrom = 0;
var rangeTo = 5;
var rangeCount= rangeTo - rangeFrom + 1;
var linesCount = 2;
var gaugeHeight = 350;
var gaugeWidth = 500;

var dataRefreshInterval = 100;

var rwlessCounter = -1;
var counter_old=0;

var gauge=[];
var alarms_cur;
var regs;

function rangefrom_changed(){
    rangeFrom = document.getElementById("rangeFrom_txt").value;
    rangeCount = rangeTo - rangeFrom + 1;
    if(rangeCount%2)return;
    redrawAll();
}

function rangeto_changed(){
    rangeTo = document.getElementById("rangeTo_txt").value;
    rangeCount = rangeTo - rangeFrom + 1;
    if(rangeCount%linesCount)return;
    redrawAll();
}

function register_init(data){
    regs = data;
    $.ajax({url: "conf/alarm.conf",type: "GET",dataType:'json',success:alarm_init});
}
function alarm_init(data){
    alarms_cur = data;
    redrawAll();
    Refresh_new();
    Refresh_IDN();
}

function initGaugeData(from,to){
    var i=0;
    var count = to - from + 1;
    var j=from+1;
    gauge = [];
    for(i=0;i<count;i++,j++){
        gauge.push({sid:j,startAngle:-150,endAngle:150,min:0,max:200,diff:200,gy:60,yr:80,unit_name:'PV',unit:':',interval:500,id:'#container'+i,val:0});   
    }
}

function initTitleParameters(){
    document.getElementById("rangeFrom_txt").value = rangeFrom;
    document.getElementById("rangeTo_txt").value = rangeTo;
    document.getElementById("linesCount").value = linesCount;
    document.getElementById("gaugeWidth_txt").value = gaugeWidth;
    document.getElementById("gaugeHeight_txt").value = gaugeHeight;
}

function redraw(){
    for(var i=0;i<rangeCount;i++){
        gauge_draw(i);
    }
}

function redrawAll(){
    initGaugeData(rangeFrom,rangeTo);
    createTable(rangeCount,linesCount,"saGauge");
    initTitleParameters();
    redraw();
}

$(document).ready(function() {
    initTitleParameters();
    $.ajax({url: "conf/register.conf",type: "GET",dataType:'json',success:register_init});
});

function gauge_draw(idx) {  
    var g = gauge[idx];
    var chart = {      
      type: 'gauge',
      plotBackgroundColor: null,
      plotBackgroundImage: null,
      plotBorderWidth: 0,
      plotShadow: false
   };
   var title = {
      text: "ID: "+g.sid   
   }; 

   var credits = {
      text:'.',
      href:'http://www.casstk.com'
   };

   var pane = {
      startAngle: g.startAngle,
      endAngle: g.endAngle,
      background: [{
         backgroundColor: {
            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
            stops: [
               [0, '#FFF'],
               [1, '#333']
            ]
         },
         borderWidth: 0,
         outerRadius: '109%'
      }, {
         backgroundColor: {
            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
            stops: [
               [0, '#333'],
               [1, '#FFF']
            ]
         },
         borderWidth: 1,
         outerRadius: '107%'
     }, {
         // default background
     }, {
         backgroundColor: '#DDD',
         borderWidth: 0,
         outerRadius: '105%',
         innerRadius: '103%'
     }]
   };

   // the value axis
   var yAxis = {
      min: g.min,
      max: g.max,

      minorTickInterval: 'auto',
      minorTickWidth: 1,
      minorTickLength: 10,
      minorTickPosition: 'inside',
      minorTickColor: '#666',

      tickPixelInterval: 30,
      tickWidth: 2,
      tickPosition: 'inside',
      tickLength: 10,
      tickColor: '#666',
      labels: {
         step: 2,
         rotation: 'auto'
      },
      title: {
         text: g.unit
      },
    plotBands: [{
         from: g.min,
         to: (g.max - g.diff*(parseInt(100)-g.gy)/100),
         color: '#55BF3B' // green
      }, {
         from: (g.max - g.diff*(parseInt(100)-g.gy)/100),
         to: (g.max - g.diff*(parseInt(100)-g.yr)/100),
         color: '#DDDF0D' // yellow
      }, {
         from:(g.max - g.diff*(parseInt(100)-g.yr)/100),
         to: g.max,
         color: '#DF5353' // red
      }]
   };

   var series= [{
        name: g.unit_name,
        animation:false,
        data: [g.val],
        tooltip: {
           valueSuffix: ' '+g.unit
        }
   }];     

   var plotOptions = {
      series:{
           animation:false
       }
   };
      
   var json = {};   
   json.chart = chart; 
   json.title = title;       
   json.pane = pane; 
   json.yAxis = yAxis; 
   json.series = series;     
   json.plotOptions = plotOptions;
   json.credits = credits; 
   var chartFunction = function (chart) {
      if (!chart.renderer.forExport) {
         setInterval(function () {
         var point = chart.series[0].points[0];
         point.update(g.val);
         }, g.interval);
      }
   };

   $(g.id).highcharts(json,chartFunction);
}

function linescount_changed(me){
   //linesCount = document.getElementById("linesCount").value;
   linesCount = me.value;

   redrawAll();
}

function createTable(count,line,ctlID){
    var i=0,j=0,k=0;
    var cpl = parseInt(count/line)       //count per line
    var str="<table class='table table-striped table-condensed'><tbody>";
    for(k=0;k<line;k++){
        str = str+"<tr>";
        for(j=0;j<cpl;j++){
            i = k*cpl + j;
            str = str+"<td><p id='container"+i+"' style='width: "+gaugeWidth+"px; height: "+gaugeHeight+"px; margin: 0 auto'></p></td>";
        }
        str = str+"</tr>";
    }
    str = str + "</tbody></table>";
    document.getElementById(ctlID).innerHTML =str;
}

function gauge_setting_alarm(g){
    for(var i=0;i<regs.Sensors.Items.length;i++){
        var reg = regs.Sensors.Items[i];
        if(g.sid==reg.ID){
            var aid = reg.AlarmID;
            for(var j=0;j<alarms_cur.Items.length;j++){
                var a = alarms_cur.Items[j];
                if(a[0] == aid){
                    if((a[1] != g.min) || (a[2] != g.max) || (a[3] != g.gy) || (a[4] != g.yr)){
                       g.min = a[1];
                       g.max = a[2];
                       g.diff = g.max-g.min;
                       g.gy = a[3];
                       g.yr = a[4];
                        //Need redraw gauge with new value
                      redraw();
                    }
                }
            }
        }
    }
}

function gaugeWidth_changed(me){
   gaugeWidth = me.value;
   redrawAll();
}

function gaugeHeight_changed(me){
   gaugeHeight = me.value;;
   redrawAll();
}

function Refresh_new(){
    lng = lng+1;
    var nowTime = new Date().getTime();
    var url= "/data?time="+nowTime+"."+lng;
    $.ajax({url: url,type: "GET",dataType:'json',async:true,cache:true,timeout:5000,success:processData,complete:processData_complete});
}

function processData_complete(){
    setTimeout("Refresh_new()",dataRefreshInterval);
}

function processData(obj){
    
    document.getElementById("refCount").innerHTML = lng;
    if(refreshStart == 0){
        return;
    }
    if(rwlessCounter != obj.Value.Counter){
        barSeries=[]; 
        rwlessCounter = obj.Value.Counter;
        document.getElementById("saCounter").innerHTML = obj.Value.Counter;
        document.getElementById("saCounter_diff").innerHTML = obj.Value.Counter - counter_old;
        counter_old = obj.Value.Counter;
        
        for(var i=0;i< obj.Value.dt.length;i++){
            var tr_bk = "class='warning'";
            var matched = 0;
            if(obj.Value.dt[i][0] == 1){
                if(i<rangeFrom || i>rangeTo)continue;
                //Check sensor ID
                var d = parseInt(obj.Value.dt[i][1]);
                var v = parseFloat(obj.Value.dt[i][4]);
                
                gauge[i].val = v;
                gauge[i].sid = d;
                gauge_setting_alarm(gauge[i]);
            }
        }
    }
}

window.onload = function(){
}

$(function(){

    var obj = document.getElementById("ct");
    if(obj)obj.innerHTML = sa_menu_get_all_without_view();
    $("#saLogo").load("logo2.txt");

    $("[data-toggle='tooltip']").tooltip();
    msg_new_number_get_dsp();
    sa_lang_version(sa_lang_load_conf);
    sa_functions_control();
});
