
var ip = window.location.host.split(":")[0];

var resetModel = 1;
var resetT0 = 25.0;
var AC;
var sensors_cur;

function get_sensor_detail(id,sn,idx){
    var nowTime = new Date().getTime();
    $.getJSON("/getconf?name=sensors/"+sn+".sensor&time="+nowTime, function(data) {
        if(data != null){
            create_sensor_detail(id,data,idx);
            createExpressesList(id,data,idx);
            sa_lang_set_by_name(lang_sys,sa_lang_set_all);
        }
    });
}

function sensor_edit2(id,sn,me,idx){
    sensor_edit(id,sn,me,idx);
    $('#myTab li:eq(1) a').tab('show');
}

function sensor_edit(id,sn,me,idx){
   if(me){
        for(var i=0;i<sensors_cur.Items.length;i++){
            var bt = document.getElementById("bt_edit_"+i);
            bt.innerHTML = "&gt;&nbsp;&nbsp;";
            var tr = document.getElementById("tr_id_"+i);
            tr.setAttribute('bgcolor','#FFFFFF')
        }
        me.innerHTML = "&lt;&nbsp;&nbsp;";
        var tr = document.getElementById("tr_id_"+idx);
        tr.setAttribute('bgcolor','powderblue')
   } 
    get_sensor_detail(id,sn,idx);
    sensor_select_idx = parseInt(idx);
   // createRelationList(id,idx,sensors_cur);
}

function s_pn_changed(id,idx,me){
    sensors_cur.Items[idx].PN = parseInt(me.value);
    sensor_cur.PN = parseInt(me.value); 
}
function s_sn_changed(id,idx,me){
    sensors_cur.Items[idx].SN = me.value;
    sensor_cur.SN = me.value; 
}
function s_name_changed(id,idx,me){
    sensors_cur.Items[idx].Name = me.value;
    sensor_cur.Name = me.value; 
}
function s_memo_changed(id,idx,me){
    sensors_cur.Items[idx].Memo = me.value;
    sensor_cur.Memo = me.value; 
}
function s_type_changed(id,idx,me){
    sensors_cur.Items[idx].Type = parseInt(me.value);
    sensor_cur.Type = parseInt(me.value); 
}
function s_le_changed(id,idx,me){
    sensor_cur.Wavelength.LE= parseInt(me.value);
}
function s_ge_changed(id,idx,me){
    sensor_cur.Wavelength.GE = parseInt(me.value);
}
function s_min_changed(id,idx,me){
    sensor_cur.Wavelength.MIN = parseInt(me.value);
}
function s_max_changed(id,idx,me){
    sensor_cur.Wavelength.MAX = parseInt(me.value);
}

function s_ex_changed(id,idx,me){
    var et = eval('(' + me.value + ')');
    var wi = sensor_cur.Wavelength.MIN;
    var wa = sensor_cur.Wavelength.MAX;
    var err=0;
    for(var i=0;i<et.length;i++){
        var e = et[i];
        err=0;
        if(e.Wavelength.MIN < wi){
            e.Wavelength.MIN = wi;
            err = parseInt(err)+1;
        } 
        if(e.Wavelength.MAX > wa){
            e.Wavelength.MAX = wa;
            err = parseInt(err)+1;
        }
        if(err>0)break;
    }
    if(err>0){
        me.value = JSON.stringify(et);
        alert("Error Changed!");
    }
}

function sensor_detail_save(idx){
    //$.get("/setconf?name=sensors/"+sensor_cur.SN+".sensor&data="+encodeURIComponent("{\"Sensor\":"+JSON.stringify(sensor_cur)+"}")+"&type=json", function(data) {
    $.post("/setconf?name=sensors/"+sensor_cur.SN+".sensor&type=json",("{\"Sensor\":"+JSON.stringify(sensor_cur)+"}"), function(data) {
        if(data != null){
            reg_save(0);
            var httpcommand = "/command_std?par="+"../../bin/sad-load";
            $.get(httpcommand,function(data){
                if(data == null || data == ""){
                    alert("Sensor '"+sensor_cur.SN+"' saved!");
                }
                else{
                    alert(data);
                }
            });
        }
    });
}

function create_sensor_detail(id,s,idx){
    var sd = s.Sensor;
    sensor_cur = sd;
    var s_detail = "<table class='table table-striped table-condensed'>\
<tr><td><span>PN</span>:</td><td><input type='number' id='s_sn'  value='"+sd.PN+"' onChange='s_pn_changed("+id+","+sensor_select_idx+",this)'></td></tr>\
<tr><td><span>SN</span>:</td><td><input type='number' id='s_sn'  value='"+sd.SN+"' onChange='s_sn_changed("+id+","+sensor_select_idx+",this)'></td></tr>\
<tr><td><span>Name</span>:</td><td><input type='text' id='s_name' value='"+sd.Name+"' onChange='s_name_changed("+id+","+sensor_select_idx+",this)'></td></tr>\
<tr><td><span>Memo</span>:</td><td><input type='text' id='s_memo'  value='"+sd.Memo+"' onChange='s_memo_changed("+id+","+sensor_select_idx+",this)'></td></tr>\
<tr><td><span>Type</span>:</td><td><input type='number' id='s_type'  value='"+sd.Type+"' step='1' min='0' max='20' onChange='s_type_changed("+id+","+sensor_select_idx+",this)'></td></tr>\
<tr><td>&nbsp<span>Wavelength</span>:&nbsp</td><td>\
&nbsp;&ge;&nbsp;<input type='number' id='s_wl_ge'  value='"+sd.Wavelength.GE+"' step='1' min='0' max='1' onChange='s_ge_changed("+id+","+sensor_select_idx+",this)'>\
&nbsp<input type='number' id='s_wl_min'  value='"+sd.Wavelength.MIN+"' step='100' min='1500000' max='1600000' onChange='s_min_changed("+id+","+sensor_select_idx+",this)'>\
&nbsp;&le;&nbsp;<input type='number' id='s_wl_le'  value='"+sd.Wavelength.LE+"' step='1' min='0' max='1' onChange='s_le_changed("+id+","+sensor_select_idx+",this)'>\
&nbsp<input type='number' id='s_wl_max'  value='"+sd.Wavelength.MAX+"' step='100' min='1500000' max='1600000' onChange='s_max_changed("+id+","+sensor_select_idx+",this)'></td></tr>\
<tr>\
<td>&nbsp<span>Expresses</span>:&nbsp</td><td><div id='express2_list'></div></td>\
</tr>\
<tr>\
<td>&nbsp<span>Relations</span>:&nbsp</td><td><div id='relation_list'></div></td>\
</tr>\
</table>";
    document.getElementById("saSensorDetail").innerHTML=s_detail;
    createRelationList(id,idx,sensors_cur);
}


var sensor_new = {ID:0,SN:"000",Channel:0,Enable:1,WlRngExt:{Enable:0,WlRng:500,WlTriggerMin:20,WlTriggerMax:500},AlarmID:0,AlarmLevel:0,Location:"",File:"$path/000.sensor",Relations:""};
var sensor_new_detail = {Sensor:{PN:"0",SN:"000",Name:"N000",Memo:"",Type:0,Wavelength:{MIN:1525000,MAX:1525001,LE:0,GE:0},Expresses:[{Wavelength:{MIN:1525000,MAX:1525001,LE:0,GE:0},T0:25,WL0:1525000,TC:0.1,A:0,B:0,C:0,D:0,FUN:"w",Unit:"pm"}]}};

function sensor_changed_id(me){
    sensor_new.ID = parseInt(me.value);
}
function sensor_changed_sn(me){
    sensor_new.SN = me.value;
    sensor_new.File = "$path/" + me.value + ".sensor";
    sensor_new_detail.Sensor.SN = sensor_new.SN;
}
function sensor_changed_ch(me){
    sensor_new.Channel = parseInt(me.value);
}
function sensor_changed_alarm(me){
    sensor_new.AlarmID = parseInt(me.value);
}
function sensor_changed_location(me){
    sensor_new.Location = me.value;
}
function sensor_changed_ext(me){
    if(me.checked){
        sensors_new.WlRngExt.Enable = 1;
    }
    else{
        sensors_new.WlRngExt.Enable = 0;
    }
}

function sensor_changed_ext_wlrng(me){
    sensor_new.WlRngExt.WlRng = parseInt(me.value);
}

function sensor_changed_ext_wltriggermin(me){
    sensor_new.WlRngExt.WlTriggerMin = parseInt(me.value);
}

function sensor_changed_ext_wltriggermax(me){
    sensor_new.WlRngExt.WlTriggerMax = parseInt(me.value);
}

function sensor_changed_relations(me){
    sensor_new.Relations = me.value;
}

function reg_changed_ch(idx,me){
    sensors_cur.Items[idx].Channel = parseInt(me.value);
}
function reg_changed_alarm(idx,me){
    sensors_cur.Items[idx].AlarmID = parseInt(me.value);
}
function reg_changed_location(idx,me){
    sensors_cur.Items[idx].Location = me.value;
}
function reg_changed_ext(idx,me){
    if(me.checked){
        sensors_cur.Items[idx].WlRngExt.Enable = 1;
    }
    else{
        sensors_cur.Items[idx].WlRngExt.Enable = 0;
    }
}
function reg_changed_ext_wlrng(idx,me){
    sensors_cur.Items[idx].WlRngExt.WlRng = parseInt(me.value);
}
function reg_changed_ext_wltriggermin(idx,me){
    sensors_cur.Items[idx].WlRngExt.WlTriggerMin= parseInt(me.value);
}
function reg_changed_ext_wltriggermax(idx,me){
    sensors_cur.Items[idx].WlRngExt.WlTriggerMax= parseInt(me.value);
}
function reg_changed_relations(idx,me){
    sensors_cur.Items[idx].Relations = JSON.parse(me.value);
}
function reg_save(reloadFlag){
    $.post("/setconf?name=register.conf&type=json",("{\"Sensors\":"+JSON.stringify(sensors_cur)+"}"), function(data) {
        if(data != null){
            var httpcommand = "/command_std?par="+"../../bin/sad-load.sh";
            $.get(httpcommand,function(data){
                if(reloadFlag ==1)window.location.reload();
            });
        }
    });
}
function reg_save2(reloadFlag){
    $.get("/setconf?name=register.conf&data="+encodeURIComponent("{\"Sensors\":"+JSON.stringify(sensors_cur)+"}")+"&type=json", function(data) {
        if(data != null){
            var httpcommand = "/command_std?par="+"../../bin/sad-load.sh";
            $.get(httpcommand,function(data){
                if(reloadFlag ==1)window.location.reload();
            });
        }
    });
}


function sensor_del(idx){

    var i = sensors_cur.Items;
    var x = parseInt(idx);
    var msg = JSON.stringify(sensors_cur.Items[idx]);
    sensors_cur.Items = i.slice(0,x).concat(i.slice((x+1),i.length));
    reg_save(1);    
    alert("Deleted: "+msg);
}

function sensor_add(){

    sensors_cur.Items.push(sensor_new);
    reg_save(0);
    sensor_new_detail.Sensor.SN = document.getElementById("s_sn_2_va").value;
    sensor_new_detail.Sensor.Name = "N"+document.getElementById("s_sn_2_va").value;

    $.get("/setconf?name=sensors/"+sensor_new.SN+".sensor&data="+encodeURIComponent(JSON.stringify(sensor_new_detail))+"&type=json", function(data) {
        if(data != null){
            reg_save(1);
            var httpcommand = "/command_std?par="+"../../bin/sad-load.sh";
            $.get(httpcommand,function(data){
            });
        }
    });
}

function autoconf_init(){

    var nowTime = new Date().getTime();
    $.getJSON("/getconf?name=sas-autoconf.conf&time="+nowTime, function(data) {
        if(data != null){
            AC = data;
            
            document.getElementById("ac_id_start").value=data.id_start;
            document.getElementById("ac_pn").value=data.pn;
            document.getElementById("ac_sn_pre").value=data.sn_pre;
            document.getElementById("ac_name_pre").value=data.name_pre;
            document.getElementById("ac_type").value=data.type;
            document.getElementById("ac_tc").value=data.tc;
            document.getElementById("ac_t0").value=data.t0;
            document.getElementById("ac_fun").value=data.fun;
            document.getElementById("ac_unit").value=data.unit;
            document.getElementById("ac_wl_range_max").value=data.wlmax;
            if(data.method == 1){
                document.getElementById("ac_keep_chk").checked = true;
            }
            else{
                document.getElementById("ac_keep_chk").checked = false;
            }
            if(data.WlRngExt.Enable == 1){
                document.getElementById("ac_ext_chk").checked = true;
            }
            else{
                document.getElementById("ac_ext_chk").checked = false;
            }
            document.getElementById("ac_ext_wlrng").value=data.WlRngExt.WlRng;
            document.getElementById("ac_ext_wltriggermin").value=data.WlRngExt.WlTriggerMin;
            document.getElementById("ac_ext_wltriggermax").value=data.WlRngExt.WlTriggerMax;

            input_event();
        }
    });
}

function input_event(){
    $("input[id]").change(function(){
        var id = $(this).attr("id");
        var val = $(this).val();
        var val_int=0;
        var val_float=0;
        if(val == null || val == "")return;
        if(!isNaN(val)){
            val_int = parseInt(val);
            val_float = parseFloat(val);
        }
        if(id == "ac_id_start"){AC.id_start = val_int;return}; 
        if(id == "ac_pn"){AC.pn = val_int;return};
        if(id == "ac_sn_pre"){AC.sn_pre = val;return};
        if(id == "ac_name_pre"){AC.name_pre = val;return};
        if(id == "ac_type"){AC.type = val_int;return};
        if(id == "ac_tc"){AC.tc = val_float;return};
        if(id == "ac_t0"){AC.t0 = val_float;return};
        if(id == "ac_fun"){AC.fun = val;return};
        if(id == "ac_unit"){AC.unit = val;return};
        if(id == "ac_wl_range_max"){AC.wlmax = val_int;return};
        if(id == "ac_ext_wlrng"){AC.WlRngExt.WlRng = val_int;return};
        if(id == "ac_ext_wltriggermin"){AC.WlRngExt.WlTriggerMin = val_int;return};
        if(id == "ac_ext_wltriggermax"){AC.WlRngExt.WlTriggerMax = val_int;return};
        if(id == "ac_ext_chk"){
            if($(this).prop("checked")){
                AC.WlRngExt.Enable = 1;
            }
            else{
                AC.WlRngExt.Enable = 0;
            }
        }
        if(id == "ac_keep_chk"){
            if($(this).prop("checked")){
                AC.method = 1;
            }
            else{
                AC.method = 0;
            }
        }
    });
}


function auto_config(){
    $.get("/setconf?name=sas-autoconf.conf&data="+encodeURIComponent(JSON.stringify(AC))+"&type=json", function(data) {
        if(data != null){
            var httpcommand = "/command_std?par="+"../../bin/sas-autoconf";
            $.get(httpcommand,function(data){
                if(data == "" || data == null){
                    alert("OK!");
                }
                else{
                    alert(data);
                }
                window.location.reload();
            });
        }
    });
}

function create_sensor_list(obj_json,idx){
    var ss = obj_json.Sensors;
    sensors_cur = ss;
    var bt_remove="";
    var ext_checked = "checked";
    var tb_list = "<table class='table table-striped table-condensed'><thead><tr><th rowspan='2'>#</th><th rowspan='2'>ID</th><th rowspan='2'>SN</th><th rowspan='2'>Channel</th><th rowspan='2'>Alarm</th><th rowspan='2'>Location</th><th colspan='4'>WlRngExt</th><th rowspan='2'></th><th rowspan='2'></th></tr><tr><th>Enable</th><th>WlRng</th><th>WlTriggerMin</th><th>WlTriggerMax</th></tr></thead><tbody>";
    for(var i=0;i<ss.Items.length;i++){
        if(i){
            bt_remove="<a href='#' class='close' onclick='sensor_del("+i+")'><font color='FF0000'>&times;&nbsp;&nbsp;</font></a>";
        }
         var s = ss.Items[i];
         if(s.WlRngExt.Enable == "1"){
            ext_checked = "checked";
         }
         else{
            ext_checked = "";
         } 
         tb_list = tb_list + "<tr id='tr_id_"+i+"'> \
<td>"+parseInt(parseInt(i)+parseInt(1))+"</td>\
<td>"+s.ID+"</td>\
<td>"+s.SN+"</td>\
<td><input type='number' id='s_ch_"+s.ID+"' style='width: 40px' value='"+s.Channel+"' step='1' min='1' max='32' onChange='reg_changed_ch("+i+",this)'></td>\
<td><input type='number' id='s_alarm_"+s.ID+"' style='width: 40px' value='"+s.AlarmID+"' step='1' min='0' max='100' onChange='reg_changed_alarm("+i+",this)'></td>\
<td><input type='text' id='s_location_"+s.ID+"' style='width: 100px' value='"+s.Location+"' onChange='reg_changed_location("+i+",this)'></td>\
<td><input type='checkbox' id='s_ext_chk_"+s.ID+"' "+ext_checked+" onclick='reg_changed_ext("+i+",this)'></td>\
<td><input type='number' id='s_ext_wlrng_"+s.ID+"' style='width: 60px' value='"+s.WlRngExt.WlRng+"' step='10' min='1' max='100000' onChange='reg_changed_ext_wlrng("+i+",this)'></td>\
<td><input type='number' id='s_ext_wltriggermin_"+s.ID+"' style='width: 60px' value='"+s.WlRngExt.WlTriggerMin+"' step='10' min='1' max='100000' onChange='reg_changed_ext_wltriggermin("+i+",this)'></td>\
<td><input type='number' id='s_ext_wltriggermax_"+s.ID+"' style='width: 60px' value='"+s.WlRngExt.WlTriggerMax+"' step='10' min='1' max='100000' onChange='reg_changed_ext_wltriggermax("+i+",this)'></td>\
<td align='center'><a href='#' class='close' id='bt_edit_"+i+"' onclick='sensor_edit2("+s.ID+",\""+s.SN+"\""+",this,"+i+")'><font color='blue'>&gt;&nbsp;&nbsp;</font></a></td><td align='center'>"
+bt_remove+"</td></tr>";
    
    }

var s_new = ss.Items[i-1];
var expressString_new = JSON.stringify(s_new.Relations);
var j=parseInt(1) + parseInt(s_new.ID);

tb_list = tb_list + "<tr bgcolor='#DFFFDF'id='tr_id_"+i+"' > \
<td>"+parseInt(parseInt(i)+parseInt(1))+"</td>\
<td><input type='number' id='s_id_va' style='width: 40px' value='"+j+"' step='1' min='1' max='10000' onChange='sensor_changed_id(this)'></td>\
<td><input type='text' id='s_sn_2_va' style='width: 100px'value='"+j+"' onChange='sensor_changed_sn(this)'></td>\
<td><input type='number' id='s_ch_va' style='width: 40px' value='"+s_new.Channel+"' step='1' min='1' max='32' onChange='sensor_changed_ch(this)'></td>\
<td><input type='number' id='s_alarm_va' style='width: 40px' value='"+s_new.AlarmID+"' step='1' min='0' max='100' onChange='sensor_changed_alarm(this)'></td>\
<td><input type='text' id='s_location_va' style='width: 100px' value='"+s_new.Location+"' onChange='sensor_changed_location(this)'></td>\
<td><input type='checkbox' id='s_ext_chk_va' onclick='sensor_changed_ext("+i+",this)'></td>\
<td><input type='number' id='s_ext_wlrng_va' style='width: 60px' value='"+s_new.WlRngExt.WlRng+"' step='10' min='1' max='100000' onChange='sensor_changed_ext_wlrng("+i+",this)'></td>\
<td><input type='number' id='s_ext_wltriggermin_va' style='width: 60px' value='"+s_new.WlRngExt.WlTriggerMin+"' step='10' min='1' max='100000' onChange='sensor_changed_ext_wltriggermin("+i+",this)'></td>\
<td><input type='number' id='s_ext_wltriggermax_va' style='width: 60px' value='"+s_new.WlRngExt.WlTriggerMax+"' step='10' min='1' max='100000' onChange='sensor_changed_ext_wltriggermax("+i+",this)'></td>\
<td></td><td><a href='#' class='close' onclick='sensor_add()'><font color='0000FF'><span>+&nbsp;&nbsp;</span></font></a></td>\
</tr>";

   tb_list = tb_list + "</tbody></table>";
   document.getElementById("saSensorList").innerHTML=tb_list;
   
   sensor_new.ID = j;
   sensor_new.SN = j;
   sensor_new.Channel = s_new.Channel;
   sensor_new.Location = s_new.Location;
   sensor_new.Relations = s_new.Relations;
   sensor_new.File = "$path/"+sensor_new.SN+".sensor";

   var x =idx;
   var this_cur = document.getElementById("bt_edit_"+x);
   //sensor_edit(ss.Items[x].ID,ss.Items[x].SN,this_cur,x);
}

function sa_get_sensor_list(idx){
    var nowTime = new Date().getTime();
    $.getJSON("/getconf?name=register.conf&time="+nowTime, function(data) {
        if(data != null){
            create_sensor_list(data,idx);
        }
    });
}

$(function(){
    var obj = document.getElementById("ct");
    if(obj)obj.innerHTML = sa_menu_get_all_without_view();
    $("#saLogo").load("logo2.txt");
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var activeTab = $(e.target).text().split(".")[0];
        setCookie("sa_sensor_active_view",activeTab,30);    
    });
    $("[data-toggle='tooltip']").tooltip();
    msg_new_number_get_dsp();
    sa_functions_control();
});

function sa_reset_model_changed(me){
    resetModel = parseInt(me.options[me.selectedIndex].value);
}

function sa_reset_t0_changed(me){
    resetT0 = parseFloat(me.value);
}

function sa_reset_config(){
    var com = "../../bin/sa-sensor-reset all " + resetModel + " " + resetT0;
    var httpcommand = "/command_std?par="+com;
    $.get(httpcommand,function(data){
        if(data[0] == 'E'){
            alert(data);
        }
        else{
            if(data == "0"){
                alert("No change!");
            }
            else{
                alert("Complete!");
            }
        }
    });
}

