#!/bin/bash

CUR=$(dirname `readlink -f ${0}`)
cd $CUR

VERFILE="../conf/web/version.json"
TEMPFILE="sa.web"
DATAFILE="data.tar.gz"
SERVERPATH="root@112.74.80.60:/var/www/html/sa/web"

TARFILES[1]="../../conf/web"
TARFILES[0]=${TARFILES[1]}" ../../tools/node/http/webroot"
TARFILES[2]=${TARFILES[0]}" ../../conf/sensors ../../conf/register.conf ../../bin/*.sh"

#killall -9 sas sas2 sad tcpsvr-json report
cd ../
./sa.sh stop

cd bin/${TEMPFILE}
rm -rf ${DATAFILE}
tar -zcvf ${DATAFILE} ${TARFILES[${1}]}
cd ..
#Read version number and date
ver=`cat ${VERFILE} | grep 'Version' | awk -F'[' '{print $2}' | awk -F']' '{print $1}'| awk -F',' '{print $1$2$3"."$4"."$5}'`
dt=`date "+%Y%m%d"`

output="sa.web-"${ver}"-"${dt}".tar.gz"

rm -rf ${output}
tar -zcvf ${output} ${TEMPFILE}
scp ${output} ${VERFILE} ${SERVERPATH}

rm -rf ${output}
rm -rf ${TEMPFILE}/*.gz

echo "Output file:"
echo ${output}
echo "Create web update file. OK!"
