#!/bin/sh

#Heartbeat setting
HB_LABEL="sas"
HB_COMMAND="/root/sa/tools/wd/hb"

#Entry the current direction
CUR=$(dirname `readlink -f ${0}`)
cd $CUR

#Get configure file with app's name
#FNAME=`echo ${0} | awk -F '.' '{print $1}'`
FNAME=base

#Get Stop, Pause, Interval, Enable and Delay from configure file
. ./$FNAME.conf # or 'source ./$FNAME.conf to import global paramenters from configure file'

if [ $Stop -eq 1 ];then
    ./conf.sh Stop 0
fi

if [ $Enable -eq 0 ];then
    exit
fi

function nextcycle()
{
    sleep $Interval
    . ./$FNAME.conf #Reload the configure file to check the parameters whether be changed
}

while [[ $Enable -eq 1 ]]
do
    if [ $Stop -eq 1 ];then
        ./conf.sh Stop 0
        exit
    fi

    if [ $Pause -eq 1 ];then
        nextcycle
        continue
    fi
   
    RTN=`./sas-wd-dt`
    ERR=`echo $RTN | awk -F";" '{print $1}'` 
    MSG=`echo $RTN | awk -F";" '{print $2}'`
    DT_SYS=`echo $MSG | awk -F"," '{print $1}'`
    DT_RC_TIME=`echo $MSG | awk -F"," '{print $4}'`   
    DT_NOW=`echo $MSG | awk -F"," '{print $5}'`
    
    if [ $ERR -ne 0 ];then
        nextcycle
        continue
    fi

    if [ $DT_SYS -eq -1 ];then
        #heartbeat error
        nextcycle
        continue
    fi

    if [ $Level -eq 0 ];then
        let TimeDiff=$(($DT_NOW-$DT_RC_TIME))

        if [ $TimeDiff -gt 5 ];then
            nextcycle
            continue
        fi
    fi
    
    #Heartbeat right message
    $HB_COMMAND $HB_LABEL

nextcycle
done
