#!/bin/bash

SELF_VER1=1
SELF_VER2=0
SELF_VER3=4

cd ~

SASVR_IP="112.74.80.60"
SASVR_PATH="/sa/centos/"
GZFILE="sa.tar.gz"

DEBIAN_LABEL=`sudo cat /etc/issue | grep "Debian"`
if [ -n "$DEBIAN_LABEL" ]; then
    SASVR_PATH="/sa/debian/"
    sudo systemctl disable alsa-store.service
    sudo timedatectl set-timezone 'Asia/Shanghai'
fi 

RAS_LABEL=`sudo cat /etc/issue | grep "Raspbian"`
if [ -n "$RAS_LABEL" ]; then
    SASVR_PATH="/sa/raspbian/"
    sudo timedatectl set-timezone 'Asia/Shanghai'
fi 

#Date settting
SYSDT=`sudo cat /etc/profile | grep "TZ="`

if [ -z "$SYSDT" ];then
    sudo sed -i -e "s@export PATH@export TZ='Asia/Shanghai'\nexport PATH=\$TZ:\$PATH@g" /etc/profile
fi

#Get sas2 link
OLD_BIN_PATH=$(dirname `readlink -f sa/sa`)
cd $OLD_BIN_PATH/bin
LINK_SAS2=`readlink sas2`
cd -
#Get old IND and SN
SACONF=$(dirname `readlink -f sa/sa`)"/conf/sa.conf"

SAIDN=`cat $SACONF | grep "\"IDN\"" | awk -F'\"' '{print $4}'`
SASN=`cat $SACONF | grep "\"SN\"" | awk -F'\"' '{print $4}'`

rm -rf $GZFILE
SASVR_FILE="http://"${SASVR_IP}${SASVR_PATH}${GZFILE}
wget $SASVR_FILE

DT=`date '+%Y%m%d%H%M'`
BK_FILE="sa.bk."$DT
killall -9 sas sas2 tcpsvr-json report rpt di
mv -f sa $BK_FILE
tar -zxvf $GZFILE
rm -rf $GZFILE

if [ $SAIDN ];then
    NEW_BIN_PATH=$(dirname `readlink -f sa/sa`)
    cd $NEW_BIN_PATH/bin
    rm -rf sas2
    ln -s $LINK_SAS2 sas2
    cd ~
    SACONF2=$(dirname `readlink -f sa/sa`)"/conf/sa.conf"

    SAIDN2=`cat $SACONF2 | grep "\"IDN\"" | awk -F'\"' '{print $4}'`
    SASN2=`cat $SACONF2 | grep "\"SN\"" | awk -F'\"' '{print $4}'`

    sed -i "s/${SAIDN2}/${SAIDN}/g" $SACONF2
    sed -i "s/${SASN2}/${SASN}/g" $SACONF2
fi

cd $NEW_BIN_PATH/bin
bash link.sh
bash sa-recovery-create.sh
cd -

AUTOREBOOT=0

if [ "${1}"x = "autoreboot"x ];then
    let AUTOREBOOT=1
fi
if [ "${1}"x = "reboot"x ];then
    let AUTOREBOOT=1
fi
if [ "${1}"x = "ar"x ];then
    let AUTOREBOOT=1
fi

if [ "$AUTOREBOOT" -eq "1" ];then
    echo -e "Update OK!\nNow, reboot!"
    sudo reboot
    exit
fi

echo "------------"
echo "Install OK!"
echo "------------"

read -n 1 -p "Need reboot, do it now? [y/N] " rb
if [[ "$rb" == "y" ]]; then
    sudo reboot
fi

