#!/bin/bash

SELF_VER1=1
SELF_VER2=2
SELF_VER3=7

reboot2(){
    sudo killall -9 daq.sh 
    sleep 2
    sudo killall -9 sa-di 
    sleep 1
    sudo sync
    sudo sh -c 'echo b > /proc/sysrq-trigger'
}

rm2(){
    src=${1}
    line=`ls $src | wc -l`

    if [[ $line -ge 1 ]];then
        sudo rm -rf $src $dest
    fi  
}

cp2(){
    src=${1}
    dest=${2}
    line=`ls $src | wc -l`

    if [[ $line -ge 1 ]];then
        sudo /bin/cp -rf $src $dest
    fi  
}


conf_import(){
    if [[ -z "${2}" ]];then
        echo "Need two file: bin,source,dest"
        return
    fi  
    JSON_CONF="/var/sa/bin/json-conf"
    SF=${1}
    DF=${2}
    line=`ls $SF | wc -l`
    if [[ $line -eq 0 ]];then
        return
    fi  
    line=`ls $DF | wc -l`
    if [[ $line -eq 0 ]];then
        return
    fi  
    echo "========================"
    echo "SF: "${SF}
    echo "DF: "${DF}
    echo "------------------------"
    $JSON_CONF -f $SF | awk -F"," '{print $1}' | while read line
    do
        num=`echo $line | wc -L`
        if [[ $num -ne 0 ]];then
            ID=`echo $line | awk -F"," '{print $1}'`
            VAL=`${JSON_CONF} -f ${SF} -i ${ID}`
            if [[ -n "$ID" ]];then
                if [[ -n "$VAL" ]];then
                    let count+=1
                    echo -e $count"\t"${ID}"\t:\t"${VAL}
                    $JSON_CONF -f $DF -i $ID -v $VAL
                fi  
            fi  
        fi
    done

}

conf_import2(){
    src=${1}
    dest=${2}

    line=`ls $src | wc -l`
    if [[ $line -eq 0 ]];then
        return;
    fi  
    line=`ls $dest | wc -l`
    if [[ $line -eq 0 ]];then
        return;
    fi  
    conf_import $src $dest
}

GZFILE="sa.tar.gz"

cd ~

sa_dir=`ls /var/sa | wc -l`

haveOldConf=0

if [[ $sa_dir -ge 1 ]];then
    #Get old IND and SN
    SACONF="/var/sa/conf/sa.conf"

    conf_dir=`ls /var/sa/conf/sa.conf | wc -l`
    if [[ $conf_dir -ge 1 ]];then

        SAIDN=`cat $SACONF | grep "\"IDN\"" | awk -F'\"' '{print $4}'`
        SASN=`cat $SACONF | grep "\"SN\"" | awk -F'\"' '{print $4}'`

        DT=`date '+%Y%m%d%H%M'`
        BK_FILE="sa.bk."$DT
        sudo killall -9 daq.sh sa-di lighttpd

        mv -f sa $BK_FILE
        tar -zxvf $GZFILE
        mv -f $GZFILE .$GZFILE

        if [ -n "$SAIDN" ]; then

            SAIDN2=`cat $SACONF | grep "\"IDN\"" | awk -F'\"' '{print $4}'`
            sed -i "s/${SAIDN2}/${SAIDN}/g" $SACONF

            if [ -n "$SASN" ];then
                SASN2=`cat $SACONF | grep "\"SN\"" | awk -F'\"' '{print $4}'`
                sed -i "s/${SASN2}/${SASN}/g" $SACONF
            fi
        fi

        haveOldConf=1
    else
        tar -zxvf $GZFILE
        mv -f $GZFILE .$GZFILE
    fi
else
    sudo ln -s /home/debian/sa /var/sa
    tar -zxvf $GZFILE
    mv -f $GZFILE .$GZFILE
fi	

NEW_CONF_PATH="/var/sa"

#Enable watchdog
wd="/var/sa/bin/watchdog_alive"
line=`ls $wd | wc -l`
if [[ $line -ge 1 ]];then
	sudo $wd &
fi  

if [[ $haveOldConf -eq 1 ]];then

    cp2 $BK_FILE/web/logo* $NEW_CONF_PATH/web/
    cp2 $BK_FILE/web/images $NEW_CONF_PATH/web/images
    cp2 $BK_FILE/web/equ.gif $NEW_CONF_PATH/web/
    #/bin/cp $BK_FILE/bin/daq.sh $NEW_CONF_PATH/bin/daq.sh
    conf_import2 $BK_FILE/conf/di.json $NEW_CONF_PATH/conf/di.json
    conf_import2 $BK_FILE/conf/datafilting.json $NEW_CONF_PATH/conf/datafilting.json
    conf_import2 $BK_FILE/conf/quick-calcs.json $NEW_CONF_PATH/conf/quick-calcs.json
    conf_import2 $BK_FILE/conf/deviation_detection.json $NEW_CONF_PATH/conf/deviation_detection.json
    conf_import2 $BK_FILE/conf/global-variable.json $NEW_CONF_PATH/conf/global-variable.json
    conf_import2 $BK_FILE/conf/autoconf_base.json $NEW_CONF_PATH/conf/autoconf_base.json
    conf_import2 $BK_FILE/conf/fansensor2.json $NEW_CONF_PATH/conf/fansensor2.json
    conf_import2 $BK_FILE/conf/fansensor3.json $NEW_CONF_PATH/conf/fansensor3.json
    conf_import2 $BK_FILE/conf/data-save-sqlite3.json $NEW_CONF_PATH/conf/data-save-sqlite3.json
    conf_import2 $BK_FILE/conf/rpt-udp-source.json $NEW_CONF_PATH/conf/rpt-udp-source.json
    conf_import2 $BK_FILE/conf/web-data-source.json $NEW_CONF_PATH/conf/web-data-source.json
    conf_import2 $BK_FILE/conf/functions_full.json $NEW_CONF_PATH/conf/functions_full.json
    conf_import2 $BK_FILE/conf/rpt-tcp-pj.json $NEW_CONF_PATH/conf/rpt-tcp-pj.json
    conf_import2 $BK_FILE/conf/rpt-udp-pj.json $NEW_CONF_PATH/conf/rpt-udp-pj.json

    conf_import2 $BK_FILE/conf/warnings_main.json $NEW_CONF_PATH/conf/warnings_main.json
    conf_import2 $BK_FILE/conf/warnings_conf_1.json $NEW_CONF_PATH/conf/warnings_conf_1.json
    conf_import2 $BK_FILE/conf/warnings_conf_2.json $NEW_CONF_PATH/conf/warnings_conf_2.json
    conf_import2 $BK_FILE/conf/warnings_conf_3.json $NEW_CONF_PATH/conf/warnings_conf_3.json

    conf_import2 $BK_FILE/conf/virtual_sensors.json $NEW_CONF_PATH/conf/virtual_sensors.json

    cp2 $BK_FILE/conf/register.conf $NEW_CONF_PATH/conf/register.conf
    cp2 $BK_FILE/conf/sensors $NEW_CONF_PATH/conf/
    rm2 $NEW_CONF_PATH/conf/sensors/sensors

    cp2 $BK_FILE/conf/register_vss.conf $NEW_CONF_PATH/conf/register_vss.conf
    cp2 $BK_FILE/conf/vss $NEW_CONF_PATH/conf/

    cp2 $BK_FILE/data $NEW_CONF_PATH/data
    rm2 $BK_FILE/data

fi

cd /var/sa/bin
bash link.sh
bash sa-recovery-create.sh
cd -

AUTOREBOOT=0

if [ "${1}"x = "autoreboot"x ];then
    let AUTOREBOOT=1
fi
if [ "${1}"x = "reboot"x ];then
    let AUTOREBOOT=1
fi
if [ "${1}"x = "ar"x ];then
    let AUTOREBOOT=1
fi

if [ "${2}"x = "autoreboot"x ];then
    let AUTOREBOOT=1
fi
if [ "${2}"x = "reboot"x ];then
    let AUTOREBOOT=1
fi
if [ "${2}"x = "ar"x ];then
    let AUTOREBOOT=1
fi

if [ "${3}"x = "autoreboot"x ];then
    let AUTOREBOOT=1
fi
if [ "${3}"x = "reboot"x ];then
    let AUTOREBOOT=1
fi
if [ "${3}"x = "ar"x ];then
    let AUTOREBOOT=1
fi

if [ "$AUTOREBOOT" -eq "1" ];then
    echo -e "Update OK!\nNow, reboot!"
    reboot2
    exit
fi

echo "------------"
echo "Install OK!"
echo "------------"

read -n 1 -p "Need to reboot system, do it now? [y/N] " rb
if [[ "$rb" == "y" ]]; then
    reboot2
    exit
fi

