var FA;

var faDefaultParamete={
		Version: 100,
		IDN: "equIDN",
		SN: "equSN",
		RS232_Port: "/dev/ttyS1",
		RS232_Baudrate: 19200,
		ModbusServerID:1,
		ActionTempID:1,
		Channel: 16,
		SensorCountPerChannel: 20,
		Offset: 0,
                Memo:"",
                LineOffsetStart:0,
                SensorSnStart:100,
                SensorOffsetInterval:10
}

$(document).ready(function(){
    var p = faDefaultParamete;
    $("input[id]").change(function(){
        var id = $(this).attr("id");
        var val = $(this).val();
        var val_int=0;
        if(val == null || val == "")return;
        if(!isNaN(val)){
            val_int = parseInt(val);
        }

        if(id == "fa_version"){FA.Base.Version = val_int;return}; 
        if(id == "fa_idn"){FA.Base.IDN = val;return};
        if(id == "fa_sn"){FA.Base.SN = val;return};
        if(id == "fa_rs232_port"){FA.Equipment.RS232_Port = val;return};
        if(id == "fa_rs232_rate"){FA.Equipment.RS232_Baudrate = val_int;return};
        if(id == "fa_mb_id"){FA.Equipment.ModbusServerID = val_int;return};
        if(id == "fa_actiontemp_id"){FA.Equipment.ActionTempID = val_int;return};
        if(id == "fa_linesoffset"){FA.Lines.Offset = val_int;return};
        if(id == "fa_linesmemo"){FA.Lines.Memo = val;return};

        if(id == "fa_version_t"){p.Version = val_int;return}; 
        if(id == "fa_idn_t"){p.IDN = val;return};
        if(id == "fa_sn_t"){p.SN = val;return};
        if(id == "fa_rs232_port_t"){p.RS232_Port = val;return};
        if(id == "fa_rs232_rate_t"){p.RS232_Baudrate = val_int;return};
        if(id == "fa_mb_id_t"){p.ModbusServerID = val_int;return};
        if(id == "fa_actiontemp_id_t"){p.ActionTempID = val_int;return};
        if(id == "fa_channel_t" && val_int <= 32 && val_int > 0){p.Channel = val_int;return};
        if(id == "fa_sensorcountperchannel_t" && val_int <= 20 && val_int > 0){p.SensorCountPerChannel = val_int;return};
        if(id == "fa_linesoffset_t"){p.Offset = val_int;return};
        if(id == "fa_linesmemo_t"){p.Memo = val;return};
        if(id == "fa_lineoffsetstart_t"){p.LineOffsetStart = val_int;return};
        if(id == "fa_sensorsnstart_t"){p.SensorSnStart = val_int;return};
        if(id == "fa_sensoroffsetinterval_t" && val_int > 0){p.SensorOffsetInterval = val_int;return};

    });

//    $("td:odd").css("color","blue");

    $("#bt_templete_create").click(function(){
        fa_templete_new_default();
    });
    $("#bt_fa_save").click(function(){
        fa_save();
    });

    //$(".fa-line").click(function(){alert(1);});


    //fa_list_load();
    fa_setting_base_load();
    fa_setting_threshold_load();

});

function fa_templete_default_load(){
    var p = faDefaultParamete;
    $("#fa_version_t").val(p.Version);
    $("#fa_idn_t").val(p.IDN);
    $("#fa_sn_t").val(p.SN);
    
    $("#fa_rs232_port_t").val(p.RS232_Port);
    $("#fa_rs232_rate_t").val(p.RS232_Baudrate);
    
    $("#fa_mb_id_t").val(p.ModbusServerID);
    $("#fa_actiontemp_id_t").val(p.ActionTempID);
    $("#fa_linesoffset_t").val(p.Offset);
    $("#fa_linesmemo_t").val(p.Memo);

    $("#fa_channel_t").val(p.Channel);
    $("#fa_sensorcountperchannel_t").val(p.SensorCountPerChannel);
    $("#fa_offset_t").val(p.Offset);
    $("#fa_lineoffsetstart_t").val(p.LineOffsetStart);
    $("#fa_sensorsnstart_t").val(p.SensorSnStart);
    $("#fa_sensoroffsetinterval_t").val(p.SensorOffsetInterval);
}

function fa_setting_base_load(){
    $.get("/getconf?name=fa.conf", function(dt) {
        if(isJSON(dt)){
            data = JSON.parse(dt);
            FA = data;
            faDefaultParamete.Version = data.Base.Version;
            faDefaultParamete.IDN= data.Base.IDN;
            faDefaultParamete.SN= data.Base.SN;
            faDefaultParamete.RS232_Port= data.Equipment.RS232_Port;
            faDefaultParamete.RS232_Baudrate= data.Equipment.RS232_Baudrate;
            faDefaultParamete.ModbusServerID= data.Equipment.ModbusServerID;
            faDefaultParamete.ActionTempID= data.Equipment.ActionTempID;
            faDefaultParamete.Offset= data.Lines.Offset;
            faDefaultParamete.Memo= data.Lines.Memo;

             var p = faDefaultParamete;
            $("#fa_version").val(p.Version);
            $("#fa_idn").val(p.IDN);
            $("#fa_sn").val(p.SN);
            $("#fa_rs232_port").val(p.RS232_Port);
            $("#fa_rs232_rate").val(p.RS232_Baudrate);
            $("#fa_mb_id").val(p.ModbusServerID);
            $("#fa_actiontemp_id").val(p.ActionTempID);
            $("#fa_linesoffset").val(p.Offset);
            $("#fa_linesmemo").val(p.Memo);
            $("#fa_channel").val(p.Channel);
            $('#fa_channel').attr("readonly",true);
            $("#fa_sensorcountperchannel").val(p.SensorCountPerChannel);
            $('#fa_sensorcountperchannel').attr("readonly",true);

            fa_list_load();
        } 
        fa_templete_default_load();
    });
}

function fa_setting_threshold_load(){
    $.getJSON("/getconf?name=fa-threshold.conf", function(data) {
        if(data != null){
            var tba = document.getElementById("tb_ActionTemp");
            var tbt = document.getElementById("tb_TempResponseTime");
            var tbr = document.getElementById("tb_TempRiseResponseTime");

            for(var i=0;i<data.ActionTemp.length;i++){
                var at = data.ActionTemp[i];
                var row = tba.insertRow(-1);
                cell = row.insertCell(-1);
                cell.innerHTML=at.ID;
                cell = row.insertCell(-1);
                cell.innerHTML=at.On;
                cell = row.insertCell(-1);
                cell.innerHTML=at.Off;
            }
            for(var i=0;i<data.TempResponseTime.length;i++){
                var at = data.TempResponseTime[i];
                var row = tbt.insertRow(-1);
                cell = row.insertCell(-1);
                cell.innerHTML=at.ID;
                cell = row.insertCell(-1);
                cell.setAttribute("align","right");
                cell.innerHTML="&ge;";
                cell = row.insertCell(-1);
                cell.innerHTML=at.ActionTemp.MIN.VAL;
                cell = row.insertCell(-1);
                cell.setAttribute("align","right");
                cell.innerHTML='&lt;';
                cell = row.insertCell(-1);
                cell.innerHTML=at.ActionTemp.MAX.VAL;
                cell = row.insertCell(-1);
                cell.setAttribute("align","right");
                cell.innerHTML='&le;';
                cell = row.insertCell(-1);
                cell.innerHTML=at.ResponseTime.MAX.VAL;
            }
            for(var i=0;i<data.TempRiseResponseTime.length;i++){
                var at = data.TempRiseResponseTime[i];
                var row = tbr.insertRow(-1);
                cell = row.insertCell(-1);
                cell.innerHTML=at.ID;
                cell = row.insertCell(-1);
                cell.setAttribute("align","right");
                cell.innerHTML="&ge;";
                cell = row.insertCell(-1);
                cell.innerHTML=at.TempRiseRate.MIN.VAL;
                cell = row.insertCell(-1);
                cell.setAttribute("align","right");
                cell.innerHTML='&ge;';
                cell = row.insertCell(-1);
                cell.innerHTML=at.ResponseTime.MIN.VAL;
                cell = row.insertCell(-1);
                cell.setAttribute("align","right");
                cell.innerHTML='&le;';
                cell = row.insertCell(-1);
                cell.innerHTML=at.ResponseTime.MAX.VAL;
            }
        }
    });
}


window.onload = function(){
}

$(function(){
    $("#ct").html(sa_menu_get_all_without_view());
    $("#saLogo").load("logo2.txt");

    $("[data-toggle='tooltip']").tooltip();
    
    var v = parseInt(GetQueryString("View"));
    if(v ==3){
        $("#myTab li:eq(2) a").tab('show');
    }
    msg_new_number_get_dsp();
    sa_lang_version(sa_lang_load_conf);
    
});


function fa_templete_sensor_new(idstart,status,offsetstart,offsetinterval,sensoridstart,sensoridinterval,sensorchannel,sensorsnstart,sensorsninterval,sensornumber){
    var arr=[];
    var id = idstart;
    var offset = offsetstart;
    var sensorid = sensoridstart;
    var sensorsn = sensorsnstart;
    for(var i=0;i<sensornumber;i++){
        arr.push([id,status,offset,sensorid,sensorchannel,sensorsn,0]);
        id+=1;
        offset+=offsetinterval;
        sensorid+=sensoridinterval;
        sensorsn+=sensorsninterval;
    }
    return arr;
}

function fa_templete_line_items_new(channel,sensorcountperchannel,lineoffsetstart,lineoffsetinterval,memo,labelpre,sensorsnstart,sensoroffsetinterval){
    var arr=[];

    for(var i=0;i<channel;i++){
        var id = parseInt(i)+parseInt(1);
        arr.push(
                {
                    ID:id,
                    ChannelID:id,
                    Label:labelpre+id,
                    Offset:parseInt(lineoffsetstart)+parseInt(i*lineoffsetinterval),
                    Enable:0,
                    Memo:memo,
                    Sensors:fa_templete_sensor_new(parseInt(1)+parseInt(i*sensorcountperchannel),
                            0,
                            0,
                            sensoroffsetinterval,
                            parseInt(1)+parseInt(i*sensorcountperchannel),
                            1,
                            id,
                            parseInt(sensorsnstart)+parseInt(i*sensorcountperchannel),
                            1,
                            sensorcountperchannel)
                }
                );
    }

    return arr;
}

function fa_templete_new(p){

    var obj={
            Base:{
                Version: p.Version,
                IDN: p.IDN,
                SN: p.SN
            },
            Equipment:{
                RS232_Port: p.RS232_Port,
                RS232_Baudrate: p.RS232_Baudrate,
                ModbusServerID:p.ModbusServerID,
                ActionTempID:p.ActionTempID
            },
            Lines:{
                Channel: p.Channel,
                SensorCountPerChannel: p.SensorCountPerChannel,
                Offset: p.Offset,
                Memo:p.Memo,
                SensorKey:["ID","Status","Offset","SensorID","SensorChannel","SensorSN","Value"],
                Items:fa_templete_line_items_new(
                        p.Channel,
                        p.SensorCountPerChannel,
                        p.LineOffsetStart,
                        p.SensorCountPerChannel*p.SensorOffsetInterval,
                        //p.LineOffsetInterval,
                        "",
                        "L",
                        p.SensorSnStart,
                        p.SensorOffsetInterval
                        )
            }
    };
    return obj;
}

function fa_templete_new_default(){
    var obj = fa_templete_new(faDefaultParamete);
    $.get("/setconf?name=fa.conf&data="+JSON.stringify(obj)+"&type=json", function(data) {
        if(data != null){
            alert("Create OK!");
            window.location.reload();
        }
    });
}

function fa_save(){
    $.get("/setconf?name=fa.conf&data="+JSON.stringify(FA)+"&type=json", function(data) {
        if(data != null){
            alert("Save OK!");
            window.location.reload();
        }
    });
}


var ctl_id="";
var ctl_cv="";

function fa_btn_change(me){
    var ctl = document.getElementById(ctl_id);
    if(ctl){
        if(ctl_cv != ""){
            $(ctl).attr("class", ctl_cv);
        }
    }
    ctl_id = $(me).attr("id");
    ctl_cv = $(me).attr("class");
    $(me).attr("class", "btn btn-primary btn-xs");
}

function fa_list_load(){
    
    var tb_list = "<table class='table table-striped table-condensed'><tbody>";
    for(var i=0;i<16;i++){
        var l_id = "l_"+i;
        tb_list = tb_list + "<tr onmousemove='function(){$(this).css(\"cursor\", \"pointer\");}'><td width='10%' align='right' style='align:right;width:10%;'><button style='width:60px;' type='button' class='btn btn-default btn-xs fa fa-line' id='"+l_id+"'>L"+parseInt(parseInt(i)+1)+"</span></td><td style='align:left;' width='30'><div class='btn-group'>"
        for(var j=0;j<20;j++){
            var s_id = "s_"+i+"_"+j;
            tb_list = tb_list + "<button style='width:40px;'  type='button' class='btn btn-default btn-xs fa fa-sensor' id='"+s_id+"'>"+parseInt(parseInt(i*20)+parseInt(j)+1)+"</button>";
        }
        tb_list = tb_list + "</div></td></tr>"
    }

    tb_list = tb_list + "</tbody></table>";
    document.getElementById("tb_fa_list").innerHTML=tb_list;
   // $("#l_1").attr("class", "btn btn-warning btn-xs");
   
    $(".fa").click(function(){
        //Change the backgroud.
        var ctl = document.getElementById(ctl_id);
        if(ctl){
            if(ctl_cv != ""){
                $(ctl).attr("class", ctl_cv);
            }
        }
        ctl_id = $(this).attr("id");
        ctl_cv = $(this).attr("class");
        $(this).attr("class", "btn btn-primary btn-xs");
    });

    fa_sensor_status_set();
}

function fa_sensor_status_set(){
    var a = 0;
    var items = FA.Lines.Items;
   $(".fa-line").each(function(){
       var l_id = $(this).attr("id").split("_")[1];
       if(items[l_id].Enable){
           $(this).attr("class", "btn btn-success btn-xs");
       }
   });
   $(".fa-sensor").each(function(){
       var s_x = $(this).attr("id").split("_")[1];
       var s_y = $(this).attr("id").split("_")[2];
       var sta = items[s_x].Sensors[s_y][1];
       if(sta == 1){
           $(this).attr("class", "btn btn-success btn-xs");
       }
       if(sta == -1){
           $(this).attr("class", "btn btn-warning btn-xs");
       }
       if(sta == -2){
           $(this).attr("class", "btn btn-danger btn-xs");
       }
   });
}
