#!/bin/sh

#Entry the current direction
CUR=$(dirname `readlink -f ${0}`)
cd $CUR

#Get configure file with app's name
#FNAME=`echo ${0} | awk -F '.' '{print $1}'`
FNAME=base
WD_LOG=log

/bin/mv -f $WD_LOG $WD_LOG~

#Get Stop, Pause, Interval, Enable and Delay from configure file
. ./$FNAME.conf # or 'source ./$FNAME.conf to import global paramenters from configure file'

if [ $Stop -eq 1 ];then
    ./conf.sh Stop 0
fi

if [ $Enable -eq 0 ];then
    exit
fi

sleep $Delay

while [[ $Enable -eq 1 ]]
do
    if [ $Stop -eq 1 ];then
        ./conf.sh Stop 0
        exit
    fi

    if [ $Pause -eq 1 ];then
        #echo "Paused"
        sleep $Interval
        . ./$FNAME.conf #Reload the configure file to check the parameters whether be changed
        continue
    fi

while read LINES
do
    fname_wd=`echo $LINES | cut -f1 -d','`          #Get wd file name with path from the fist column in apps.conf
    interval_time=`echo $LINES | cut -f2 -d','`     #Get interval time from 2 column
    err_level=`echo $LINES | cut -f3 -d','`         #Get hightest error level from 3 column
    p1=`echo $LINES | cut -f4 -d','`                #Get the first process method from 4 column
    p2=`echo $LINES | cut -f5 -d','`                #Get the sencod process from 5 column
    p3=`echo $LINES | cut -f6 -d','`                #Get the third process from 6 column
    file_wd=`cat $fname_wd`                         #Get wd file content
    if [ -n "$file_wd" ];then                       #Check the file content is null           
        err2=`echo $file_wd | awk '{print $1}'`      #Get the wd error code
        tm=`echo $file_wd | awk '{for(i=2;i<=3;i++)printf $i " ";printf"\n"}'`  #Get wd last write time               
        
        #New added
        set AllErr=0
        if [ $err2 -eq 0 ];then
            if [ -n "$tm" ];then
                let time_diff=$(date +%s)-$(date -d "$tm" +%s) 
                #Check the heart beat time whether longer then interval time
                if [ $time_diff -gt $interval_time ];then                    
                    let AllErr=1
                fi
            fi
        else
            let AllErr=1
        fi
       
        if [ $AllErr -gt 0 ];then
                if [ $err2 -lt $err_level ];then
                    let err=$err2+1
                else
                    let err=1
                fi
                #echo $err, "incread the err code"
                #Get the error process method (pm)
                if [[ $err -eq 1 ]];then
                    pm=$p1
                elif [[ $err -eq 2 ]];then
                    pm=$p2
                elif [[ $err -eq 3 ]];then
                    pm=$p3
                fi
                #Excute error process method and update wd data file
                #Incread the error code and heart beat time in wd data file
                echo -e "$err\n$(date '+%Y-%m-%d %H:%M:%S')" > $fname_wd
                #echo -e "$err\n$tm" > $fname_wd
                #Clear the lable '"' in comand string
                pm_cmd=`echo $pm | sed 's/"//g'`
                #Excute the command
                $pm_cmd
                echo -e "$(date '+%Y-%m-%d %H:%M:%S') $pm_cmd" >> $WD_LOG
                #echo -e "$(date '+%Y-%m-%d %H:%M:%S') $pm_cmd"
                #echo "==============================="
    
        fi
    fi
done < `echo apps.conf`

sleep $Interval
. ./$FNAME.conf #Reload the configure file to check the parameters whether be changed

done
