#!/bin/bash

CUR=$(dirname `readlink -f ${0}`)
cd $CUR

SACONF="../conf/sa.conf"

SAIDN=`cat $SACONF | grep "\"IDN\"" | awk -F'\"' '{print $4}'`
SASN=`cat $SACONF | grep "\"SN\"" | awk -F'\"' '{print $4}'`

if [ ! $1 ];then
    echo "IDN: "$SAIDN
    echo " SN: "$SASN
    exit
fi
if [ ! $2 ];then
    echo "Need IDN and SN!"
    exit
fi

sed -i "s/${SAIDN}/${1}/g" $SACONF
sed -i "s/${SASN}/${2}/g" $SACONF
