#ifndef SADS_H_INCLUDED
#define SADS_H_INCLUDED

#include <time.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>

#include <sys/ipc.h>
#include <sys/shm.h>

#define BASE_SHM_ID 90000

int ChannelIncludeSource;
int Channel_Count;

#define RD_MAX (unsigned long)1250000
unsigned long AIRate;
unsigned long AORate;

#define CHANNEL_MAX 34
#define WLS_MAX 100 //解调出来的波长内存存放数量
#define RAW_WL_MAX 600 //解调出来的波长内存存放数量

#define FBG_ALARMS_MAX 100
#define FBG_DATA_MAX 200 //应变光栅最大数据内存数量
#define FBG_ALARM_MSGS_MAX 200

#define DA_ADJUSTS_MAX 35
#define DA_FUNCTION_MAX 50
#define ALARM_LEVELS_MAX 3
#define ALARMS_MAX 20

#define SNMP_TRAP_SERVERIPS_MAX 20
#define LANGUAGES_MAX 5
#define REGISTER_RELATIONS_MAX 10
#define SENSORS_MAX 250
#define SENSORS_FRQ_MAX 20
#define SENSOR_EXPRESSES_MAX 20

#define JSON_SOURCE_SA_LENGTH (unsigned long)1024*20
#define JSON_SOURCE_CALIBRATE_LENGTH (unsigned long)1024*10
#define JSON_SOURCE_REGISTER_LENGTH (unsigned long)1024*20

typedef struct
{
        int Lock;
        long Counter;      //变化累加计数器
        int EditStatus;    // -1 删除；0 正常；1：改动；2:新增加;-2 增加后删除的
        int PorcessMethod;   // 0:不变；1：保存；-1：恢复
        int ProcessLevel; //处理级别 1～5级别
}UpdateStatus;

typedef struct
{
        long Crt;       //当前指针
        long Count;     //实际数量
        long Max;       //最大数量
        long MaxIndex;  //当前记录的最大索引值
}Size;

void ResetUpdateStatus(UpdateStatus *us);
void SetSize(Size *sz,long Max,long Count,long Crt,long MaxIndex);

typedef struct
{
        int channel;
        double dt[RD_MAX];
        UpdateStatus us;
        Size sz;
}RawData;

typedef struct
{
    char Variable[20];
    char Path[125];
    char Path2[125];
    UpdateStatus us;
}_Root;

typedef struct
{
  char IDN[50];
  char SN[50];
  char Version[20];
  char Copyright[100];
  char Website[100];
  char Memo[125];
  UpdateStatus us;
}_Equipment;


////UI start
typedef struct
{
  int Visible;
  int FBGDetail;
  UpdateStatus us;
}_ConsolePrint;

typedef struct
{
  int Save;
  int SaveStart;
  int Interval;
  int IntervalCount;
  char Direction[125];
  char Direction2[125];
  int FileFormat;
  char FileNameFormat[125];
  char OldPath[125];
  UpdateStatus us;
  Size sz;
  int page;
}_DataSave;

typedef struct
{
  _DataSave Raw;
  _DataSave OS;
  _DataSave Sensor;
  UpdateStatus us;
}_DataSaves;

typedef struct
{
  _ConsolePrint ConsolePrint;
  _DataSaves DataSaves;
  UpdateStatus us;
}_UI;
//UI end

//InternalCommunication start
typedef struct
{
    long RD;
    long RWLSS;
    long RWLESS;
    long SA;
    UpdateStatus us;
}_SHMIDs;

typedef struct
{
    char PORT[20];
    char CMD[20];
    char LABEL[20];
    UpdateStatus us;
}_RS232;

typedef struct
{
    _SHMIDs SHMIDs;
    _RS232 RS232;
    UpdateStatus us;
}_InternalCommunication;
//InternalCommunication end

//Etalon start
typedef struct
{
    float TC;
    float T0;
    long WL;
    float LOFS_MIN;
    float LOFS_MAX;
    UpdateStatus us;
}_Refrence;

typedef struct
{
    _Refrence Left;
    _Refrence Right;
    int Visible;
    int AscendingOrder;
    char WavelengthAdjust[125];
    UpdateStatus us;
}_Etalon;
//Etalon end

//DAQ start
typedef struct
{
    char Chan[250];
    long Rate;
    float Phase;
    int Frequence;
    int LockedFRQ;
    UpdateStatus us;
}_AO;
typedef struct
{
    char Chan[250];
    long Rate;
    int Channel;
    int ChannelIncludeSource;
    UpdateStatus us;
}_AI;
typedef struct
{
    _AO AO;
    _AI AI;
    UpdateStatus us;
}_DAQ;
//DAQ end

//DA Start
typedef struct
{
    int Type;
    int Number;
    int DiscardNumber;
    UpdateStatus us;
}_Filter;

typedef struct
{
    int Width;
    float Threshold;
    float ThreedB;
    UpdateStatus us;
}_Peak;

typedef struct
{
    int Channel;
    int Relatived;
    int Shifted;
    float Offset;
    UpdateStatus us;
}_Adjustment;

typedef struct
{
    _Adjustment dt[DA_ADJUSTS_MAX];
    Size sz;
    UpdateStatus us;
}_Adjustments;

typedef struct
{
    _Filter Filter;
    _Peak Peak;
    _Adjustments Adjustments;
    UpdateStatus us;
}_DA;
//DA end

//Function start
typedef struct
{
    char Express[125];
    char Unit[20];
    UpdateStatus us;
}_Function;

typedef struct
{
    _Function dt[DA_FUNCTION_MAX];
    Size sz;
    UpdateStatus us;
}_Functions;
//Function end

//Alarms start
typedef struct
{
    int IDX;
    float MIN;
    float MAX;
    int Repeat;
    char Color[20];
    UpdateStatus us;
}_Level;

typedef struct
{
    _Level dt[ALARM_LEVELS_MAX];
    Size sz;
    UpdateStatus us;
}_Levels;

typedef struct
{
    int ID;
    char Name[20];
    char Unit[20];
    _Levels Levels;
    UpdateStatus us;
}_Alarm;

typedef struct
{
    _Alarm dt[ALARMS_MAX];
    Size sz;
    UpdateStatus us;
}_Alarms;
//Alarms end

//GUI start
typedef struct
{
    int Auto;
    int Interval;
    int IntervalCount;
    int Start;
}_Refresh;

typedef struct
{
    int Enable;
    int Zoom;
}_Enlarge;

typedef struct
{
    double XMIN;
    double XMAX;
    double YMIN;
    double YMAX;
}_Coordinate;

typedef struct
{
    int Visible;
    int ShowReference;
    int ShowLaser;
    _Enlarge Enlarge;
    _Refresh Refresh;
    _Coordinate Coordinate;
    UpdateStatus us;
}_WaveChart;

typedef struct
{
    int Visible;
    int TimeSpan;
    _Enlarge Enlarge;
    _Refresh Refresh;
    _Coordinate Coordinate;
    UpdateStatus us;
}_TimeChart;

typedef struct
{
    int Visible;
    int SingleCycle;
    int MaxLines;
    _Refresh Refresh;
    UpdateStatus us;
}_WavelengthList;

typedef struct
{
    int Visible;
    int SingleCycle;
    int MaxLines;
    _Refresh Refresh;
    UpdateStatus us;
}_PhysicValueList;

typedef struct
{
    _WaveChart WaveChart;
    _TimeChart TimeChart;
    _WavelengthList WavelengthList;
    _PhysicValueList PhysicValueList;
    UpdateStatus us;
}_GUI;
//GUI end

//Socket start
typedef struct
{
    int Port;
    char Ethernet[50];
}_Socket;
//Socket end

//SNMP start
typedef struct
{
    char SeverIP[125];
}_SeverIP;

typedef struct
{
    _SeverIP dt[SNMP_TRAP_SERVERIPS_MAX];
    Size sz;
}_SeverIPs;

typedef struct
{
    int Port;
    _SeverIPs SeverIPs;
}_Trap;

typedef struct
{
    int Port;
    _Trap Trap;
}_SNMP;
//SNMP end

//Web start
typedef struct
{
    double Center_Longitude;
    double Center_Latitude;
    int Zoom;
    UpdateStatus us;
}_GIS;

typedef struct
{
    char gis[125];
    char sagis[125];
    char wav_zh[125];
    UpdateStatus us;
}_GISFiles;

typedef struct
{
    char All[125];
    char Single[125];
    UpdateStatus us;
}_GISuris;

typedef struct
{
    int Port;
    _GIS GIS;
    _GISFiles GISFiles;
    _GISuris GISuris;
    UpdateStatus us;
}_Web;
//Web end

//Languages start
typedef struct
{
    int ID;
    char Name[50];
    char File[125];
    UpdateStatus us;
}_Language;

typedef struct
{
    _Language dt[LANGUAGES_MAX];
    int default_lang;
    Size sz;
    UpdateStatus us;
}_Languages;
//Languages end

//Calibrate start
typedef struct
{
    float Init;
    float MIN;
    float MAX;
    float Step;
}_AmplitudeValue;

typedef struct
{
    float Init;
    float Step;
}_AmplitudeOffset;

typedef struct
{
    float MAX;
}_AmplitudeTotal;

typedef struct
{
   _AmplitudeValue Value;
   _AmplitudeOffset Offset;
   _AmplitudeTotal Total;
}_Amplitude;

typedef struct
{
    int Auto;
    int IsAutoCalibrating;
    int CheckNumber;
    _Amplitude Amplitude;
    UpdateStatus us;
}_Calibrate;
//Calibrate end

//Sensors start
typedef struct
{
    long MIN;
    int GE;
    long MAX;
    int LE;
}_Wavelength;

typedef struct
{
    int IX;
    _Wavelength Wavelength;
    float T0;
    float TC;
    long WL0;
    double A;
    double B;
    double C;
    double D;
    char FUN[125];
//    char FUN2[125];
    char Unit[20];
    UpdateStatus us;
}_Express;

typedef struct
{
    _Express dt[SENSOR_EXPRESSES_MAX];
    Size sz;
    UpdateStatus us;
}_Expresses;

typedef struct
{
    long IDX;
    int ID;
    int Channel;
    long WL;
    double PhysicValue;
    char Unit[20];
    int AlarmLevel;
    time_t RecordTime;
    UpdateStatus us;
}_Record;

typedef struct
{
  Size sz;
  _Record dt[FBG_DATA_MAX];
  UpdateStatus us;
}_Records;

typedef struct
{
    char SN[50];
    char Name[125];
    int Type;
    char Memo[125];
    _Wavelength Wavelength;
    _Expresses Expresses;
    _Records rcds;
    _DataSave ds;
    int HasVaribles;
    UpdateStatus us;
}_Sensor;

//typedef struct
//{
//    _Sensor dt[SENSORS_MAX];
//    Size sz;
//    UpdateStatus us;
//}_Sensors;
//Sensors end

//Register start
typedef struct
{
    int IX;
    int ID;
    char Variable[20];
    double Value;
    UpdateStatus us;
}_Relation;

typedef struct
{
    _Relation dt[REGISTER_RELATIONS_MAX];
    Size sz;
    UpdateStatus us;
}_Relations;

typedef struct
{
    int ID;
    char SN[50];
    int Channel;
    int Enable;
    int Error;
    int AlarmID;
    int AlarmLevel;
    char Location[125];
    char File[125];
    char File2[125];
    _Relations Relations;
    _Sensor ss;
    UpdateStatus us;
}_SensorRegister;

typedef struct
{
    _Root root;
    _SensorRegister dt[SENSORS_MAX];
    Size sz;
    UpdateStatus us;
}_SensorRegisters;
//Register end


typedef struct
{
  char IP[512];
  float Temperature;
  int DataServerRun;
  int DAQServerRun;
  int MainAppStatus; //守护程序(主程序)运行状态; 1:正常运行；0：关闭；5：重启动至图形界面；6：重启动。即：执行 init 0; init 5 后 init 6的系统指令。
  int DAQAppStatus;  //硬件驱动和采集程序状态; -1:关闭；0：暂停；1：启动；2：重新Load新的进程。
//  int DataSaveStart;
//  long IntervalCount;
//  int IsAutoCalibrating;
  int ErrorNumber;
  UpdateStatus us;
}_SYS;

typedef struct
{
    int WaveChartEnlargeStatus;
    int TraceEnlargeStatus;
    int RefreshStart;
    int IntervalCount;
    UpdateStatus us;
}_SAU;

typedef struct
{
    char dt[JSON_SOURCE_SA_LENGTH];
    UpdateStatus us;
    Size sz;
}_JsonSource_SA;

typedef struct
{
    char dt[JSON_SOURCE_CALIBRATE_LENGTH];
    UpdateStatus us;
    Size sz;
}_JsonSource_Calibrate;

typedef struct
{
    char dt[JSON_SOURCE_REGISTER_LENGTH];
    UpdateStatus us;
    Size sz;
}_JsonSource_Register;

typedef struct
{
   _JsonSource_SA SA;
   _JsonSource_Calibrate Calibrate;
   _JsonSource_Register Reg;
    UpdateStatus us;
}_JsonSources;

//SA的整体结构定义
typedef struct
{
  long counter;
  char Version[50];
  long VersionN;
  long Build;
  _Root root;
  _Equipment ept;
  _UI ui;
  _InternalCommunication ic;
  _Etalon etalon;
  _SYS sys;
  _DA da;
  _DAQ daq;
  _Calibrate ac;
  _GUI gui;
  _SAU sau;
  _Socket socket;
  _SNMP snmp;
  _Web  web;
  _Languages languages;
  _SensorRegisters regs;
  _Alarms alarms;
  _Functions funs;
  _JsonSources js;
  UpdateStatus us;
}SA;

typedef struct
{
        int Channel;
        long Wavelength;
        time_t RecordTime;
}RawWL;

typedef struct
{
        RawWL dt[SENSORS_MAX];
        UpdateStatus us;
        Size sz;
}RawWLs;

typedef struct
{
        RawWLs dt[SENSORS_FRQ_MAX];
        UpdateStatus us;
        Size sz;
}RawWLss;

typedef struct
{
        _Record r;
        _SensorRegister sr;
        int IsMatched;
}RawWLExt;

typedef struct
{
        int MatchedCount;
        int AlarmsCount;
        RawWLExt dt[SENSORS_MAX];
        UpdateStatus us;
        Size sz;
}RawWLExts;

typedef struct
{
        int MatchedCount;
        int AlarmsCount;
        RawWLExts dt[SENSORS_FRQ_MAX];
        UpdateStatus us;
        Size sz;
}RawWLExtss;

SA *sa;
RawData *rd;

RawWLs *rwls;
RawWLExts *rwles;

RawWLss *rwlss;
RawWLExtss *rwless;

_SHMIDs *shmids;

#endif // SADS_H_INCLUDED
