#include "../sa/sa.h"

#define VIEW_INTERVAL 1

SA *sa;         //系统整体设置数据
RawWLExtss *rwless; //带物理量扩张的多频率多传感器数据

int main()
{

    int i=0,j,k;
    time_t t;
    struct tm *tn;
    long counter_old=0;
    _SensorRegister *sr;

    RawWLExts *rwles;   //带物理量扩展的单频率多传感器数据
    RawWLExt *rwle;     //带物理量扩展的单频率单传感器数据

    if((i = saConnect())) //判断是否链接上内存数据，非零为错误
    {
        printf("Error: %d\n",i);
        return 0;
    }

    i=0;
    if(!(i=saGetSA(sa)))
    {
        printf("IDN: %s\n",sa->ept.IDN);
        printf("ID\tSN\tChannel\tWL Min\tWL Max\tMemo\n");//打印数据列表的标题
        for(j=0;j<sa->regs.sz.Count;j++)
        {
            sr = &(sa->regs.dt[j]);
            if(sr->ID==0)continue;      //系统内置的参考传感器不显示
            printf("%d\t%s\t%d\t%ld\t%ld\t%s\n",
                   sr->ID,
                   sr->SN,
                   sr->Channel,
                   sr->ss.Wavelength.MIN,
                   sr->ss.Wavelength.MAX,
                   sr->ss.Memo
                   );
        }
        printf("----------------------------------------------\n");
    }
    while(1)
    {
        i = 0;
        if(!(i=saGetRawWLExtss(rwless)))
        {
            if(counter_old != rwless->us.Counter)
            {
                counter_old = rwless->us.Counter;
                for(j=0;j<rwless->sz.Count;j++)
                {

                    rwles = &(rwless->dt[j]);

                    printf("Counter: %ld\tFreqence: %d\n",rwless->us.Counter,j);
                    printf("Time\t\tSN\tChannel\tWavelength\tPhysicValue\tUnit\tMatched\nMemo\n");//打印数据列表的标题
                    for(k=0;k<rwles->sz.Count;k++)
                    {
                        rwle = &(rwles->dt[k]);

                        t = rwle->r.RecordTime;
                        tn = localtime(&t);

                        printf("%d%d%d%d%d%d\t%s\t%d\t%ld\t\t%f\t%s\t%d\n%s\n",
                               tn->tm_year+1900,tn->tm_mon,tn->tm_mday,tn->tm_hour,tn->tm_min,tn->tm_sec,
                               rwle->sr.SN,
                               rwle->r.Channel,
                               rwle->r.WL,
                               rwle->r.PhysicValue,
                               rwle->r.Unit,
                               rwle->IsMatched,
                               rwle->sr.ss.Memo
                               );
                    }
                }
            }

        }
        sleep(VIEW_INTERVAL);
    }

    return 0;
}
