#!/bin/sh

APP="sas-wd"
APP_PATH="http://112.74.80.60/sa"

URLDIR="$APP_PATH/$APP"
VERFILE="ver.conf"
BEF="$APP-"
AFT=".tar.gz"

#Get the newest version in web
ver=`curl $URLDIR/$VERFILE`
#Get the current version from self up direction
ver_local=`pwd | awk -F"/" '{print $NF}'`

if [ '$ver'x = '$ver_local'x ];then
    echo "WD is the newest version, not need update!"
    exit
fi

tempDir="update"

k=0

#Refer to the update.conf get the newest update package from web that could let currect version updated newest 
curl $URLDIR/update.conf| grep -i "$ver_local" > outfile
while read LINES
do
	col1=`echo $LINES | cut -f1 -d' '`
	if [ $col1 = $ver_local ];then
	        ver=`echo $LINES | cut -f2 -d' '`
		
		TARFILE=$BEF$ver$AFT
		rm -rf $TARFILE
		#wget $URLDIR/$TARFILE
		curl -O $URLDIR/$TARFILE
		if [ ! -f "$TARFILE" ];then
			echo "Error! No update file $TARFILE, please check net!"
			exit
		fi
		let k=1	
		break
	fi
done < outfile

if [ $k -eq 0 ];then
    echo "No update package to your version!"	
    exit
fi

tar -zxvf $TARFILE
cd $BEF$ver
echo "Install $APP update now."
sleep 2
sh install.sh
