#!/bin/bash

CUR=$(dirname `readlink -f ${0}`)
cd $CUR

ROOT_PATH=$(dirname `readlink -f ~/sa/sa`)
DATA_PATH=$ROOT_PATH"/data/rt"
RT_FILE=$ROOT_PATH"/data/rt.data"
PATH_EXPORT=$ROOT_PATH"/data/rt-export/"

mkdir $PATH_EXPORT

let count=1

p2t=${1}
w2t=${2}
p2c=${3}
w2c=${4}

for file in $DATA_PATH/*.data
do
    #echo "--------------------------------------------------------------"
    echo [$count] $file
    if [ -f $file ];then
        FN=`echo $file | awk -F"/" '{print $NF}' | awk -F"." '{print $1}'`
        FN_PV_TXT=$ROOT_PATH"/data/rt-export/"${FN}"_pv.txt"
        FN_WL_TXT=$ROOT_PATH"/data/rt-export/"${FN}"_wl.txt"
        FN_PV_CSV=$ROOT_PATH"/data/rt-export/"${FN}"_pv.csv"
        FN_WL_CSV=$ROOT_PATH"/data/rt-export/"${FN}"_wl.csv"
        
        if [[ 1 -eq $p2t ]];then
            if [ ! -f "$FN_PV_TXT" ]; then  
                ./dt-export $file $FN_PV_TXT 0 0 1
            fi  
        fi

        if [[ 1 -eq $w2t ]];then
            if [ ! -f "$FN_WL_TXT" ]; then  
                ./dt-export $file $FN_WL_TXT 1 0 1
            fi  
        fi
        
        if [[ 1 -eq $p2c ]];then
            if [ ! -f "$FN_PV_CSV" ]; then  
                ./dt-export $file $FN_PV_CSV 0 1 1
            fi  
        fi

        if [[ 1 -eq $w2c ]];then
            if [ ! -f "$FN_WL_CSV" ]; then  
                ./dt-export $file $FN_WL_CSV 1 1 1
            fi  
        fi

        let count+=1
    fi
done

exit

