#!/bin/bash

CUR=$(dirname `readlink -f ${0}`)
cd $CUR

ROOT_PATH=$(dirname `readlink -f ~/sa/sa`)
DATA_PATH=$ROOT_PATH"/data/rt"
RT_FILE=$ROOT_PATH"/data/rt.data"
PATH_EXPORT=$ROOT_PATH"/data/rt-exports/"
FILELIST_PATH=$ROOT_PATH"/conf/dt-exports-filelist.conf"

let count=1

rm -rf $PATH_EXPORT
mkdir $PATH_EXPORT

sed -i 's/,/\n/'g $FILELIST_PATH

while read line 
do
    FN=`echo $line | awk '{print $1}'`
    p2t=`echo $line | awk '{print $6}'`
    w2t=`echo $line | awk '{print $7}'`
    p2c=`echo $line | awk '{print $8}'`
    w2c=`echo $line | awk '{print $9}'`
    sd=`echo $line | awk '{print $10}'`

    FN_PV_TXT=${PATH_EXPORT}${FN}"_pv.txt"
    FN_WL_TXT=${PATH_EXPORT}${FN}"_wl.txt"
    FN_PV_CSV=${PATH_EXPORT}${FN}"_pv.csv"
    FN_WL_CSV=${PATH_EXPORT}${FN}"_wl.csv"

    if [ "$FN"x = "rt"x ]; then
        file=$RT_FILE
    else
        file=${DATA_PATH}"/"${FN}".data"
    fi

    if [ -f $file ];then

        if [[ 1 -eq $p2t ]];then
            if [ ! -f "$FN_PV_TXT" ]; then  
                ./dt-export $file $FN_PV_TXT 0 0 1
            fi  
        fi

        if [[ 1 -eq $w2t ]];then
            if [ ! -f "$FN_WL_TXT" ]; then  
                ./dt-export $file $FN_WL_TXT 1 0 1
            fi  
        fi
        
        if [[ 1 -eq $p2c ]];then
            if [ ! -f "$FN_PV_CSV" ]; then  
                ./dt-export $file $FN_PV_CSV 0 1 1
            fi  
        fi

        if [[ 1 -eq $w2c ]];then
            if [ ! -f "$FN_WL_CSV" ]; then  
                ./dt-export $file $FN_WL_CSV 1 1 1
            fi  
        fi
        
        if [[ 1 -eq $sd ]];then
            if [ -f "$file" ]; then  
                #echo $file
                sudo /bin/cp -f $file ${PATH_EXPORT}"."
            fi  
        fi
    fi
    
    let count+=1
done < $FILELIST_PATH

exit

