#!/bin/bash

SETCOLOR_SUCCESS="echo -en \\033[0;32m"
SETCOLOR_BLUE="echo -en \\033[1;34m"
SETCOLOR_FAILURE="echo -en \\033[0;31m"
SETCOLOR_WARNING="echo -en \\033[0;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"


CUR=$(dirname `readlink -f ${0}`)

cd $CUR

conf="../apps.conf"

OPT_LABEL=$1

set count=0

while read LINES
do

    COMMENT=`echo ${LINES:0:1}`                         #Check comment label
    COMMAND_NAME=`echo $LINES | cut -f1 -d','`          # Get command name with path from the 1 column
    COMMAND_PATH=`echo $LINES | cut -f2 -d','`          # Get command name with path from the 2 column
    COMMAND=`echo $LINES | cut -f3 -d','`               #Get command from 3 column
    PARAMETERS=`echo $LINES | cut -f4 -d','`            #Get parameters from 4 column
    ENABLE=`echo $LINES | cut -f5 -d','`             #Get backstage status from 5 column
    BACKSTAGE=`echo $LINES | cut -f6 -d','`             #Get backstage status from 6 column
    SLEEPHEAD=`echo $LINES | cut -f7 -d','`             #Get sleep time in head from 7 column
    SLEEPTAIL=`echo $LINES | cut -f8 -d','`             #Get sleep time at tail from 8 column
    CANBEKILLED=`echo $LINES | cut -f9 -d','`           #Get the status of canbekilled from 9 column
    MEMO=`echo $LINES | cut -f10 -d','`                  #Get the memo from 10 column
   
    if [ $COMMENT = "#" ];then
        continue
    fi
    
    if [ $ENABLE -eq 0 ];then
        continue
    fi
    
    if [[ $OPT_LABEL = "stop" ]];then
        if [ $CANBEKILLED -ge 1 ];then
            killall $COMMAND
        fi
        continue
    fi
    
    if [ -n "$COMMAND_PATH/$COMMAND" ];then                           #Check the command file is null           
        let count+=1
        echo -e "\n****************\n"[$count]$COMMAND_NAME":\n****************\n"

        if [ $SLEEPHEAD -gt 0 ];then
            sleep $SLEEPHEAD
        fi
       
        if [ $CANBEKILLED -ge 1 ];then
            killall $COMMAND
        fi
    
        if [ $BACKSTAGE -ge 1 ];then
            $COMMAND_PATH/$COMMAND $PARAMETERS &
        else
            $COMMAND_PATH/$COMMAND $PARAMETERS
        fi

        if [ $SLEEPTAIL -gt 0 ];then
            sleep $SLEEPTAIL
        fi

    fi
done < `echo $conf`
#done < $conf
wait


