#!/bin/bash

CUR=$(dirname `readlink -f ${0}`)
cd $CUR

VER=`echo $PWD | awk -F"/" '{print $(NF-1)}'`

SASVR_IP="112.74.80.60"
SASVR_PATH="/sa/centos/update/"
VER_FILE="version.json"
UPDATE_FILE="sa.update.tar.gz"
DATA_FILE="data.tar.gz"

DEBIAN_LABEL=`sudo cat /etc/issue | grep "Debian"`

if [ -n "$DEBIAN_LABEL" ]; then
    SASVR_PATH="/sa/debian/update/"
fi 

RAS_LABEL=`sudo cat /etc/issue | grep "Raspbian"`
if [ -n "$RAS_LABEL" ]; then
    SASVR_PATH="/sa/raspbian/update/"
fi 

ver=`cat ../conf/${VER_FILE} | grep 'Version' | awk -F'[' '{print $2}' | awk -F']' '{print $1}'| awk -F',' '{print $1$2$3"."$4"."$5}'`
dt=`date "+%Y%m%d"`
output="sa.update-"${ver}"-"${dt}".tar.gz"


rm -rf *.gz
rm -rf sa.update/$DATA_FILE
rm -rf sa.web/$DATA_FILE
rm -rf ../../sa.update/*
/bin/cp -rf sa.update ../../
/bin/cp -rf ../conf/$VER_FILE ../../sa.update/
/bin/cp -rf ../conf/$VER_FILE ../../
cd ../../
./sa stop
tar -zcvf ./sa.update/$DATA_FILE ./$VER
tar -zcvf $output ./sa.update

SERVERPATH="root@"$SASVR_IP":/var/www/html"$SASVR_PATH
scp ${output} ${VER_FILE} ${SERVERPATH}

rm -rf ${output} ${VER_FILE} 

echo "Output file:"
echo ${output}
echo "Create update file. OK!"
