var stats_dts=[];
var stats_dts_wl=[];
var stats_len=0;
var stats_len_wl=0;
var stats_cur=0;
var stats_title=[];
var stats_start=true;
var stats_pause=false;
var stats_files=[];
var stats_file_idx=0;

var stats_rangeFrom = 0;
var stats_rangeTo = 20;

var sa_stats_results = [];
var sa_stats_results_wl = [];

var statsChartWL = false;

function sa_stats_chart_wl_checked(me){
    statsChartWL = me.checked;
    if(statsChartWL){
        setCookie("statsChartWL",1,30);    
    }
    else{
        setCookie("statsChartWL",0,30);    
    }
}

function sa_stats_reset(){
    stats_dts=[];
    stats_dts_wl=[];
    stats_len=0;
    stats_len_wl=0;
    stats_cur=0;
    stats_title=[];
    stats_start=false;
    stats_pause=false;
    stats_files=[];
    stats_file_idx=0;
}

function sa_dt_stats(){
    sa_stats_reset();
    sa_stats_files();
    $('#myTab li:eq(2) a').tab('show');
    sa_statsnow();
}

function sa_statsnow(){
    document.getElementById("saCounterStatsMaxId").innerHTML= stats_files.length;
    document.getElementById("saCounterStatsId").innerHTML= parseInt(stats_file_idx)+1;
    sa_stats_text_create(stats_files[stats_file_idx]);
}

function sa_stats_first(){
    if(stats_file_idx==0)return;
    stats_file_idx=0;
    sa_statsnow();
}

function sa_stats_pre(){
    if((stats_file_idx - 1) < 0)return;
    stats_file_idx-=1;
    sa_statsnow();
}

function sa_stats_next(){
    if((parseInt(stats_file_idx) + 1) > stats_files.length-1)return;
    stats_file_idx+=1;
    sa_statsnow();
}

function sa_stats_last(){
    if(stats_file_idx==stats_files.length-1)return;
    stats_file_idx=stats_files.length-1;
    sa_statsnow();
}

function sa_stats_files(){
    stats_files=[];
    stats_file_idx=0;

    for(var i=de_lines.length-1;i>=0;i--){
        var l = de_lines[i];
        if(l.length < 10)continue;
        if(l[5] == "1" || l[6] == "1" || l[7] == "1" || l[8] == "1" || l[9] == "1"){
            stats_files.push(l[4]);
        }
    }
}

function sa_stats_text_create(f){
    var sf = f;
    var fa = f.split("/");
    var df_part=fa[fa.length-1].split(".")[0];
    var df_short=df_part+"_pv.txt";
    var df="../../data/rt-exports/"+df_short;  
    var com = "../../bin/dt-export "+sf+" "+df+" 0 0 1";
    var httpcommand = "/command_std?par="+com;
    $.get(httpcommand,function(data){
        sa_data_stats_data_read("/data/rt-exports/"+df_short);    
        document.getElementById("statsFileId").innerHTML= df_part;
    });
}

function sa_stats_text_create_wl(f){
    var sf = f;
    var fa = f.split("/");
    var df_part=fa[fa.length-1].split(".")[0];
    var df_short=df_part+"_wl.txt";
    var df="../../data/rt-exports/"+df_short;  
    var com = "../../bin/dt-export "+sf+" "+df+" 1 0 1";
    var httpcommand = "/command_std?par="+com;
    $.get(httpcommand,function(data){
        sa_data_stats_data_read_wl("/data/rt-exports/"+df_short);    
        //document.getElementById("statsFileId").innerHTML= df_part;
    });
    //var com = "../../bin/dt-export "+sf+" "+df+"_wl.txt 1 0 1";
}

function sa_data_stats_data_read(fn){
    var nowTime = new Date().getTime();
    $.ajax({url: fn+"?time="+nowTime,type: "GET",dataType:'text',async:true,cache:true,timeout:5000,success:sa_data_stats_data_read_success});
}

function sa_data_stats_data_read_wl(fn){
    var nowTime = new Date().getTime();
    $.ajax({url: fn+"?time="+nowTime,type: "GET",dataType:'text',async:true,cache:true,timeout:5000,success:sa_data_stats_data_read_success_wl});
}

function sa_data_stats_columns(title){
    stats_title = [];
   for(var i=0;i<title.length;i++){
        var line = title[i];
        if(line.indexOf("=") >= 0){
           var l=line.replace(/(^\s*)|(\s*$)/g, "");
           var col = parseInt(l.split("=")[0].split("Column")[1]);  
           if(col >=3){
               var col_data = l.split("=")[1]; 
               var id = parseInt(col_data.split(",")[0].split(":")[1]);
               var sn = col_data.split(",")[1].split(":")[1];
               stats_title.push(id+"."+sn);  
           }
        }
   }
}

function sa_data_stats_data_read_success(fn_data){
    if(fn_data == null)return;
    var fn_data_2 = fn_data.split("*End*");
    var title = fn_data_2[0].split("\n");
    sa_data_stats_columns(title);
    stats_dts=[]; 
    var data = fn_data_2[1].split("\n");
    for(var i=0;i<data.length;i++){
       var dt=data[i].split(/\t/g);
       if(parseInt(dt[0]) >=0 && parseInt(dt[1]) >=0){
            stats_dts.push(dt); 
       }
    }
    stats_len = stats_dts.length;
    //sa_data_stats_data_draw();
    sa_stats_text_create_wl(stats_files[stats_file_idx]);
}

function sa_data_stats_data_read_success_wl(fn_data){
    if(fn_data == null)return;
    var fn_data_2 = fn_data.split("*End*");
    var title = fn_data_2[0].split("\n");
    sa_data_stats_columns(title);
    stats_dts_wl=[]; 
    var data = fn_data_2[1].split("\n");
    for(var i=0;i<data.length;i++){
       var dt=data[i].split(/\t/g);
       if(parseInt(dt[0]) >=0 && parseInt(dt[1]) >=0){
            stats_dts_wl.push(dt); 
       }
    }
    stats_len_wl = stats_dts_wl.length;
    sa_data_stats_data_draw();
}

function sa_data_stats_data_draw(){
   
    //Build data display list
    var chartDatas_stats = [];
    var chartDatas_stats_wl = [];
    for(var cur=0;cur<stats_len;cur++){
        for(var i=0;i< stats_title.length;i++){
            if(i<stats_rangeFrom || i>stats_rangeTo)continue;
            //Check sensor ID
            var d = i;
            var v_str = stats_dts[cur][2+i];
            if(v_str==null)continue;
            var v = parseFloat(v_str);
            var w = parseFloat(stats_dts_wl[cur][2+i]);

            var j=0;
            for(var k=0;k< chartDatas_stats.length;k++){
                if(chartDatas_stats[k]["name"] == stats_title[d]){
                    chartDatas_stats[k]["data"].push(v);
                    chartDatas_stats_wl[k]["data"].push(w);
                    j=1;
                    break;
                }
            }
            if(j==0){
                chartDatas_stats.push({name: stats_title[d],data:[v]});
                chartDatas_stats_wl.push({name: stats_title[d],data:[w]});
            }
        }
    }
 
    if(statsChartWL){
        sa_chart_rt_draw("en",chartDatas_stats_wl,'#saChartRT_stats');
    }
    else{
        sa_chart_rt_draw("en",chartDatas_stats,'#saChartRT_stats');
    }
    sa_data_statistic(chartDatas_stats,chartDatas_stats_wl);

    sa_data_stats_table();

    return;
}

function sa_data_stats_table(){
    var table = document.getElementById("saTableStats");
    //Clear old data on table
    var rowNum=table.rows.length; 
    for(var j=2;j<rowNum;j++){
        table.deleteRow(j);
        rowNum = rowNum - 1;
        j = j - 1;
    }
    for(var i=0;i<sa_stats_results.length;i++){
        var r = sa_stats_results[i];
        var r_wl = sa_stats_results_wl[i];

        var row = table.insertRow(-1);
        var cell = row.insertCell(-1);
        cell.innerHTML=parseInt(i)+1;
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r.name+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r_wl.r2+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r_wl.slope+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r_wl.intercept+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r.min+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r.max+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r.ave+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r.skew+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r.jitter+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r_wl.min+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r_wl.max+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r_wl.ave+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r_wl.skew+"</span>";
        cell = row.insertCell(-1);
        cell.innerHTML="<span style='text-align:center;'>"+r_wl.jitter+"</span>";
    }
}

function sa_data_statistic(Datas,Datas_wl){
    sa_stats_results = [];
    sa_stats_results_wl = [];
    for(var i=0;i<Datas.length;i++){
       var s = Datas[i];
       var s_wl = Datas_wl[i];
       var d = s.data;
       var d_wl = s_wl.data;
       var r = {name:s.name,min:10000000,max:-10000000,ave:0,skew:0,jitter:0};
       var r_wl = {name:s_wl.name,min:10000000,max:-10000000,ave:0,skew:0,jitter:0,r2:0.0,slope:0.0,intercept:0.0};
       
       var lr = linearRegression(d_wl, d);
       r_wl.r2 = lr.r2.toFixed(6);
       r_wl.slope = lr.slope.toFixed(6);
       r_wl.intercept = lr.intercept.toFixed(6);
       
       sa_data_ave(d,function(data){
           r.ave = data;
           for(var j=0;j<d.length;j++){
               var v = parseFloat(d[j]);
               if((j==0 && parseFloat(d[0]) == 0))continue;

               if(r.min > v)r.min = v;
               if(r.max < v)r.max = v;
               if(j>0){
                   if(!(j==1 && parseFloat(d[0]) == 0)){
                       var jitter = Math.abs(v - parseFloat(d[j-1]));
                       if( jitter > r.jitter){
                           r.jitter = jitter.toFixed(6);
                       }
                   }
               }
           }
           r.skew = (r.max - r.min).toFixed(6);
           sa_stats_results.push(r);
       });
       sa_data_ave(d_wl,function(data){
           r_wl.ave = data;
           for(var j=0;j<d_wl.length;j++){
               var v = parseFloat(d_wl[j]);
               if((j==0 && parseFloat(d[0]) == 0))continue;

               if(r_wl.min > v)r_wl.min = v;
               if(r_wl.max < v)r_wl.max = v;
               if(j>0){
                   if(!(j==1 && parseFloat(d[0]) == 0)){
                       var jitter = Math.abs(v - parseFloat(d_wl[j-1]));
                       if( jitter > r_wl.jitter){
                           r_wl.jitter = jitter.toFixed(2);
                       }
                   }
               }
           }
           r_wl.skew = (r_wl.max - r_wl.min).toFixed(2);
           sa_stats_results_wl.push(r_wl);
       });
    }
}

//Calculate the average
function sa_data_ave(datas,fun){
    if(datas.length == 1){
        fun(datas[0].toFixed(4));
        return;
    }
    var datas_new=[];
    for(var i=0;i<datas.length;i+=2){
       if((parseInt(i)+1) >= datas.length){
            //datas_new.push(parseFloat(datas[i]));    
       }
       else{
           datas_new.push(1.0*(parseFloat(datas[i])+parseFloat(datas[parseInt(i)+1]))/2.0); 
       }
    }
    sa_data_ave(datas_new,fun);
}
