var cb={
    stopFlag:1,
    runInterval: 100000,
    outputDir:"tmp",
    runCount: 0,
    runCountMax: 5,
    physicValue: 21.500000,
    physicValueTime: null,
    autoRecord:false,
    equValue:0,
    equValueTime:null,
    equIp:"127.0.0.1",
    equPort:6052,
    equRunInterval:1000,
    equRun:false,
    tgAuto:false,
    tgCount:30,
    tgCheckInterval:1000,
    tgStdevMax:1.2,
    tgStdev:1.5,
    tgStdevTimes:1.5,
    tgSaveAuto:false,
    tgSavePv:-10000,
    tgSavePvStep:2,
    tgSaveCountMax:100,
    tgSaveCount:0,
    tgData:[],
    fTaSimple:false,
    fTaNewWindow:false,
    multiSelect:false,
    wlAxisChk:false,
    viewGroup:true,
    viewFile:true,
    viewData:true,
    rptChartWidth:350
}
/*
Calibrate Parameters:
--------------------
stopFlag: 1
runInterval: 100000
outputDir: m4
runCount: 0
recordSwitch: 0
physicValue: 21.500000
*/

$(document).ready(function(){
    cb.input_event();
/*
    $("#browser").treeview({
            toggle: function() {
                    console.log("%s was toggled.", $(this).find(">span").text());
            }
    });
    $("#add").click(function() {
            var branches = $("<li class='closed'><span class='folder'>New Sublist</span><ul>" +
            "<li><span class='file'>Item1</span></li>" +
            "<li><span class='file'>Item2</span></li></ul></li>").appendTo("#browser");
            $("#browser").treeview({
                    add: branches
                    });
            });
*/
});

cb.input_event = function(){
    $("input[id]").change(function(){
        var id = $(this).attr("id");
        var val = $(this).val();
        var val_int=0;
        var val_float=0;
        if(val == null || val == "")return;
        if(!isNaN(val)){
            val_int = parseInt(val);
            val_float = parseFloat(val);
        }
        if(id == "cb_m_runinterval"){
            cb.runInterval = val_int;
            $("#cb_m_runinterval_s").html((parseInt(val_int)/1000000)+"s");
            setCookie("cb_m_runinterval",val_int,30);    
            return;
        }
        if(id == "cb_m_outputdir"){cb.outputDir = val;return;}
        if(id == "cb_m_runcount"){
            cb.runCountMax = val_int;
            setCookie("cb_m_runcount",val_int,30);    
            return;
        }
        if(id == "cb_m_physicvalue"){cb.physicValue = val_float;return;}
        if(id == "cb_m_ip"){
            cb.equIp = val;
            setCookie("cb_m_ip",val,30);    
            return;
        }
        if(id == "cb_m_port"){
            cb.equPort = val_int;
            setCookie("cb_m_port",val_int,30);    
            return;
        }
        if(id == "cb_m_equruninterval"){
            if(2*val_int > cb.tgCheckInterval){
                cb.tgCheckInterval = val_int*2;
                $("#cb_t_interval").val(cb.tgCheckInterval);
            }
            cb.equRunInterval = val_int;
            setCookie("cb_m_equruninterval",val_int,30);    
            return;
        }
        if(id == "cb_autorecord_chk"){
            var bl = $(this).prop("checked");
            cb.autoRecord = bl;
            if(bl){
                $("tr[name='cb_equ']").show();
                $("#cb_m_physicvalue").attr("readonly","readonly");
            }
            else{
                $("tr[name='cb_equ']").hide();
                $("#cb_m_physicvalue").removeAttr("readonly");
            }
            return;
        }
        if(id == "cb_equrun_chk"){
            var bl = $(this).prop("checked");
            cb.equRun = bl;
            if(bl){
                $("#cb_m_ip").attr("readonly","readonly");
                $("#cb_m_port").attr("readonly","readonly");
                cb.read_pv_temperature();
            }
            else{
                cb.tgData=[];
                $("#cb_m_ip").removeAttr("readonly");
                $("#cb_m_port").removeAttr("readonly");
            }
            return;
        }
        if(id == "cb_f_ta_simple_chk"){
            var bl = $(this).prop("checked");
            cb.fTaSimple = bl;
            return;
        }
        if(id == "cb_f_ta_new_window_chk"){
            var bl = $(this).prop("checked");
            cb.fTaNewWindow = bl;
            return;
        }
        if(id == "cb_t_auto_chk"){
            var bl = $(this).prop("checked");
            cb.tgAuto = bl;
            cb.tgData=[];
            if(!bl)$("#bt_cb_m_record").removeAttr("disabled");
            return;
        }
        if(id == "cb_t_saveauto_chk"){
            var bl = $(this).prop("checked");
            cb.tgSaveAuto = bl;
            if(!bl)$("#bt_cb_m_record").removeAttr("disabled");
            return;
        }
        if(id == "multi_select_chk"){
            var bl = $(this).prop("checked");
            cb.multiSelect = bl;
            var i=0;
            if(bl)i=1;
            setCookie("multi_select_chk",i,30);    
            return;
        }
        if(id == "wl_x_axis_chk"){
            var bl = $(this).prop("checked");
            cb.wlAxisChk = bl;
            var i=0;
            if(bl)i=1;
            setCookie("wl_x_axis_chk",i,30);    
            return;
        }
        if(id == "rpt_chart_width"){
            cb.rptChartWidth = val_int;
            setCookie("rpt_chart_width",val_int,30);    
            return;
        }
        if(id == "cb_t_count"){
            cb.tgCount = val_int;
            setCookie("cb_t_count",val_int,30);    
            return;
        }

        if(id == "cb_t_interval"){
            if(val_int < 2*cb.equRunInterval){
                val_int =  2*cb.equRunInterval;
                cb.tgCheckInterval = val_int;
                $("#cb_t_interval").val(val_int);
            }
            cb.tgCheckInterval = val_int;
            setCookie("cb_t_interval",val_int,30);    
            return;
        }

        if(id == "cb_t_savecount_max"){
            cb.tgSaveCountMax = val_int;
            setCookie("cb_t_savecount_max",val_int,30);    
            return;
        }
        if(id == "cb_t_pv_step"){
            cb.tgSavePvStep = val_float;
            setCookie("cb_t_pv_step",val_float,30);    
            return;
        }
        if(id == "cb_t_stdev_max"){
            cb.tgStdevMax = val_float;
            setCookie("cb_t_stdev_max",val_float,30);    
            return;
        }
        if(id == "cb_t_ave_stdev_times"){
            cb.tgStdevTimes = val_float;
            setCookie("cb_t_ave_stdev_times",val_float,30);    
            return;
        }
    });
}

cb.conf_init=function(){
    var i  = parseInt(getCookie("cb_m_runcount"));
    if(i>0){
        cb.runCountMax = i;
        $("#cb_m_runcount").val(i);
    }
    var i  = parseInt(getCookie("cb_m_port"));
    if(i>0){
        cb.equPort = i;
        $("#cb_m_port").val(i);
    }
    var i  = parseInt(getCookie("cb_m_equruninterval"));
    if(i>0){
        cb.equRunInterval = i;
        $("#cb_m_equruninterval").val(i);
    }
    var str = getCookie("cb_m_ip");
    cb.equIp = str;
    $("#cb_m_ip").val(str);
    
    var i  = parseInt(getCookie("cb_t_count"));
    if(i>0){
        cb.tgCount = i;
        $("#cb_t_count").val(i);
    }

    var i  = parseInt(getCookie("cb_t_interval"));
    if(i>0){
        if(cb.tgCheckInterval < 2*cb.equRunInterval){
            i = 2* cb.equRunInterval;
        }
        cb.tgCheckInterval = i;
        $("#cb_t_interval").val(i);
    }

    var i  = parseInt(getCookie("cb_t_savecount_max"));
    if(i>0){
        cb.tgSaveCountMax = i;
        $("#cb_t_savecount_max").val(i);
    }
    
    var i  = parseInt(getCookie("rpt_chart_width"));
    if(i>0){
        cb.rptChartWidth = i;
        $("#rpt_chart_width").val(i);
    }
    
    var f  = parseInt(getCookie("cb_t_pv_step"));
    if(f!=null){
        cb.tgSavePvStep = f;
        $("#cb_t_pv_step").val(f);
    }

    var f  = parseFloat(getCookie("cb_t_stdev_max"));
    if(f!=null){
        cb.tgStdevMax = f;
        $("#cb_t_stdev_max").val(f);
    }

    var f  = parseFloat(getCookie("cb_t_ave_stdev_times"));
    if(f!=null){
        cb.tgStdevTimes = f;
        $("#cb_t_ave_stdev_times").val(f);
    }

    var i  = parseInt(getCookie("multi_select_chk"));
    if(i>0){
        document.getElementById("multi_select_chk").checked = cb.multiSelect = true;
    }
    else{
        document.getElementById("multi_select_chk").checked = cb.multiSelect = false;
    }

    var i  = parseInt(getCookie("wl_x_axis_chk"));
    if(i>0){
        document.getElementById("wl_x_axis_chk").checked = cb.wlAxisChk = true;
    }
    else{
        document.getElementById("wl_x_axis_chk").checked = cb.wlAxisChk = false;
    }

    $("tr[name='cb_equ']").hide();
    $("#cb_m_value").attr("readonly","readonly");
    $("#cb_t_pv").attr("readonly","readonly");
}

cb.conf_load = function(){
    cb.conf_init();
    var com = "calibrate -r";
    var httpcommand = "/command_std?par="+com;
    $.get(httpcommand,function(data){
        var lines = data.split("\n");
        if(lines.length < 2)return;
        var column = lines[2].split(":")[1].replace(/(^\s*)|(\s*$)/g, "");
        cb.stopFlag = parseInt(column);
        var column = lines[3].split(":")[1].replace(/(^\s*)|(\s*$)/g, "");
        cb.runInterval = parseInt(column);
        $("#cb_m_runinterval_s").html((parseInt(cb.runInterval)/1000000)+"s");
        var column = lines[4].split(":")[1].replace(/(^\s*)|(\s*$)/g, "");
        cb.outputDir = column;
        var column = lines[7].split(":")[1].replace(/(^\s*)|(\s*$)/g, "");
        cb.physicValue = parseFloat(column);

        $("#cb_m_runinterval").val(cb.runInterval);
        $("#cb_m_outputdir").val(cb.outputDir);
        $("#cb_m_physicvalue").val(cb.physicValue);
    });

    var httpcommand = "/command_std?par="+"ps -A | grep calibrate-svr";
    $.get(httpcommand,function(data){
        if((data.indexOf("calibrate-svr")) >=0){
            $("#bt_cb_m_start").text(lang.val("Stop"));
        }
        else{
            $("#bt_cb_m_start").text(lang.val("Start"));
        }
    });
}

cb.dir_new=function(){
    var strData="";
    var d = new Date();
    strData+=d.getFullYear();
    strData+=d.getMonth();
    strData+=d.getDate();
    strData+=d.getHours();
    strData+=d.getMinutes();
    strData+=d.getSeconds();
    cb.outputDir = strData;
    $("#cb_m_outputdir").val(strData);
}


cb.start=function(me){
    //Check system whether run and run it
    //Check status and set button
    var httpcommand = "/command_std?par="+"ps -A | grep calibrate-svr";
    $.get(httpcommand,function(data){
        if((data.indexOf("calibrate-svr")) >=0){
            httpcommand = "/command_std?par="+"calibrate -x";
            $.get(httpcommand,function(data){
                $("#bt_cb_m_start").text(lang.val("Start"));
                $("#bt_cb_m_record").attr("disabled","true");
                /*
                httpcommand = "/command_std?par="+"killall -9 calibrate-svr";
                $.get(httpcommand,function(data){
                    $("#bt_cb_m_start").text(lang.val("Start"));
                    $("#bt_cb_m_record").attr("disabled","true");
                });
                */
            });
        }
        else{
            httpcommand = "/command_std?par="+"calibrate-svr";
            if(cb.wlAxisChk)httpcommand += " -x w";
            $.get(httpcommand,function(data){
                $("#bt_cb_m_start").text(lang.val("Stop"));
                $("#bt_cb_m_record").removeAttr("disabled");
            });
        }
    });
}

cb.read_output_counter=function(){
    var nowTime = new Date().getTime();
    var httpcommand = "/data/calibrate/"+cb.outputDir+"/counter.txt?time="+nowTime;
    $.get(httpcommand,function(data){
        if(data)
        $("#cb_m_counter").html(data);
    });
}

function default_key(){
    if(!$("#bt_cb_m_record").prop("disabled")){
        cb.record();
    }
}

cb.ip_test=function(){
    var com = "../../bin/tcpclient "+cb.equIp+" "+cb.equPort+" 0 1 1";
    var httpcommand = "/command_std?par="+com;
    
    $.get(httpcommand,function(data){
        alert(data);
        var strTemp = data.split("Re:")[1];
        var obj = JSON.parse(strTemp);
        $("#cb_m_value").val(obj.Temperature.VAL);
    });
}

var pvOldTime="";

cb.read_pv_temperature=function(){
    if(!cb.equRun)return;
    var com = "../../bin/tcpclient "+cb.equIp+" "+cb.equPort+" 0 1 1";
    var httpcommand = "/command_std?par="+com;
    $.get(httpcommand,function(data){
        var strTemp = data.split("Re:")[1];
        var obj = JSON.parse(strTemp);
        //Check data whether the newest.
        if(obj.Time == pvOldTime)return;
        pvOldTime = obj.Time;

        if(cb.tgAuto){
            $("#cb_t_count_rt").html(cb.tgData.length);
            if(cb.tgData.length >= cb.tgCount){
                cb.tgData.shift();
            }
            cb.tgData.push(obj.Temperature.VAL);
            if(cb.tgData.length >= cb.tgCount){
                var sum=0.0;
                var ave = 0.0;
                var len = cb.tgData.length;
                var min=100000,max=-100000;
                for(var i=0;i<len;i++){
                    var v = cb.tgData[i];
                    sum+=v;
                    min = Math.min(min,v);
                    max = Math.max(max,v);
                }
                ave = sum/len;
                var ev1 = Math.abs(max - ave);
                var ev2 = Math.abs(ave - min);
                cb.tgStdev = Math.max(ev1,ev2);
                $("#cb_t_stdev").html(cb.tgStdev.toFixed(3));
                //$("#cb_t_stdev").html(ev1.toFixed(2)+"/"+ev2.toFixed(2));
                if(cb.tgStdev < cb.tgStdevMax){
                    cb.physicValue = ave;
                    cb.physicValueTime = obj.Time;
                    $("#cb_m_physicvalue").val(ave.toFixed(3));
                    $("#cb_m_physicvalue_time").html(obj.Time);
                }
            }
        }
        else{
            cb.physicValue = obj.Temperature.VAL;
            $("#cb_m_physicvalue").val(cb.physicValue.toFixed(3));
            cb.physicValueTime = obj.Time;
        }
        cb.equValue = obj.Temperature.VAL;
        $("#cb_m_value").val(cb.equValue.toFixed(3));
        $("#cb_m_value_time").html(obj.Time);
        setTimeout("cb.read_pv_temperature()",cb.equRunInterval);
    });
}

cb.read_count=function(onlyCount){
    var com = "calibrate -r -v "+cb.physicValue;
    if(onlyCount == true){
        com = "calibrate -r";
    }
    var httpcommand = "/command_std?par="+com;
    $.get(httpcommand,function(data){
        var lines = data.split("\n");
        if(lines.length < 2)return;
        var column = lines[5].split(":")[1].replace(/(^\s*)|(\s*$)/g, "");
        cb.runCount = parseInt(column);

        cb.read_output_counter();
        if(cb.runCount <=0){
            $("#bt_cb_m_record").text(lang.val("Record"));
            if(!cb.tgSaveAuto)$("#bt_cb_m_record").removeAttr("disabled");
        }
        else{
            var str="";
            if(onlyCount){
                str = lang.val("Record")+" ["+cb.runCount+"] ";
            }
            else{
                str = lang.val("Record")+" ["+cb.runCount+"/"+cb.runCountMax+"] ";
            }
            $("#bt_cb_m_record").text(str);
            $("#bt_cb_m_record").attr("disabled","true");
            setTimeout("cb.read_count("+onlyCount+")",500);
        }
    });
}

var count=0;

var pvTime="";

cb.record_auto=function(){
    if(!cb.tgSaveAuto){
        return;
    }
    if(pvTime == cb.physicValueTime){
        setTimeout("cb.record_auto()",parseInt(1000)+parseInt(cb.runCountMax*cb.runInterval/1000));
        return;
    }
    pvTime = cb.physicValueTime;
    //$("#cb_msg2").html(cb.tgSaveCount+"/"+cb.physicValue);
    if(cb.tgSaveCount >= cb.tgSaveCountMax){
        var min = cb.tgSavePv - cb.tgSavePvStep;
        var max = cb.tgSavePv + cb.tgSavePvStep;
        count+=1;
      //  $("#cb_msg").html(count+": "+min+"/"+max+"/"+cb.physicValue);
        if(cb.physicValue < min || cb.physicValue > max){
           cb.tgSaveCount = 0;
           cb.tgSavePv = cb.physicValue;
           $("#cb_t_pv").val(cb.tgSavePv.toFixed(3));
        }
    }
    else{
        //Get data
        cb.tgSaveCount +=1;
        $("#cb_t_savecount").html(cb.tgSaveCount);
        var httpcommand = "/command_std?par="+"calibrate -c "+cb.runCountMax+" -v " +cb.physicValue+" -i " + cb.runInterval + " -p " + cb.outputDir;
        $.get(httpcommand,function(data){
            cb.read_count(true);
        });
    }
    setTimeout("cb.record_auto()",parseInt(1000)+parseInt(cb.runCountMax*cb.runInterval/1000));
}

cb.record=function(){
    if(cb.tgSaveAuto){
        $("#bt_cb_m_record").attr("disabled","true");
        cb.record_auto();
    }
    else{
        var httpcommand = "/command_std?par="+"calibrate -c "+cb.runCountMax+" -v " +cb.physicValue+" -i " + cb.runInterval + " -p " + cb.outputDir;
        $.get(httpcommand,function(data){
            cb.read_count();
        });
    }
}

window.onload = function(){
}

$(function(){
    var obj = document.getElementById("ct");
    if(obj)obj.innerHTML = sa_menu_get_all_without_view();
    $("#saLogo").load("logo2.txt");
    $("[data-toggle='tooltip']").tooltip();
   
    cb.conf_load();
    cb.dir_get();
    setTimeout("sa_lang_version(sa_lang_load_conf)",2000);
});

var fl=[];
var dl=[];
var dl_counter=0;
var fl_i=0;
var dl_i=0;

cb.dir_get = function(){
    dl = [];
    fl = [];
    path = "/data/calibrate/";
    $.get(path,function(data){
        var str = data.split("href='");
        for(var i=1;i<str.length;i++){
            if(str[i].indexOf("/") >=0){
                str[i] = str[i].split("/")[0];
            }
            dl.push(str[i].split("'")[0]);
        }
        dl_counter = 0;
        cb.files_get();
    });
}

cb.files_stat_get_one = function(name,cmd,i,j){
    $.getJSON(cmd,function(data){
        if(data){
            fl[i].files[j].stat = name;  
            fl[i].files[j].a = data.a;  
            fl[i].files[j].b = data.b;  
            fl[i].files[j].r2 = data.r2;  
            fl[i].files[j].stdev = data.stdev;  
            fl[i].files[j].min = data.min;  
        }
    });
}

cb.files_stat_get = function(){
    var path = "/data/calibrate";
    for(var i=0;i<fl.length;i++){
        for(var j=0;j<fl[i].files.length;j++){
            var fnamea = fl[i].files[j].name.split(".");
            var fname = fnamea[0]+"."+fnamea[1]+".txt";
            var cmd = path+"/"+fl[i].dir+"/"+fname;
            cb.files_stat_get_one(fname,cmd,i,j);
        }
    }
}

cb.files_get = function(){
    if(dl_counter >= dl.length){
        cb.files_stat_get();
        cb.dir_list();
        return;
    }
    var path = "/data/calibrate";
    $.get(path+"/"+dl[dl_counter]+"/",function(data){
        var str2 = data.split("href='");
        var f=[];
        for(var j=0;j<str2.length;j++){
            var file = str2[j].split("'")[0];
            if(file != "counter.txt"){
                if((file.indexOf("csv"))>0){
                    f.push({name:file,stat:"",a:0,b:0,r2:0,stdev:0,min:0});
                }
            }
        }
        fl.push({dir:dl[dl_counter],files:f});
        fl.reverse();
        dl_counter+=1;
        cb.files_get();
    });
}

function tr_click(e,i){
    dl_i = i;
    if(e.target.cellIndex < 2){
        d_chk_checked(i,null);
    }
    if(!cb.multiSelect){
        var chks = document.getElementsByName("dl");
        for(var j=0;j<chks.length;j++){
            if(i!=j){
                chks[j].checked=false;
            }
        }

    }
    return;
    var chks = document.getElementsByName("dl");
        chks[i].checked=true;
        return;
    for(var j=0;j<chks.length;j++){
        if(i==j){
            chks[j].checked=true;
        }
        else{
            chks[j].checked=false;
        }
    }
}

function tr_click_f(e,i){
    fl_i = i;
    if(e.target.cellIndex < 2){
        //f_chk_checked(i,null);
        f_chk_checked(i,null,fl[dl_i].dir,fl[dl_i].files[fl_i].name);
    }
    if(!cb.multiSelect){
        var chks = document.getElementsByName("fl");
        for(var j=0;j<chks.length;j++){
            if(i!=j){
                chks[j].checked=false;
            }
        }

    }
    return;
    var chks = document.getElementsByName("fl");
        chks[i].checked=true;
        return;
    for(var j=0;j<chks.length;j++){
        if(i==j){
            chks[j].checked=true;
        }
        else{
            chks[j].checked=false;
        }
    }
}

function d_chk_checked(i,me){
    cb.file_list(i);
}

function f_chk_checked(i,me,dir,f){
    path = "/data/calibrate";
    cb.file(path+"/"+dir+"/"+f);
    var img = f.split(".csv")[0]+".png";
    document.getElementById("ta_img").src=path+"/"+dir+"/"+img;
    var str = new Date().getTime();
    str += ";"+path+"/"+fl[dl_i].dir+"/"+fl[dl_i].files[fl_i].name;
    setCookie("cb_file_analysis",str,30);    
    
    $("#ta_file").html(fl[dl_i].dir+"/"+fl[dl_i].files[fl_i].name);
    $("#ta_stat_a").html(fl[dl_i].files[fl_i].a);
    $("#ta_stat_b").html(fl[dl_i].files[fl_i].b);
    $("#ta_stat_r2").html(fl[dl_i].files[fl_i].r2);
}

cb.file_analysis = function(){
    if(cb.fTaNewWindow){
        window.open("datafit.html");  
    }
    else{
        window.location.href="datafit.html"
    }
    
}

cb.file_simple = function(data){
   var str="";
   var a = data.split("\n");
   for(var i=0;i<a.length;i++){
       if(a[i] != ""){
           var c = a[i].split(",");
           str+=c[1]+" "+c[2] + "\n";
       }
   }
    $("#ta_f").val(str);
}

cb.file = function(name){
    $.get(name,function(data){
        //alert(data);
        if(cb.fTaSimple){
            cb.file_simple(data);
        }
        else{
            $("#ta_f").val(data);
        }
    });
   
}

var statCount=0;
var statArray=[];

cb.file_stat = function(){
    statCount = 0;
    statArray = [];
    var chks = document.getElementsByName("fl");
    for(var i=0;i<chks.length;i++){
        if(chks[i].checked==true){
            statArray.push({name:"/data/calibrate/"+fl[dl_i].dir+"/"+fl[dl_i].files[i].name,di:dl_i,fi:i});
        }
    }
    cb.file_stat_one();
}

cb.file_stat_one = function(){
    $("#file_stat_count").html("&nbsp;[&nbsp;"+parseInt(parseInt(statCount)+1)+"&nbsp;/&nbsp;"+statArray.length+"&nbsp;]&nbsp;");
    $("#bt_dir_stat").attr("disabled","true");
    $("#bt_file_stat").attr("disabled","true");
    if(statCount >= statArray.length){
        cb.dir_list();
        alert("Statistics completed!");
        $("#file_stat_count").html("");
        $("#bt_dir_stat").removeAttr("disabled");
        $("#bt_file_stat").removeAttr("disabled");
        return;
    }
    $.get(statArray[statCount].name,function(data){

       var a = data.split("\n");
       //Check file type
       var fileType = "csv";
       if((a[0].indexOf(","))<0)fileType="";
       var xy_data = new Array();
        var fstr="";
        var x=[];
        var y=[];
        for(var i=0;i<a.length;i++){
            if(a[i] != ""){
               if(fileType == "csv"){
                   var c = a[i].split(",");
                   fstr+=c[1]+" "+c[2]+"\n";
                   x.push(parseInt(c[1]));
                   y.push(parseFloat(c[2]));
               }
               else{
                   var c = a[i].split(" ");
                   fstr+=c[0]+" "+c[1]+"\n";
                   x.push(parseInt(c[0]));
                   y.push(parseFloat(c[1]));
               }
            }
        }
        var min=1650000;
        for(var i=0;i<x.length;i++){
            min = Math.min(x[i],min);
        }
        for(var i=0;i<x.length;i++){
            x[i] = x[i]-min;
        }
        for(var i=0;i<x.length;i++){
            xy_data.push(new Pair(x[i],y[i]));
        }

        var result = matf.process_data(xy_data,1);
        var poly_terms = result[0];
        var correlation_coefficient = result[1];
        var standard_error = result[2];

        var di = statArray[statCount].di;
        var fi = statArray[statCount].fi;
        fl[di].files[fi].a = parseFloat(result[0][1].toFixed(5));
        fl[di].files[fi].b = parseFloat(result[0][0].toFixed(5));
        fl[di].files[fi].r2 = parseFloat(result[1].toFixed(5));
        fl[di].files[fi].stdev = parseFloat(result[2].toFixed(5));
        fl[di].files[fi].min = min;

        var fname = "calibrate/"+fl[di].dir+"/";
        var fnamea=fl[di].files[fi].name.split(".");
        fname+=fnamea[0]+"."+fnamea[1]+".txt";
        var obj = {
            a:parseFloat(fl[di].files[fi].a),
            b:parseFloat(fl[di].files[fi].b),
            r2:parseFloat(fl[di].files[fi].r2),
            stdev:parseFloat(fl[di].files[fi].stdev),
            min:min
        };
        var cmd = "/setconf?name="+fname+"&data="+JSON.stringify(obj)+"&pathtype=data";
        $.get(cmd,function(data){
            statCount+=1;
            var fna = fnamea[0]+"."+fnamea[1];
            cmd = "/setconf?name=calibrate/"+fl[di].dir+"/"+fna+".sta&data="+encodeURIComponent(fstr)+"&pathtype=data";
            $.get(cmd,function(data){
                cmd = "/command_std?par=../../bin/fit.sh ../../data/calibrate/"+fl[di].dir+"/"+fna+".sta ../../data/calibrate/"+fl[di].dir+"/"+fna+".png "+fna+" R2:"+obj.r2;
                //alert(cmd);
                $.get(cmd,function(data){
                    cb.file_stat_one();
                });
            });
        });

    });
}

cb.ta_stat = function(){
    var f = $("#ta_f").val();
    if(f == "" || f == " ")return;
    var a = f.split("\n");
    var xy_data = new Array();
    for(var i=0;i<a.length;i++){
        if(a[i] != ""){
           if(cb.fTaSimple){
               var c = a[i].split(" ");
               xy_data.push(new Pair(parseInt(c[0]),parseFloat(c[1])));
           }
           else{
               var c = a[i].split(",");
               xy_data.push(new Pair(parseInt(c[1]),parseFloat(c[2])));
           }
        }
    }
    var result = matf.process_data(xy_data,1);
    var poly_terms = result[0];
    var correlation_coefficient = result[1];
    var standard_error = result[2];

    var a = result[0][1].toFixed(5);
    var b = result[0][0].toFixed(5);
    var r2 = result[1].toFixed(5);
    $("#ta_stat_a").html(a);
    $("#ta_stat_b").html(b);
    $("#ta_stat_r2").html(r2);
}

cb.dir_stat = function(){
    statCount = 0;
    statArray = [];
    var chks = document.getElementsByName("dl");
    for(var i=0;i<chks.length;i++){
        if(chks[i].checked==true){
            for(var j=0;j<fl[i].files.length;j++){
                statArray.push({name:"/data/calibrate/"+fl[i].dir+"/"+fl[i].files[j].name,di:i,fi:j});
            }
        }
    }
    cb.file_stat_one();
}

cb.file_select_all = function(){
    var bl = $("#f_all_chk").prop("checked");
    var chks = document.getElementsByName("fl");

    for(var i=0;i<chks.length;i++){
        if(bl){
            chks[i].checked=true;
        }
        else{
            chks[i].checked=false;
        }
    }
}

var dirDeleteCount=0;
var dirDeleteArray=[];

cb.dir_delete_one = function(){
    if(dirDeleteCount >= dirDeleteArray.length){
        //cb.file_list(dl_i);
        window.location.reload();
        return;
    }
    var com = "rm -rf "+dirDeleteArray[dirDeleteCount];
    dirDeleteCount+=1;
    var httpcommand = "/command_std?par="+com;
    $.get(httpcommand,function(data){
        cb.dir_delete_one();
    });
}

cb.dir_delete = function(){
    dirDeleteCount = 0;
    dirDeleteArray = [];
    var chks = document.getElementsByName("dl");
    for(var i=0;i<chks.length;i++){
        if(chks[i].checked==true){
            dirDeleteArray.push("../../data/calibrate/"+fl[i].dir);
        }
    }
    cb.dir_delete_one();
}

var fileDeleteCount=0;
var fileDeleteArray=[];

cb.file_delete_one = function(){
    if(fileDeleteCount >= fileDeleteArray.length){
        //cb.file_list(dl_i);
        window.location.reload();
        return;
    }
    var fn = fileDeleteArray[fileDeleteCount].split(".csv")[0];
    var com = "rm -rf "+fn+".*";
    fileDeleteCount+=1;
    var httpcommand = "/command_std?par="+com;
    $.get(httpcommand,function(data){
        cb.file_delete_one();
    });
}

cb.file_delete = function(){
    fileDeleteCount = 0;
    fileDeleteArray = [];
    var chks = document.getElementsByName("fl");
    for(var i=0;i<chks.length;i++){
        if(chks[i].checked==true){
            fileDeleteArray.push("../../data/calibrate/"+fl[dl_i].dir+"/"+fl[dl_i].files[i].name);
        }
    }
    cb.file_delete_one();
}

cb.file_save = function(){
    var fn = "calibrate/"+$("#ta_file").text();
    var fc = $("#ta_f").val();
    if(fn != "" && fc != ""){
        var cmd = "/setconf?name="+fn+"&data="+encodeURIComponent(fc)+"&pathtype=data";
        $.get(cmd,function(data){
            alert("OK!");
        });
    }
}

cb.file_list = function(idx){
    var strTime = new Date().getTime();
    var tb_list = "<table style='width:100%;' class='table table-striped table-condensed list'><thead>\
                   <tr class='table-tr-title'><th width='150px' rowspan='2' colspan='2'>"+fl[idx].dir+"</th><th colspan='4'>f(x)&nbsp;=&nbsp;a*(x-x<sub>0</sub>)&nbsp;+&nbsp;b</th><th rowspan='2'><input type='checkbox' id='f_all_chk' onclick='cb.file_select_all()'></input></th></tr>\
                   <tr class='table-tr-title'><th>a</th><th>x<sub>0</sub></th><th>b</th><th>R<sup>2</sup></th></tr>\
                   </thead><tbody>";
    for(var i=0;i<fl[idx].files.length;i++){
         var s = fl[idx].files[i].name;
         var s_link = "<a href='"+"/data/calibrate/"+fl[idx].dir+"/"+s+"?time="+strTime+"'>"+s+"</a>";
         /*
         var stat = fl[idx].files[i].stat;
         var stat_link = "";
         if(stat != ""){
             stat_link = "<a href='"+"/data/calibrate/"+fl[idx].dir+"/"+stat+"?time="+strTime+"'>"+stat+"</a>";
         }
         */
         //alert(s_link);
         tb_list = tb_list + 
"<tr class='table-tr-content' onclick='tr_click_f(event,"+i+")'> \
<td>"+parseInt(parseInt(i)+1)+"</td>\
<td id='f_n_"+i+"'>"+s_link+"</td>\
<td id='f_a_"+i+"'>"+fl[idx].files[i].a+"</td>\
<td id='f_x0_"+i+"'>"+fl[idx].files[i].min+"</td>\
<td id='f_b_"+i+"'>"+fl[idx].files[i].b+"</td>\
<td id='f_r_"+i+"'>"+fl[idx].files[i].r2+"</td>\
<td><input name='fl' type='checkbox' id='f_chk_"+i+"' onclick='f_chk_checked("+i+",this,\""+fl[idx].dir+"\",\""+s+"\")'></td>\
</tr>";
    }

   tb_list = tb_list + "</tbody></table>";
   $("#tb_cb_fl").html(tb_list);
   f_chk_checked(0,null,fl[0].dir,fl[0].files[0].name);
}

cb.dir_select_all = function(){
    var bl = $("#d_all_chk").prop("checked");
    var chks = document.getElementsByName("dl");

    for(var i=0;i<chks.length;i++){
        if(bl){
            chks[i].checked=true;
        }
        else{
            chks[i].checked=false;
        }
    }
}

cb.dir_list = function(){
    var strTime = new Date().getTime();
    var tb_list = "<table style='width:100%;' class='table table-striped table-condensed list'><thead><tr class='table-tr-title'><th colspan='2' width='100px'>Group</th><th><input type='checkbox' id='d_all_chk' onclick='cb.dir_select_all()'></input></th></tr></thead><tbody>";
    for(var i=0;i<fl.length;i++){
         var s = fl[i];
         var s_link = "<a href='/data/calibrate/"+s.dir+"?time="+strTime+"'>"+s.dir+"</a>";
         tb_list = tb_list + 
"<tr class='table-tr-content' onclick='tr_click(event,"+i+")' id='tr_id_"+i+"'> \
<td>"+parseInt(parseInt(i)+1)+"</td>\
<td width=100px id='d_n_"+i+"'>"+s_link+"</td>\
<td><input name='dl' type='checkbox' id='d_chk_"+i+"' onclick='d_chk_checked("+i+",this)'></td>\
</tr>";
    }

   tb_list = tb_list + "</tbody></table>";
   $("#tb_cb_dl").html(tb_list);
   d_chk_checked(0,null);
}

cb.table = function(){ 
    //选中行变色与鼠标经过行变色
    var dtSelector = ".list"; 
    var tbList = $(dtSelector); 

    tbList.each(function(){ 
        var self = this; 
        // 鼠标经过的行变色 
        $("tr:not(:first)", $(self)).hover( 
        function () { $(this).addClass('hoverTD');$(this).removeClass('table-td-content'); }, 
        function () { $(this).removeClass('hoverTD');$(this).addClass('table-td-content'); } 
        ); 
        // 选择行变色 
        $("tr", $(self)).click(function (){ 
            var trThis = this; 
            $(self).find(".trSelected").removeClass('trSelected'); 
            if ($(trThis).get(0) == $("tr:first", $(self)).get(0)){ 
            return; 
            } 
            $(trThis).addClass('trSelected'); 
        }); 
    }); 
} 

cb.dir_report = function(){
    var strDate = new Date().getTime();
    window.location.href = "sc_report.html?path=/data/calibrate&&type=dir&&name="+fl[dl_i].dir+"&&time="+strDate;
    
}

cb.file_report = function(){
    var strDate = new Date().getTime();
    var fn = fl[dl_i].files[fl_i].name.split(".csv")[0];
    window.location.href =  "sc_report.html?path=/data/calibrate/"+fl[dl_i].dir+"&&type=file&&name="+fn+"&&time="+strDate;
}

