
var wavCheck=true;
var wavCH = parseInt(4);
var yh = parseFloat(3.3);
var ym = parseFloat(4095.0);
var yp = parseFloat(yh/ym);

var wav_refreshStart=0;
var wav_RefreshInterval = 10;

var wav_refreshCount=parseInt(0);

var wav_refreshCount_max = parseInt(wavCH * 6);

var ip = window.location.host.split(":")[0];

var wav_counter=parseInt(0);

function ChartWav_open(){
    wav_refreshStart = 1;
    errorRefreshCountCheckPause = 1;
    var cmdstr = "sas-ctrl 16 1";
    //var cmdstr = "sa-os 1";
    var httpcommand = "/command?par="+cmdstr;
    $.getJSON(httpcommand, function(data) {
        ChartWav_get_counter();
    });
}

function ChartWav_close(){
    wav_refreshStart = 0;
    errorRefreshCountCheckPause = 0;
    var cmdstr = "sas-ctrl 16 0";
    //var cmdstr = "sa-os 0";
    var httpcommand = "/command?par="+cmdstr;
    $.getJSON(httpcommand, function(data) {
    });
}

function ChartWav(){
   ChartWav_init();
   ChartWav_open();
   
}

function ChartWav_init(){
   document.getElementById("wav_refInterval").value = wav_RefreshInterval;
   for(var i=0;i<wavCH;i++){
        wav_series[i].name="CH0"+parseInt(parseInt(i)+parseInt(1));
        wav_series[i].data=[];
   }
}

function ChartWav_get_counter(){
        lng = lng+1;
//        document.getElementById("saMessage").innerHTML = lng;
        var nowTime = new Date().getTime();
        var url= "/wav_counter?time="+nowTime+"."+lng;
        $.ajax({url: url,type: "GET",dataType:'text',async:false,cache:false,timeout:1000,success:processWavCounter,error:processWavCounter_error});
}

function processWavCounter_error(){
   if(wav_refreshStart == 1){
       setTimeout("ChartWav_get_counter()",wav_RefreshInterval)
   }
}

function processWavCounter(data){
    var counter = data;

    //if(counter == wav_counter){
       if(wav_refreshStart == 1){
           setTimeout("ChartWav_get_counter()",wav_RefreshInterval)
       }
      // return;
    //}
    
    wav_counter = counter;
    document.getElementById("wav_ref_counter").innerHTML = counter;
    
    lng = lng+1;
    var nowTime = new Date().getTime();
    var url= "/wav_data?time="+nowTime+"."+lng;
    $.ajax({url: url,type: "GET",dataType:'text',async:false,cache:false,timeout:5000,success:processWavData,error:processWavCounter_error});
}

function processWavData(str){
    if(str[0] == ':'){
        var val = str.split(":")[1];
        var val_array = val.split(".")[0].split(";");
        var dt = val_array[1];
        var cnt = val_array[0];
        //if(cnt == wav_counter)return;
        var chs = dt.split("\n");
        var l=parseInt(0);
        wav_series=[];
        for(var i=0;i<chs.length;i++){
            var c = chs[i].split(" ");
            if(l < c.length)l = c.length;
            wav_series.push({name:"CH"+parseInt(parseInt(i)+parseInt(1)),data:WavData_change(c)});
       }
        wav_xAxis_build(l);
        ChartWav_draw();
    } 
}


function WavData_change(a){
    var b=[];
    for(var i=0;i<a.length;i++){
       b.push(parseFloat(parseFloat(a[i])*yp)); 
    }
    return b;
}


function wav_xAxis_build(len){
   if(len > wav_xAxis.max)wav_xAxis.max = parseInt(len);
   //return;
   if(wav_xAxis.categories.length >= parseInt(len))return;
   var a=[];
   for(var i=0;i<len;i++){
        a.push(i); 
   }
   wav_xAxis.min = 0;
   wav_xAxis.max = len;
   wav_xAxis.categories = a;
}


var wav_chart = {
  type: 'spline'     
  //zoomType: 'xy'
//animation: false,
};
var wav_title = {
  text: ''
};
var wav_subtitle = {
  text: 'casstk.com'
};
var wav_xAxis = {
   min:0,
   max:100,
   categories: [1, 2, 3, 4, 5, 6,7, 8, 9, 10, 11, 12]
};
var wav_yAxis_old = {
  title: {
     text: 'Refrence'
  },
  plotLines: [{
     value: 0,
     width: 2,
     color: '#808080'
    },
    {
     value: 10,
     width: 2,
     color: '#808080'
  }]
}; 
var wav_yAxis = {
  title: {
     text: 'Refrence'
  }
};  
var wav_tooltip = {
  valueSuffix: " ("+yh+"/"+ym+")"
}
var wav_legend = {
  layout: 'vertical',
  align: 'right',
  verticalAlign: 'middle',
  borderWidth: 0
};

var wav_plotOptions = {
   series:{
       animation:false
   },
  spline: {
     marker: {
        radius: 1,
        //lineColor: '#666666',
        lineColor: '#000000',
        lineWidth: 1
     }
  }
};
/* 
var plotOptions = {
  line: {
     dataLabels: {
        enabled: true
     },   
     enableMouseTracking: false
  }

};
*/
var wav_series =  [
  {
     name: 'CH1',
     data: [7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2,
        26.5, 23.3, 18.3, 13.9, 9.6]
  }, 
  {
     name: 'CH2',
     data: [-0.2, 0.8, 5.7, 11.3, 17.0, 22.0, 24.8,
        24.1, 20.1, 14.1, 8.6, 2.5]
  },
  {
     name: 'CH3',
     data: [3.9, 4.2, 5.7, 8.5, 11.9, 15.2, 17.0, 
        16.6, 14.2, 10.3, 6.6, 4.8]
  },
  {
     name: 'CH4',
     data: [3.9, 4.2, 5.7, 8.5, 11.9, 15.2, 17.0, 
        16.6, 14.2, 10.3, 6.6, 4.8]
  }
];


var wav_credits = {
  text:'casstk.com',
  href:'http://www.casstk.com'
};
    

function ChartWav_draw(){ 
    var obj = document.getElementById("wav_refresh_count");
    if(obj !=null)obj.innerHTML= wav_refreshCount;
   // document.getElementById("wav_refresh_count_max").innerHTML = wav_refreshCount_max;
    var json = {};
   json.chart = wav_chart;
   json.title = wav_title;
  // json.subtitle = subtitle;
   json.xAxis = wav_xAxis;
   json.yAxis = wav_yAxis;
   json.tooltip = wav_tooltip;
   json.legend = wav_legend;
   json.series = wav_series;
   json.credits = wav_credits;
   json.plotOptions = wav_plotOptions;
   $('#saChartWav').highcharts(json);
   
   wav_refreshCount = parseInt(wav_refreshCount) + parseInt(1);   
    var obj = document.getElementById("sa_test");
    if(obj !=null)obj.innerHTML= wav_refreshCount;
   
   if(wav_refreshStart == 1){
       setTimeout("ChartWav_get_counter()",wav_RefreshInterval)
   }
}

function ChartWav_draw2(){ 
   var json = {};
   json.chart = wav_chart;
   json.title = wav_title;
  // json.subtitle = subtitle;
   json.xAxis = wav_xAxis;
   json.yAxis = wav_yAxis;
   json.tooltip = wav_tooltip;
   json.legend = wav_legend;
   json.series = wav_series;
   json.credits = wav_credits;
   json.plotOptions = wav_plotOptions;
   $('#saChartWav').highcharts(json);
}
