#!/bin/bash

SETCOLOR_SUCCESS="echo -en \\033[0;32m"
SETCOLOR_BLUE="echo -en \\033[1;34m"
SETCOLOR_FAILURE="echo -en \\033[0;31m"
SETCOLOR_WARNING="echo -en \\033[0;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"

#Entry the current direction
CUR=$(dirname `readlink -f ${0}`)
cd $CUR

#Get the current ver code
VER=`echo $PWD | awk -F"/" '{print $NF}'`

APP_NAME="sa"

RUN_LABEL=${1}
BIN_PATH="./bin"
CONF_PATH="."
CONF_FILE="apps.conf"
CONF="$CONF_PATH/$CONF_FILE"

function batch_run()
{
    OPT_LABEL=$1
    set count=0

while read LINES
do
    COMMENT=`echo ${LINES:0:1}`                         #Check comment label
    COMMAND_NAME=`echo $LINES | cut -f1 -d','`          #Get command name with path from the 1 column
    COMMAND_PATH=`echo $LINES | cut -f2 -d','`          #Get command name with path from the 2 column
    COMMAND=`echo $LINES | cut -f3 -d','`               #Get command from 3 column
    PARAMETERS=`echo $LINES | cut -f4 -d','`            #Get parameters from 4 column
    ENABLE=`echo $LINES | cut -f5 -d','`                #Get backstage status from 5 column
    BACKSTAGE=`echo $LINES | cut -f6 -d','`             #Get backstage status from 6 column
    SLEEPHEAD=`echo $LINES | cut -f7 -d','`             #Get sleep time in head from 7 column
    SLEEPTAIL=`echo $LINES | cut -f8 -d','`             #Get sleep time at tail from 8 column
    CANBEKILLED=`echo $LINES | cut -f9 -d','`           #Get the status of canbekilled from 9 column
    MEMO=`echo $LINES | cut -f10 -d','`                 #Get the memo from 10 column
   
    if [ $COMMENT = "#" ];then
        continue
    fi
    if [ $ENABLE -eq 0 ];then
        continue
    fi
    if [[ $OPT_LABEL = "stop" ]];then
        if [ $CANBEKILLED -ge 1 ];then
            killall -9 $COMMAND
        fi
        continue
    fi
    
    if [ -n "$COMMAND_PATH/$COMMAND" ];then                           #Check the command file is null           
        let count+=1
        echo -e "\n****************\n"[$count]$COMMAND_NAME":\n****************\n"

        if [ $SLEEPHEAD -gt 0 ];then
            sleep $SLEEPHEAD
        fi
       
        if [ $CANBEKILLED -ge 1 ];then
            killall -9 $COMMAND
        fi
   
        cd $COMMAND_PATH

        if [ $BACKSTAGE -ge 1 ];then
            ./$COMMAND $PARAMETERS &
        else
            ./$COMMAND $PARAMETERS
        fi

        echo -e "\n"
        cd -

        if [ $SLEEPTAIL -gt 0 ];then
            sleep $SLEEPTAIL
        fi

    fi
done < `echo $CONF`

}

function start()
{
    batch_run
}

function stop()
{
    batch_run stop
}

function pause()
{
    echo -e "Pause function.\n"
}

function resume()
{
    echo -e "Resume function.\n"
}

function clear()
{

DATA_PATH="."

$BIN_PATH/sa-ctrl 0 0 0
stop

rm -rf $DATA_PATH/data

mkdir $DATA_PATH/data
mkdir $DATA_PATH/data/os
mkdir $DATA_PATH/data/raw
mkdir $DATA_PATH/data/redis
mkdir $DATA_PATH/data/sensor

rm -rf $DATA_PATH/log/.

$BIN_PATH/msg "Clear Data" 1 "Cleared!" "History data to be cleared!" 6 2 &

}

function link()
{

cd ..

ln -sf ./$VER/readme ./readme
ln -sf ./$VER/sa.sh ./$APP_NAME
ln -sf ./$VER/icons ./icons
ln -sf ./$VER/apps.conf ./apps.conf

#Add app link to quick start menu.
CONF_DESKTOP=/usr/share/applications/$APP_NAME.desktop

EXE=$PWD/$APP_NAME
ICON=$PWD/icons/$APP_NAME.png

echo -e "\n"
cd -

echo -e "[Desktop Entry]\nName=CASSTK Sensing Analyzor\nName[zh_CN]=光栅解调\nComment=Sensing Analyzor\nComment[zh_CN]=光栅传感解调\nExec=$EXE\nIcon=$ICON\nTerminal=true\nType=Application\nCategories=GNOME;GTK;Utility;System;\nStartupNotify=true\n
" > $CONF_DESKTOP

}

function update()
{

APP_PATH="http://112.74.80.60"

URLDIR="$APP_PATH/$APP_NAME"
VERFILE="ver.conf"
BEF="$APP_NAME-"
AFT=".tar.gz"

#Get the newest version in web
ver=`curl $URLDIR/$VERFILE`
#Get the current version from self up direction
ver_local=`pwd | awk -F"/" '{print $NF}'`

if [ '$ver'x = '$ver_local'x ];then
    echo "WD is the newest version, not need update!"
    exit
fi

tempDir="update"

k=0

#Refer to the update.conf get the newest update package from web that could let currect version updated newest 
curl $URLDIR/update.conf| grep -i "$ver_local" > outfile
while read LINES
do
	col1=`echo $LINES | cut -f1 -d' '`
	if [ $col1 = $ver_local ];then
	        ver=`echo $LINES | cut -f2 -d' '`
		
		TARFILE=$BEF$ver$AFT
		rm -rf $TARFILE
		#wget $URLDIR/$TARFILE
		curl -O $URLDIR/$TARFILE
		if [ ! -f "$TARFILE" ];then
			echo "Error! No update file $TARFILE, please check net!"
			exit
		fi
		let k=1	
		break
	fi

done < outfile

rm -rf outfile

if [ $k -eq 0 ];then
    echo "No update package to your version!"	
    exit
fi

tar -zxvf $TARFILE
cd $BEF$ver
echo "Install $APP_NAME update now."
sleep 2
sh install.sh

}


CONF_AUTOSTART=/root/.config/autostart/$APP_NAME.desktop

function addautostart()
{

cd ..
EXE=$PWD/$APP_NAME
echo -e "\n"
cd -

AS=true

echo -e "[Desktop Entry]\nType=Application\nExec=$EXE\nHidden=false\nX-GNOME-Autostart-enabled=$AS\nName[en_US]=$APP_NAME\nName=$APP_NAME\nComment[en_US]=\nComment=" > $CONF_AUTOSTART
}

function delautostart()
{
    rm -rf $CONF_AUTOSTART
}


function setup_link()
{

echo -e "\n"
read -n1 -p "Create the simple link? [Y/N]" answer
case $answer in
    Y | y)
    #echo -e "\nFine, continue";;
    sh link.sh 0;;
    N | n)
    sh link.sh 1;;
    #echo -e "\nOK, good bye";;
    *)
    ;;
    #echo -e "\nError choice";;
esac

}

function conf_import()
{
  APPS_CONF="apps.conf"
  CONF_OLD=./${1} 
  CONF_NEW=./${2}
  
  /bin/cp -rf $CONF_OLD/conf/. $CONF_NEW/conf

 if [ -f $CONF_OLD/$APPS_CONF ];then
    /bin/cp -rf $CONF_OLD/$APPS_CONF $CONF_NEW/
 fi

SAFILE="$CONF_NEW/conf/sa.conf"
MAXREF=`cat $SAFILE | grep "MaxRef"`
#If 'MaxRef' is null then add this item in sa.conf.
if [ -z "$MAXREF" ];then
    sed -i '/"Peak\":/a\"Type\":1,\n\"MaxRef\":0,' $SAFILE
fi

}

SA_FIND_LABEL="sa.conf"
function import()
{
    #Get the direction list
    #Get the current version
    ver_local=`pwd | awk -F"/" '{print $NF}'`
    cd ..
    find -name $SA_FIND_LABEL > .tmp
    let count=0
    while read LINES
    do 
        SA_DIR=`echo $LINES | awk -F"/" '{print $2}'`
        if [ $SA_DIR = $ver_local ];then
            continue
        fi
        echo $SA_DIR
        SA_DIRS[$count]=$SA_DIR
        let count+=1
    done < .tmp
    rm -rf .tmp

    echo -e "Choose the source SA to import:\n"

    DIRS_MAX=${#SA_DIRS[@]}

    for((i=0;i<$DIRS_MAX;i++))
    {
        echo "["$i"] "${SA_DIRS[$i]}
    }
    echo -e "\n"
    read -p "Number: " answer

    if [ $answer -lt $DIRS_MAX ] && [ $answer -ge 0 ];then
        conf_import ${SA_DIRS[$answer]} $ver_local
    fi
    
    echo "Import completely!"
}

function setup()
{
 
echo -e "\n"
read -n1 -p "[1/3] Create link? [Y/N]" answer
case $answer in
    Y | y)
    link;;
    N | n)
    ;;
    *)
    ;;
esac

echo -e "\n"
read -n1 -p "[2/3] Add autostart? [Y/N]" answer
case $answer in
    Y | y)
    addautostart;;
    N | n)
    ;;
    *)
    ;;
esac

echo -e "\n"
read -n1 -p "[3/3] Import configure? [Y/N]" answer
case $answer in
    Y | y)
    import;;
    N | n)
    ;;
    *)
    ;;
esac

echo -e "\nSetup completely!\n"

}

function help()
{
    echo -e "\nInput number to active functions:\n\n[1] Start: Batch start\n[2] Restart: Batch restart\n[3] Stop: Stop all\n[4] Pause\n[5] Resume\n[6] Clear\n[7] Link: Create soft link\n[8] Add Autostart\n[9] Del Autostart\n[10] Import\n[11] Setup\n[12] Update\n[0|x|exit] Exit\n"

read -p "Number: " answer
case $answer in
    1|2)start;;
    3)stop;;
    6)clear;;
    7)link;;
    8)addautostart;;
    9)delautostart;;
    10)import;;
    11)setup;;
    12)update;;
    0|x|X|exit)exit;;
    *)help;;
esac

help

}


if [[ -z $RUN_LABEL ]];then
    start
    wait
    exit
fi

case $RUN_LABEL in
    start|restart|s|S)start;;
    x|X|stop)stop;;
    pause|p|P)pause;;
    resume|r|R)resume;;
    clear|c|C)clear;;
    link|l|L)link;;
    import|i|I)import;;
    setup|t|T)setup;; 
    update|u|U)update;;
    addautostart|aa|AA)addautostart;;
    delautostart|da|DA)delautostart;;
    h|H|help|menu)help;;
    *)
    echo -e "Parameters can be accepted:\nstart(s), restart, stop(x), pause(p), resume(r), clear(c), addautostart(aa), delautostart(da), update(u), link(l), setup(t), import(i), help(h)";;
esac

wait
exit

