module.exports = (function(){

    "use strict";

    console.time('[HttpServer][Start]');

    var http = require('http');
    var url = require('url');
    var fs = require("fs");
    var path = require("path");
	//var router = require("./router");
/*
var Express = require('express');
var multer = require('multer');
var bodyParser = require('body-parser');
var app = Express();
app.use(bodyParser.json());
*/

var dgram = require('dgram');
var HOST = '127.0.0.1';
//For UDP server start
var UDP_WAV_CHAR_PORT = 7083;
var udp_wav_char_counter = new Buffer('0');
var udp_wav_char_dt = "";
var client_udp_wav_char = dgram.createSocket('udp4');
function sa_udp_wav_char(){
    client_udp_wav_char.send(udp_wav_char_counter, 0, udp_wav_char_counter.length, UDP_WAV_CHAR_PORT, HOST, function(err, bytes) {});
}
client_udp_wav_char.on('message', function(msg, rinfo){
      var str = msg.toString();
      if(str[0] == ':'){
            var val = str.split(":")[1];
            var val_array = val.split(".")[0].split(";");
            var cnt = val_array[0];
            //var dt = val_array[1];
            if(cnt != udp_wav_char_counter){
                udp_wav_char_counter= cnt;
                udp_wav_char_dt = str;
                //console.log('%s\n', udp_wav_char_counter);
            }
      } 
      setTimeout(sa_udp_wav_char,50);
});
//For UDP server end

//For UDP IDN start
var udp_idn_dt="";
var IDN_CMD_STR = new Buffer('*IDN?');
var UDP_CMD_PORT = 7081;
var client_udp_cmd = dgram.createSocket('udp4');

function sa_udp_idn(){
    client_udp_cmd.send(IDN_CMD_STR, 0, IDN_CMD_STR.length, UDP_CMD_PORT, HOST, function(err, bytes) {});
}

client_udp_cmd.on('message', function(msg, rinfo){
      var str = msg.toString();
      var js = JSON.parse(str);
      if(js!=null){
        if(js.Error == 0){
            udp_idn_dt =JSON.stringify(js.Data); 
        }
      }
      setTimeout(sa_udp_idn,10000);
      //console.log('%s\n', str);
      //console.log('%s %s\n',JSON.stringify(js.Error),JSON.stringify(js.Data));
});
//For UDP IDN end


//For UDP PHY start
var udp_phy_char_dt="";
var UDP_PHY_CHAR_PORT = 7082;
var udp_phy_char_counter = "0";
var client_udp_phy = dgram.createSocket('udp4');
function sa_udp_get_phy(){
    var b = new Buffer(udp_phy_char_counter);
    client_udp_phy.send(b, 0, b.length, UDP_PHY_CHAR_PORT, HOST, function(err, bytes) {});
}
client_udp_phy.on('message', function(msg, rinfo){
      var str = msg.toString();
      var js = JSON.parse(str);
      if(js != null){
          var counter = js.Value.Counter.toString();
          if(counter != udp_phy_char_counter){
              udp_phy_char_counter = counter;
              udp_phy_char_dt = str;
          }
      }
      setTimeout(sa_udp_get_phy,5);
});
/*
client_udp_phy.on('message', function(msg, rinfo){
      var str = msg.toString();
      var js = JSON.parse(str);
      if(js == null)return;
      var counter = js.Value.Counter.toString();
      if(counter == udp_phy_char_counter)return;
      udp_phy_char_counter = counter;
      udp_phy_char_dt = str;
});
*/
//For UDP PHY end

    return {
        start:function(){
            var port = this.config.port;
            var ip = this.config.ip;

            var httpServer = http.createServer(this.processRequest.bind(this));

            httpServer.listen(port,function(){
                console.log("[HttpServer][Start]","runing at http://"+ip+":"+port+"/");
                console.timeEnd("[HttpServer][Start]");
            });

            httpServer.on("error", function(error) {
                console.error(error);
            });
           /* 
            var io = require('socket.io')(httpServer);
            
            var socket_count=0;
        
            function socket_test_add(){
                socket.emit('SOCKET_COUNT',socket_count);
                socket.on('SOCKET_ADD',function(data){
                    //console.log(data);
                    socket_count = parseInt(socket_count) + parseInt(data);
                    socket_test_add();
                });
            }

            io.on('connection',function(socket){
                socket.emit('SOCKET_COUNT',socket_count);
                socket.on('SOCKET_ADD',function(data){
                    //console.log(data);
                    socket_count = parseInt(socket_count) + parseInt(data);
                    socket.emit('SOCKET_COUNT',socket_count);
                });
                //socket_test_add();
            });
            */

            sa_udp_idn();
            sa_udp_get_phy();
            sa_udp_wav_char();
        },

        /**
         * @param request
         * @param response
         */
        processRequest:function(request,response){
            var hasExt = true;
            var requestUrl = request.url;
            var pathName = url.parse(requestUrl).pathname;
			//console.log("Request for " + pathName + " received.");
            pathName = decodeURI(pathName);
			switch(pathName) {  //判断请求的路径信息
				case '/test/delay':// 此处用于模拟缓慢的网络连接
					// 使用查询字符串来获取延迟时长,或者2000毫秒
					var delay = parseInt(url.query) || 2000;
					response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
					response.write('Sleeping for' + delay + ' milliseconds...');
					setTimeout(function(){response.write('done.');response.end();}, delay);
					break;
                                case '/delconf':
                                       var name = url.parse(requestUrl,true).query.name;  
                                       var pathtype = url.parse(requestUrl,true).query.pathtype;  

                                        if(name == "" || name == null){
                                            response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                            response.write("Null file name or Null data!");
                                            response.end();
                                        }
                                        else{
                                            var filePath = "";
                                            if(pathtype == "" || pathtype == null || pathtype == " "){
					        filePath = path.join("../../conf",name);
                                            }
                                            else{
                                                if(pathtype == "notes"){
					            filePath = path.join("../../data/notes",name);
                                                }
                                            }
                                            fs.exists(filePath,function(exists){
                                                if(exists){
                                                        fs.unlink(filePath, function(err) {
                                                            response.writeHead(200,{"content-type": "text/html"});
                                                            if (err) {
                                                                response.end("201 Delete Error!");
                                                            }
                                                            else{
                                                                response.end("200 Delete OK!");
                                                            }
                                                        });
                                                }
                                                else{
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.end("None file.");
                                                }
                                            });
                                        }

                                        break;
                                case '/setconf':
                                       var name = url.parse(requestUrl,true).query.name;  
                                       var data = url.parse(requestUrl,true).query.data;  
                                       var datatype = url.parse(requestUrl,true).query.type;  
                                       var pathtype = url.parse(requestUrl,true).query.pathtype;  
                                       var model = url.parse(requestUrl,true).query.model;  
                                       var rtn=new Buffer('');
                                        if(name == "" || name == null || data == "" || data == null){
                                            response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                            response.write("Null file name or Null data!");
                                            response.end();
                                        }
                                        else{
                                            var filePath = "";
                                            if(pathtype == "" || pathtype == null || pathtype == " "){
					        filePath = path.join("../../conf",name);
                                            }
                                            else{
                                                if(pathtype == "notes"){
					            filePath = path.join("../../data/notes",name);
                                                }
                                                if(pathtype == "data"){
					            filePath = path.join("../../data",name);
                                                }
                                            }
                                            fs.exists(filePath,function(exists){
                                                    response.writeHead(200, {"content-type":contentType});
                                                    console.log(filePath);
                                                    var stream = fs.createWriteStream(filePath,{flags:"w",encoding:null});
                                                    if(datatype == "json"){
                                                        var js = JSON.parse(data)
                                                        if(js != null){
                                                            data = JSON.stringify(js,null,4);
                                                        }
                                                    }
                                                    stream.write(data);
                                                    stream.end();
                                                    
                                                    stream.on("error", function() {
                                                            response.writeHead(500,{"content-type": "text/html"});
                                                            response.end("<h1>500 Server Error</h1>");
                                                    });
                                                    
                                                    stream.on("finish", function() {
                                                            response.writeHead(200,{"content-type": "text/html"});
                                                            response.end("<h1>200 Save Ok!</h1>");
                                                    });
                                                    
                                                    response.writeHead(200,{"content-type": "text/html"});
                                                    response.end("200 Save Ok!");
                                            });
                                        }

                                        break;
                                case '/getconf':
                                       var name = url.parse(requestUrl,true).query.name;  
                                       var rtn=new Buffer('');
                                        if(name == "" || name == null){
                                            response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                            response.write("Null file name");
                                            response.end();
                                        }
                                        else{
					    var filePath = path.join("../../conf",name);
                                            fs.exists(filePath,function(exists){
                                                if(exists){
                                                        response.writeHead(200, {"content-type":contentType});
                                                        var stream = fs.createReadStream(filePath,{flags:"r",encoding:null});
                                                        stream.on("error", function() {
                                                                response.writeHead(500,{"content-type": "text/html"});
                                                                response.end("<h1>500 Server Error</h1>");
                                                        });
                                                        //返回文件内容
                                                        stream.pipe(response);
                                                }
                                                else{
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.end("None file.");
                                                }
                                            });
                                        }

                                        break;
                                case '/datetime':
                                case '/cn/datetime':
                                case '/en/datetime':
                                       var set = url.parse(requestUrl,true).query.set;  
                                       var rtn=new Buffer('');
                                        if(set == "" || set == null){
                                            var nowDate = new Date().getTime();
                                            rtn = nowDate.toString();
                                            response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                            response.write(rtn);
                                            response.end();
                                        }
                                        else{
                                            var newDT = new Date(parseInt(set));
                                            var exec = require('child_process').exec; 
                                            var cmdStr = "sudo date -s \"" + newDT.toString() + "\"";
                                            exec(cmdStr, function(err,stdout,stderr){
                                                if(err){
                                                    rtn = "1";
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.write(rtn);
                                                    response.end();
                                                }
                                                else{
                                                    rtn = "0";
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.write(rtn);
                                                    response.end();
                                                }
                                            });
                                        }

                                        break;
                                case '/command':
                                case '/cn/command':
                                case '/en/command':
                                       var par = url.parse(requestUrl,true).query.par;  
                                       var rtn=new Buffer('');
                                        if(par == "" || par == null){
                                            response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                            response.write("None command!");
                                            response.end();
                                        }
                                        else{
                                            var exec = require('child_process').exec; 
                                            //console.log(par);
                                            exec(par, function(err,stdout,stderr){
                                                if(err){
                                                    rtn = "1";
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.write(rtn);
                                                    response.end();
                                                }
                                                else{
                                                    rtn = "0";
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.write(rtn);
                                                    response.end();
                                                }
                                            });
                                        }
                                        break;
                                case '/command_n_std':
                                case '/cn/command_n_std':
                                case '/en/command_n_std':
                                       var par = url.parse(requestUrl,true).query.par;  
                                       var rtn=new Buffer('');
                                        if(par == "" || par == null){
                                            response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                            response.write("None command!");
                                            response.end();
                                        }
                                        else{
                                            var exec = require('child_process').exec; 
                                            //console.log(par);
                                            exec(par, function(err,stdout,stderr){
                                                if(err){
                                                    rtn = "1\n"+stderr;
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.write(rtn);
                                                    response.end();
                                                }
                                                else{
                                                    rtn = "0\n"+stdout;
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.write(rtn);
                                                    response.end();
                                                }
                                            });
                                        }
                                        break;
                                case '/command_std':
                                case '/cn/command_std':
                                case '/en/command_std':
                                       var par = url.parse(requestUrl,true).query.par;  
                                        if(par == "" || par == null){
                                            response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                            response.write("None command!");
                                            response.end();
                                        }
                                        else{
                                            var exec = require('child_process').exec; 
                                            exec(par, function(err,stdout,stderr){
                                                if(err){
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.write(stderr);
                                                    response.end();
                                                }
                                                else{
                                                    response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
                                                    response.write(stdout);
                                                    response.end();
                                                }
                                            });
                                        }
                                        break;
				case '/data':
				case '/cn/data':
				case '/en/data':
					response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
					response.write(udp_phy_char_dt);
					response.end();
					break;
				case '/cn/idn':
				case '/en/idn':
				case '/idn':
					response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
					response.write(udp_idn_dt);
					response.end();
					break;
				case '/cn/wav_data':
				case '/en/wav_data':
				case '/wav_data':
					response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
					response.write(udp_wav_char_dt);
					response.end();
					break;
				case '/wav_counter':
				case '/cn/wav_counter':
				case '/en/wav_counter':
					response.writeHead(200, {'Content-type':'text/plain; charset=UTF-8'});
					response.write(udp_wav_char_counter);
					response.end();
					break;
 
				case '/json' : // 模拟JSON数据返回
					// 响应状态和头
					response.writeHead(200, {'Content-type':'application/json; charset=UTF-8'});
					response.write(JSON.stringify({test:'success'}));
					response.end();
					break;
 
				default:// 
					if(path.extname(pathName) === ''){
						if (pathName.charAt(pathName.length-1) != "/"){
							pathName += "/";
							var redirect = "http://"+request.headers.host + pathName;
							response.writeHead(301, {location:redirect});
							response.end();
						}
						//添加默认的访问页面,但这个页面不一定存在,后面会处理
						pathName += "index.html";
						hasExt = false; //标记默认页面是程序自动添加的
					}
					//获取资源文件的相对路径
					var filePath = path.join("http/webroot",pathName);

					//获取对应文件的文档类型
					var contentType = this.getContentType(filePath);
	
					//如果文件名存在
					fs.exists(filePath,function(exists){
					if(exists){
						response.writeHead(200, {"content-type":contentType});
						var stream = fs.createReadStream(filePath,{flags:"r",encoding:null});
						stream.on("error", function() {
							response.writeHead(500,{"content-type": "text/html"});
							response.end("<h1>500 Server Error</h1>");
						});
						//返回文件内容
						stream.pipe(response);
					}else { //文件名不存在的情况
						if(hasExt){
							//如果这个文件不是程序自动添加的，直接返回404
							response.writeHead(404, {"content-type": "text/html"});
							response.end("<h1>404 Not Found</h1>");
						}else {
                        //如果文件是程序自动添加的且不存在，则表示用户希望访问的是该目录下的文件列表
							var html = "<head><meta charset='utf-8'></head>";

							try{
								//用户访问目录
								var filedir = filePath.substring(0,filePath.lastIndexOf('/'));
								//获取用户访问路径下的文件列表
								var files = fs.readdirSync(filedir);
								//将访问路径下的所以文件一一列举出来，并添加超链接，以便用户进一步访问
								for(var i in files){
									var filename = files[i];
									html += "<div><a  href='"+filename+"'>"+filename+"</a></div>";
								}
							}catch (e){
								html += "<h1>您访问的目录不存在</h1>"
							}
							response.writeHead(200, {"content-type": "text/html"});
							response.end(html);
					}
                }
				});
   
				break;
				}
        },

        /**
         * 获取文档的内容类型
         * @param filePath
         * @returns {*}
         */
        getContentType:function(filePath){
            var contentType = this.config.mime;
            var ext = path.extname(filePath).substr(1);
            if (contentType.hasOwnProperty(ext)){
                return contentType[ext];
            }else {
                return contentType.default;
            }
        },

        ///配置信息
        config:{
            port:8000,
            ip:'127.0.0.1',
            mime:{
                html:"text/html",
                js:"text/javascript",
                css:"text/css",
                gif:"image/gif",
                jpg:"image/jpeg",
                cgi:"application/cgi",
                png:"image/png",
                ico:"image/icon",
                txt:"text/plain",
                json:"application/json",
                default:"application/octet-stream"
            }
        }
    }


})();
