#!/bin/bash

if [ ! $1 ];then
    echo "Need old version number!"
    exit
fi

VER_OLD=$1
DATA_FILE="data.tar.gz"

killall -9 sas sas2 tcpsvr-json report

tar -zxvf $DATA_FILE

rm -rf $DATA_FILE

VER_FILE="version.json"
VER_NEW=`cat $VER_FILE | grep "\"Version\"" | awk -F'[' '{print $2}' | awk -F']' '{print $1}' | awk -F',' '{print $1$2$3"."$4"."$5}'`

/bin/cp -rf $VER_NEW ../

cd ../

/bin/cp -rf $VER_OLD/conf/register.conf $VER_NEW/conf/register.conf
/bin/cp -rf $VER_OLD/conf/sensors $VER_NEW/conf/sensors

LINK_SAS2=`readlink $VER_OLD/bin/sas2`
cd $VER_NEW/bin
ln -s $LINK_SAS2 sas2
cd -

rm -rf sa chkdisk wlan_start apps.conf readme report sau wlan idn shutSHM.sh

ln -s $VER_NEW/sa.sh sa
ln -s $VER_NEW/readme readme
ln -s $VER_NEW/apps.conf apps.conf
ln -s $VER_NEW/bin/chkdisk.sh chkdisk
ln -s $VER_NEW/bin/wlan_start.sh wlan_start
ln -s $VER_NEW/bin/wlan.sh wlan
ln -s $VER_NEW/bin/report.sh report
ln -s $VER_NEW/bin/sau sau
ln -s $VER_NEW/bin/idn.sh idn
ln -s $VER_NEW/bin/shutSHM.sh shutSHM.sh

#Get old IND and SN
SACONF="$VER_OLD/conf/sa.conf"

SAIDN=`cat $SACONF | grep "\"IDN\"" | awk -F'\"' '{print $4}'`
SASN=`cat $SACONF | grep "\"SN\"" | awk -F'\"' '{print $4}'`

if [ $SAIDN ];then
    SACONF2="$VER_NEW/conf/sa.conf"

    SAIDN2=`cat $SACONF2 | grep "\"IDN\"" | awk -F'\"' '{print $4}'`
    SASN2=`cat $SACONF2 | grep "\"SN\"" | awk -F'\"' '{print $4}'`

    sed -i "s/${SAIDN2}/${SAIDN}/g" $SACONF2
    sed -i "s/${SASN2}/${SASN}/g" $SACONF2
fi

cd $VER_NEW/bin
sudo bash link.sh
bash sa-recovery-create.sh
cd -
cd ../../
