#!/bin/bash

helpmsg(){
    echo "Parameters"
    echo -e "\t1: Cycle number, 0: don't stop"
    echo -e "\t2: Interval times (s)"
    echo -e "\t3: Script to exec before app run"
    echo -e "\t4: App name"
    echo -e "\t5~: App parameters"
    echo "e.g."
    echo -e "\tbash run.sh 50 1 clear ls"
    echo -e "\tbash run.sh 0 1 clear ls"
    echo -e "\tbash run.sh 0 1 none ls"
    echo -e "\tbash run.sh 0 1 clear ./data_single.sh 127.0.0.1"
    echo "--------------------------"
}

if [ "${1}" == "--help" ];then
    helpmsg
    exit
fi
if [ "${1}" == "-h" ];then
    helpmsg
    exit
fi

if [ -z "${1}" ];then
    helpmsg
    exit
fi

if [ -z "${2}" ];then
    echo "Need Interval time (s)"
    exit
fi

if [ -z "${3}" ];then
    echo "Need script to exec before run or 'none' to dont't exec"
    exit
fi

if [ -z "${4}" ];then
    echo "Need app to run"
    exit
fi

i=1

if [ "${1}" == "0" ];then
    while [ -n "$i" ]
    do
        if [ "${3}" != "none" ];then
            ${3}
        fi
        echo "#-----------------------------------"
        echo "# "$i": "`date`
        echo "#-----------------------------------"
        ${4} ${5} ${6} ${7} ${8} ${9} ${10} ${11} ${12} ${13} ${14}
        let i+=1
        sleep ${2}
    done
else
    while [ $i -le ${1} ]
    do
        if [ "${3}" != "none" ];then
            ${3}
        fi
        echo "#-----------------------------------"
        echo "# ["$i"/"$1"] "`date`
        echo "#-----------------------------------"
        ${4} ${5} ${6} ${7} ${8} ${9} ${10} ${11} ${12} ${13} ${14}
        let i+=1
        sleep ${2}
    done
fi

