#!/bin/bash

if [ "${1}" == "--help" ];then
    echo "Parameter 1: ip for check range"
    echo "Parameter 2: 'forced' for reinstall all; 'query' for query version status"
    exit
fi
if [ "${1}" == "-h" ];then
    echo "Parameter 1: ip for check range"
    echo "Parameter 2: 'forced' for reinstall all; 'query' for query version status"
    exit
fi

if [ -z "${1}" ];then
    echo "Need ip address! select follow address:"
    ifconfig | grep 192 | awk -F"addr:" '{print $2}' | awk '{print $1}'
    exit
fi

ADDER=`echo ${1} | awk -F"." '{print $1"."$2"."$3}'`

VER_SVR_FILE="http://112.74.80.60/sa/debian/update/version.json"
VER_SVR=`curl -s $VER_SVR_FILE | grep "Version" | awk -F":" '{print $NF}' | awk -F"]" '{print $1}' | awk -F"[" '{print $NF}'`

echo "******************************"
echo "Version in Server: "$VER_SVR
echo "******************************"

SACount=0

nmap --open -p 8888 $ADDER.1/24 | grep $ADDER | awk '{print $NF}' | while read LINE
do
    VER_LOCAL=`curl -s http://$LINE/cmd?cat%20conf/version.json | grep "Version" | awk -F":" '{print $NF}' | awk -F"]" '{print $1}' | awk -F"[" '{print $NF}'`
    let SACount+=1
    IPVER=`echo -e "["$SACount"]\tIP: "$LINE", Ver: "$VER_LOCAL`
    if [ -n "$VER_LOCAL" ];then
        if [ "${2}" == "forced" ];then
                echo $IPVER"; Upgrating..."
                curl $LINE/cmd?../bin/install_reboot.sh
                #curl -s $LINE/cmd?../bin/install_reboot.sh &
        else
            if [ "${2}" == "query" ];then
                if [ "$VER_LOCAL" != "$VER_SVR" ];then
                    echo $IPVER"; Need upgrade."
                else
                    echo $IPVER";"
                fi
            else
                if [ "$VER_LOCAL" != "$VER_SVR" ];then
                    echo $IPVER"; Upgrating..."
                    curl $LINE/cmd?../bin/install_reboot.sh
                    #curl -s $LINE/cmd?../bin/install_reboot.sh &
                else
                    echo $IPVER";"
                fi
            fi
        fi
    else
        echo $IPVER"; Error!"
    fi
done
