import sys, getopt
import socket
import json
import time
import signal

BUFSIZE = 102400

port=6008
server=None
fo=None

count = 0
countMax = 102400
cache = 0
cacheMax = 1000
interval = 0.00001
fileCount=0
printStr=""
filePath="c:\\temp\\"
fileName="test"
fileExt="csv"

titleList=""
titleList_new=""
dataList=[]
needWriteTitle=False

def open_file():
    global fo,fileCount,filePath,fileName,fileExt
    fo = open(filePath+fileName+"-"+str(fileCount+1)+"."+fileExt,buffering=cacheMax, mode='w+')

def reopen_file():
    global count,countMax,fo,fileCount,filePath,fileName,fileExt,dataList,titleList,cache
    count = 0
    cache = 0
    dataList.clear()
    titleList=""
    fo.flush()
    fo.close()
    fileCount = fileCount + 1
    fo = open(filePath+fileName+"-"+str(fileCount+1)+"."+fileExt,buffering=cacheMax, mode='w+')

def open_udp_port():
    global server,port
    myname = socket.getfqdn(socket.gethostname(  ))
    myaddr = socket.gethostbyname(myname)
    ip_port = (myaddr, port)
    server = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)  # udp
    server.bind(ip_port)
    print('saData start on udp port: ', ip_port)

def exit(signum, frame):
    print("saData closed!")
    server.close()
    fo.flush()
    fo.close()
    sys.exit(0)

def main(argv):
    global count,countMax,fo,fileCount,filePath,fileName,fileExt,dataList,titleList,server,needWriteTitle,interval,port,cache,cacheMax

    try:
      opts, args = getopt.getopt(argv,"hp:d:f:e:l:i:",["port=","dir=","file=","ext=","line=","interval="])
    except getopt.GetoptError:
      print("saData.py -p <udpport> -d <dir> -f <outputfile> -e <externname> -l <linenumber> -i <readinterval>")
      sys.exit(2)
    for opt, arg in opts:
      if opt == '-h':
         print("saData.py -p <udpport> -d <dir> -f <outputfile> -e <externname> -l <linenumber> -i <readinterval>")
         sys.exit()
      elif opt in ("-p", "--port"):
         port = int(arg)
      elif opt in ("-d", "--dir"):
         filePath = arg
      elif opt in ("-f", "--file"):
         fileName = arg
      elif opt in ("-e", "--ext"):
         fileExt = arg
      elif opt in ("-l", "--line"):
         countMax = int(arg)
      elif opt in ("-i", "--interval"):
         interval = float(arg)

    open_udp_port()
    open_file()
    signal.signal(signal.SIGINT, exit)
    signal.signal(signal.SIGTERM, exit)
    while True:
        data_raw,client_addr = server.recvfrom(BUFSIZE)
        if len(data_raw):
            data = data_raw.decode("utf-8")
            js = json.loads(data)
            if js:
                count = count+1
                cache = cache+1
                dataList.clear()
                print("%s: [%d,%d],%s" %(js['SN'],fileCount+1,count,str(js['Time'])+","+str(js['Counter'])))

                #Build title and data list
                titleList_new = "Time,Counter"
                dataList.append(js['Time'])
                dataList.append(js['Counter'])
              
                for dt in js['Data']:
                    titleList_new = titleList_new + ","+str(dt[0])+":"+str(dt[1])+":"+str(dt[4])+":WL,"+str(dt[0])+":"+str(dt[1])+":"+str(dt[4])+":PV"
                    dataList.append(dt[2])
                    dataList.append(dt[3])
                if len(titleList) == 0:
                    titleList = titleList_new
                    needWriteTitle = True
                else:
                    if titleList != titleList_new:
                        titleList = titleList_new
                        needWriteTitle = True
                        reopen_file()
                if needWriteTitle:
                    fo.write(titleList_new+"\n")
                    needWriteTitle = False
                printStr = ""
                isFirst = True
                for y in dataList:
                    if isFirst == False:
                        printStr = printStr + ","
                    printStr = printStr + str(y)
                    isFirst = False
                fo.write(printStr+"\n")
                
                if cache > cacheMax:
                    fo.flush()
                    cache = 0

                if count > countMax:
                    reopen_file()
        time.sleep(interval)

    server.close()


if __name__ == "__main__":
   main(sys.argv[1:])
