#!/bin/bash

# 函数：修改WPA_supplicant.conf
function modify_wpa_supplicant {
    local new_ssid="$1"
    local new_psk="$2"

    config_file="/etc/wpa_supplicant.conf"
    echo $new_ssid $new_psk
    sudo sed -i "s/^\s*ssid\s*=\s*\([^ ]*\)/ssid=\"${new_ssid//\"/\\\"}\"/" "$config_file"
    sudo sed -i "s/^\s*psk\s*=\s*\([^ ]*\)/psk=\"${new_psk//\"/\\\"}\"/" "$config_file"
    echo " 已成功将SSID修改为： ${new_ssid}，已成功将PSK修改为：${new_psk}，设备将重启，请等待设备重启后重新登录。"
}

# 函数：修改其他网络配置文件
function modify_network_config {
    if [ $# -ne 4 ]; then
        echo "修改失败，请填写正确的参数：文件路径 IP 地址 网关 子网掩码"
        exit 1
    fi

    file_path="/etc/$1.conf"
    ip_param_name="IPADDR"
    new_ip="$2"
    gateway_param_name="GATEWAY"
    new_gateway="$3"
    netmask_param_name="NETMASK"
    new_netmask="$4"

    # 使用函数合并IP和网关的验证逻辑
    function validate_ipv4_address {
        local ip="$1"
        local pattern='^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$'
        if [[ ! $ip =~ $pattern ]]; then
            echo "错误：提供的地址不是一个有效的IPv4地址！"
            exit 1
        fi
    }

    validate_ipv4_address "$new_ip"
    validate_ipv4_address "$new_gateway"

    # 检查IP和网关是否在同一子网段
    IFS='.' read -ra IP_ADDR <<<"$new_ip"
    ip_net_part="${IP_ADDR[0]}.${IP_ADDR[1]}.${IP_ADDR[2]}"

    IFS='.' read -ra GW_ADDR <<<"$new_gateway"
    gw_net_part="${GW_ADDR[0]}.${GW_ADDR[1]}.${GW_ADDR[2]}"

    if [[ "$ip_net_part" != "$gw_net_part" ]]; then
        echo "错误：新IP地址与新网关不在同一子网段，不能进行修改！"
        exit 1
    fi

    # 使用单独的函数验证子网掩码
    function validate_subnet_mask {
        local mask="$1"
        local pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$'
        if [[ ! $mask =~ $pattern ]]; then
            return 1
        fi

        local binary_mask=""
        IFS='.' read -r -a octets <<<"$mask"
        for octet in "${octets[@]}"; do
            binary_octet=$(echo "obase=2;$octet" | bc)
            binary_mask+="${binary_octet}"
        done
        mask_length=${#binary_mask}

        ((8 <= mask_length && mask_length <= 32)) && return 0 || return 1
    }

    if ! validate_subnet_mask "$new_netmask"; then
        echo "子网掩码格式不正确"
        exit 1
    fi

    # 更新配置文件
    if [[ -f "$file_path" ]]; then
       sudo sed -i "s/${ip_param_name}=.*$/${ip_param_name}=${new_ip}/g" "$file_path"
       sudo sed -i "s/${gateway_param_name}=.*$/${gateway_param_name}=${new_gateway}/g" "$file_path"
       sudo sed -i "s/${netmask_param_name}=.*$/${netmask_param_name}=${new_netmask}/g" "$file_path"
       sudo echo "已成功将 ${ip_param_name} 修改为：${new_ip}"
        echo "已成功将 ${gateway_param_name} 修改为：${new_gateway}"
        echo "已成功将 ${netmask_param_name} 修改为：${new_netmask}"
    else
        echo "文件路径不正确或文件不存在"
        exit 1
    fi
}
# 根据输入判断是修改WPA_supplicant.conf还是其他网络配置文件
case "$1" in
wpa_supplicant) modify_wpa_supplicant "$2" "$3" ;;
*) modify_network_config "$@" ;;
esac
