
#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define rtMAX_SENSORS 16*12

char rtFileStartLabels[5] = {"SART"};
char rtFileDescription[30] = {"CASSTK SA RealTime Data\0"};
char rtDataStartLabels[3] = {"$:"};
char rtVersion1=1;
char rtVersion2=1;

typedef struct{
    int Time;
    int Counter;
    float dt[rtMAX_SENSORS];
}rtData;

typedef struct{
    unsigned char ID;
    char SN[11];
}rtSensors;

typedef struct{
    char fileStartLabels[5];
    char Description[30];
    char Version1;
    char Version2;
    char Company[20];
    char IDN[20];
    char SN[20];
    char SensorCount;
    rtSensors Sensors[rtMAX_SENSORS];
    int StartTime;
    char dataStartLabels[3];
}rtTitle;


int main(int argc, char** argv)
{
	char file_from[100]={"\0"};
  char file_to[100]={"\0"};
  
  int i;
  long line_start=0;
  long line_end=0;

  switch(argc){
    case 5:
        line_end = atol(argv[4]);
    case 4:
        line_start = atol(argv[3]);
    case 3:
        sprintf(file_from,"%s",argv[1]);
        sprintf(file_to,"%s",argv[2]);
        break;
    default:
        printf("Need two file name to convert from data file to txt file, or start line and end line.\ne.g.\nDataFile\tTxtFile\tStartLineNumber<default 0>\tReadLineNumber<default 0>\n");
        return 1;
        break;
  }


  FILE *fp_from,*fp_to;

  fp_from = fopen(file_from,"rb");

  if(fp_from==NULL){
    printf("Can not open '%s' to read data.\n",file_from);
    return 2;
  }
  else{
    fp_to = fopen(file_to,"w+");
    if(fp_to==NULL){
        printf("Can not open '%s' to write data.\n",file_to);
        return 3;
    }
  }
  
  rtTitle *rtt = (rtTitle *)malloc(sizeof(rtTitle));
  rtData *rtd = (rtData *)malloc(sizeof(rtData));

  char file_title[10000]={"\0"};
  char file_title_column[500]={"\0"};

  if((fread(rtt,sizeof(rtTitle),1,fp_from))){
      if(rtt->fileStartLabels[0]!=rtFileStartLabels[0] || rtt->fileStartLabels[1]!=rtFileStartLabels[1]){
          printf("Input file format error. [%s]:[%s]\n",rtFileStartLabels,rtt->fileStartLabels);
          return 4;
      }
      /*
      if(!strcmp(rtt->fileStartLabels,rtFileStartLabels)){
          printf("Input file format error. [%s]:[%s]\n",rtFileStartLabels,rtt->fileStartLabels);
          return 4;
      }
      */
      if(rtt->Version1 != rtVersion1 || rtt->Version2 != rtVersion2){
          printf("Input file Version  format error, need version: %d.%d\n",rtVersion1,rtVersion2);
          return 5;
      }
	long lx;
	lx = rtt->StartTime;
	time_t *tt;
	tt = (time_t *)&lx;
	
	printf("##%s\n##Version:   %d.%d\n##Company:   %s\n##IDN    :   %s\n##SN     :   %s\n##Count  :   %d\n##Time   :   %s#Column01= Record Time\n#Column02= Counter\n",
            rtt->Description,
            rtt->Version1,
            rtt->Version2,
            rtt->Company,
            rtt->IDN,
            rtt->SN,
            rtt->SensorCount,
            asctime(localtime(tt))
              );
      sprintf(file_title,"##%s\n##Version:   %d.%d\n##Company:   %s\n##IDN    :   %s\n##SN     :   %s\n##Count  :   %d\n##Time   :   %s#Column01= Record Time\n#Column02= Counter\n",
            rtt->Description,
            rtt->Version1,
            rtt->Version2,
            rtt->Company,
            rtt->IDN,
            rtt->SN,
            rtt->SensorCount,
            asctime(localtime(tt))
              );
	  //asctime(localtime(&lx))
	  //printf("%s\n",file_title);
	  //getchar();
      for(i=0;i<rtt->SensorCount;i++){
          memset(file_title_column,'\0',sizeof(file_title_column));  
          sprintf(file_title_column,"#Column%02d= ID: %d, SN: %s\n",i+3,rtt->Sensors[i].ID,rtt->Sensors[i].SN);
          strcat(file_title,file_title_column);
      }
	  //printf("2\n");
      strcat(file_title,"*End*\n");
      fwrite(file_title,strlen(file_title),1,fp_to);
      
  }
 // printf("3\n");
  int len = sizeof(float)*(rtt->SensorCount)+2*sizeof(int);
    
    char file_row[500];
    char data_string[20];
    long lng = 0;
    
    int needCut=0;
    if(line_end>0)needCut=1;
    
    while((fread(rtd,len,1,fp_from))){

        if(line_start > 0){
            line_start = line_start -1;
            continue;
        }

        if(needCut){
            if(line_end > 0){
                line_end = line_end -1;
            }
            else{
                break;
            }
        }

        memset(file_row,'\0',sizeof(file_row));
        
        memset(data_string,'\0',sizeof(data_string));
        sprintf(data_string,"%d",rtd->Time);
        strcat(file_row,data_string);
        
        memset(data_string,'\0',sizeof(data_string));
        sprintf(data_string,"\t%d",rtd->Counter);
        strcat(file_row,data_string);
     
      for(i=0;i<rtt->SensorCount;i++){
          memset(data_string,'\0',sizeof(data_string));
          sprintf(data_string,"\t%0.4f",rtd->dt[i]);
          strcat(file_row,data_string);
      }
      strcat(file_row,"\n");
      fwrite(file_row,strlen(file_row),1,fp_to);
      lng = lng+1;
    }

  fflush(fp_to);

  free(rtt);
  free(rtd);
  fclose(fp_from);
  fclose(fp_to);
 
  printf("Convert OK!\nTotal:\nLine: %ld, Byte: %ld\n",lng,lng*len);
  
  return 0;
}

