#!/bin/bash

let FILE_T_S=0
let FILE_T_E=0

function file_process()
{

    if [[ -z "$file_dir_src" ]];then
        return -1
    fi
    FINAL=`echo ${file_dir_src: -1}`
    if [[ "$FINAL" != "/" ]];then
        file_dir_src=$file_dir_src"/"
    fi

    if [[ -z "$file_dir_dest" ]];then
        FP_DATA=${FP}${DEFAULTDATADIR}"/"
    else
        FINAL=`echo ${file_dir_dest: -1}`
        if [[ "$FINAL" != "/" ]];then
            file_dir_dest=$file_dir_dest"/"
        fi
        FP_DATA=${FP}${file_dir_dest}
    fi

    ##检查是否重复
    #save_log_to_check
    ##获取目标目录下的文件列表，建立数组
    declare -A fileNameArrayGz
    for i in `eval "ls "$FP_DATA"*.tar.gz"`
    do
        fileNameArrayGz[$i]=1
    done
    declare -A fileNameArrayXz
    for i in `eval "ls "$FP_DATA"*.xz"`
    do
        fileNameArrayXz[$i]=1
    done

    #处理文件查询范围
    if [[ $file_days -gt 0 ]];then
        let FILE_T_S=`date -d "$file_days day ago" +%s`
        let FILE_T_E=`date +%s`
    else
        #检查是否为空
        if [[ -z "$file_time_start" ]];then
            return -2
        fi
        if [[ -z "$file_time_end" ]];then
            return -3
        fi
        let FILE_T_S=`date -d "$file_time_start" +%s`
        let FILE_T_E=`date -d "$file_time_end" +%s`
    fi

    mkdir -p $FP_DATA
    MAX_COUNT_String=""
    if [[ $file_max -gt 0 ]];then
        MAX_COUNT_String="| head -n$file_max"
    fi
    searchString="ls -f -l --time-style=+%s ${file_dir_src}${file_format} | awk '\$6 >= $FILE_T_S && \$6 <= $FILE_T_E {print \$7}' $MAX_COUNT_String"
    eval $searchString | while read line
    do
        fileNameFull=`echo $line | awk -F"/" '{print $NF}'`
        fileType=`echo $fileNameFull | awk -F"." '{print "."$NF}'`
        fileName=`echo $fileNameFull | awk -F"$fileType" '{print $1}'`
        #检查查询文件是否需要处理
        SourceIsZip=1       #用来控制是否删除文件
        if [[ "$fileType" != ".gz" ]];then #不压缩，直接移动
            if [[ "$fileType" != ".xz" ]];then
                SourceIsZip=0
                if [[ "$file_zip_type" == "xz" ]];then
                    FullName=${FP_DATA}${fileName}".xz"
                    if [[ ${fileNameArrayXz["${FullName}"]} -ne 1 ]];then
                        xz -k -f -6 -c ${line} > ${FullName}
                        echo ${line}" -> "${FullName}
                        udp_broadcast ${line}" -> "${FullName}
                    fi
                else
                    FullName=${FP_DATA}${fileName}".tar.gz"
                    if [[ ${fileNameArrayGz["${FullName}"]} -ne 1 ]];then
                        tar -zcPf ${FullName} ${line} 
                        echo ${line}" -> "$FullName 
                        udp_broadcast ${line}" -> "$FullName 
                    fi
                fi
            fi
        fi

        #如果是压缩文件，直接拷贝
        if [[ $SourceIsZip -eq 1 ]];then
            cp -f ${line} ${FP_DATA}
        fi

        if [[ $file_src_delete -eq 1 ]];then
            rm -rf ${line}
        fi

    done

    return 0
}

function dtb_exec(){
    if [[ -n "$script_upgrade" ]];then
        eval $script_upgrade
        exit
    fi
    if [[ -n "$script_patch" ]];then
        eval $script_patch
    fi
    if [[ -n "$script_exec_before" ]];then
        eval $script_exec_before
    fi

    file_process

    sync
    sleep 3
    sudo umount $FP
    udp_broadcast "Umount "$FP

    if [[ $? -ne 0 ]];then
        echo "File process error! $?"
        udp_broadcast "File process error! $?"
        exit
    fi

    if [[ -n "$script_exec_after" ]];then
        eval $script_exec_after
    fi
}

#正确执行后需要整体退出
