#!/bin/bash
### BEGIN INIT INFO
# P
### END INIT INFO

SOURCE=$0 # $0 is the shell name， maybe absolute path, relative path or symbolic link
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$SCRIPT_DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"  # script absolute path

APPName=dtbd

case $1 in
start)
        while true
        do
            rtn=`ps -A | grep $APPName | grep -v grep | wc -l`
            if [[ $rtn -ge 1 ]];then
                sleep 5
            else
                $SCRIPT_DIR/$APPName &
            fi
        done
;;
stop)
        rtn=`ps -A | grep $APPName | grep -v grep | wc -l`
        if [[ $rtn -ge 1 ]];then
            killall -9 $APPName
        fi
;;
status)
        rtn=`ps -A | grep $APPName | grep -v grep | wc -l`
        if [[ $rtn -ge 1 ]];then
                echo "$APPName is running."
        else
                echo "$APPName is stoped."
        fi
;;
*)
        echo "$APPName start|stop|status"
        exit 1
esac

exit 0
