#!/bin/bash

#默认发送udp到默认端口
process_udp_enable=1
process_udp_port=7070

function udp_broadcast()
{
    if [[ -z "$1" ]];then
        return
    fi
    if [ $process_udp_enable -ne 1 ];then
        return
    fi
    echo $APPIDN": "$1 | nc -w1 -b -u 255.255.255.255 $process_udp_port
}

function check_cfg(){
    if [[ -z "$1" ]];then
        return -1
    fi
    if [[ -z "$2" ]];then
        return -2
    fi
    let label=0
    if [[ $3 -gt 0 ]];then
        let label=$3
    fi

    #确认配置文件是否存在,如果存在完成处理后结束，不存在则选择下一个磁盘检查
    let HaveCfg=`ls -f $1$2 | wc -l`
    if [[ $HaveCfg -eq 1 ]];then

        echo "$label "$1" "$2
        #处理文件

        return 0
#    else
        #如果没有配置文件，把默认配置拷贝到u盘
#        cp -f $SCRIPT_DIR/dtb.cfg $1       
#        echo ""
#        return -4

    fi
    echo -e "-1"
    return -3
}

#检查是否有正常的磁盘和配置文件
function valid_dir()
{

    DIR=""
    CFG=""

    if [[ -n "$1" ]];then
        DIR=$1
        if [[ -n "$2" ]];then
            CFG=$2
        fi
    fi

    if [[ -z "$TEMPDIR" ]];then
        return -1
    fi

    if [[ -z "$CFGFILE" ]];then
        return -2
    fi

    FILETYPE=""
    FILELable="FAT32"

    rtn=`sudo fdisk -l | grep 'FAT32' | awk '{print $1}' | wc -l`
    if [[ $rtn -ge 1 ]];then
        FILETYPE="-t vfat"
        FILELable="FAT32"
    else
        rtn=`sudo fdisk -l | grep 'NTFS\|exFAT' | awk '{print $1}' | wc -l`
        if [[ $rtn -ge 1 ]];then
            FILELable="NTFS\\|exFAT"
        else
            return -3
            echo "-1 None!"
            udp_broadcast "-1 None!"
        fi
    fi

    #查看有无FAT32格式的磁盘
    sudo fdisk -l | grep $FILELable | awk '{print $1}' | while read line
    do
        #检查是否已经挂接在特定目录
        mountedNum=`mount -l | grep $line | wc -l`
#        echo -e "num: ${mountedNum}\n"
        if [[ $mountedNum -eq 0 ]];then
            #没有挂接，则挂接,处理后需要取消挂接
            sudo mkdir -p $DIR
            #sudo mount -t vfat -o fmask=0011,dmask=0000 $line $DIR"/"
            sudo mount $FILETYPE -o fmask=0011,dmask=0000 $line $DIR"/"

            #确认配置文件是否存在,如果存在完成处理后结束，不存在则选择下一个磁盘检查
            check_cfg $DIR"/" $CFG 1

        else
            #获取挂接的目录
            mountedDir=`mount -l | grep $line | awk '{print $3}'`
            if [[ -n "$mountedDir" ]];then
                #检查目录类型，是否FAT32
                ifFAT=`mount -l | grep $line | awk '{print $5}' | grep 'vfat\|NTFS\|exFAT\|ntfs\|exfat' | wc -l`
                if [ $ifFAT -eq 1 ];then
                    #检查读写状体，有无可写
                    ifRW=`mount -l | grep $line | awk '{print $6}' | awk -F',' '{print $1}' | grep 'w' | wc -l`
                    if [ $ifRW -eq 1 ];then
                        #确认配置文件是否存在,如果存在完成处理后结束，不存在则选择下一个磁盘检查
                        check_cfg $mountedDir"/" $CFG
                    fi
                fi
            fi
        fi
    done

    return 0
}
