#!/bin/bash
#/usr/bin/env bash

#程序版本
declare -a VER=(1 0 0)
#挂载的临时目录
TEMPDIR="/media/tmp_dtb"
DEFAULTDATADIR="dtb_data"
APPIDN="dtb"

#配置文件及版本
CFGFILE="dtb.cfg"
declare -a CFGVER=(1 0 0)

if [[ "$1" == "--version" ]];then 
    echo ${VER[*]} | awk '{print $1"."$2"."$3}'
    exit
fi


SOURCE=$0 # $0 is the shell name， maybe absolute path, relative path or symbolic link
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$SCRIPT_DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"  # script absolute path

source $SCRIPT_DIR/dtb_util.sh

RTN=$(valid_dir $TEMPDIR $CFGFILE)

if [[ $? -ne 0 ]];then
    echo "Error! -1"
    udp_broadcast "Error! -1" 
    exit
    return
fi

if [[ -z "$RTN" ]];then
    echo "Error! -2"
    udp_broadcast "Error! -2"
    exit
    return
fi

FPN=""
FP=""
FP_DATA=""

let i=`echo $RTN | awk '{print $1}'`
if [[ $i -ge 0 ]];then
   #判断最后一个字符
   FP=`echo $RTN | awk '{print $2}'`
   FN=`echo $RTN | awk '{print $3}'`
   FINAL=`echo ${FP: -1}`
   if [[ "$FINAL" != "/" ]];then
       FP=$FP"/"
   fi
   FPN=$FP$FN
fi

##获取配置文件中的参数
source $FPN

if [[ $? -ne 0 ]];then
    echo "Error! -3"
    udp_broadcast "Error! -3"
    exit
fi


##执行文件处理
source $SCRIPT_DIR/dtb_exec.sh
dtb_exec

echo "OK! Copy completed."
udp_broadcast "OK! Copy completed."

#正确执行后需要整体退出
