#!/bin/bash
#/usr/bin/env bash

#程序版本
declare -a VER=(1 0 1)
APPIDN="dtfu"

#配置文件及版本
CFGFILE="dtfu.cfg"
declare -a CFGVER=(1 0 0)

if [[ "$1" == "--version" ]];then 
    echo ${VER[*]} | awk '{print $1"."$2"."$3}'
    exit
fi


SOURCE=$0 # $0 is the shell name， maybe absolute path, relative path or symbolic link
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$SCRIPT_DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"  # script absolute path

#默认发送udp到默认端口
process_udp_enable=1
process_udp_port=7070

function udp_broadcast()
{
    if [[ -z "$1" ]];then
        return
    fi
    if [ $process_udp_enable -ne 1 ];then
        return
    fi
    echo $APPIDN": "$1 | nc -w1 -b -u 255.255.255.255 $process_udp_port
}

udp_broadcast "$APPIDN start..."

source $SCRIPT_DIR/dtfu.cfg


if [[ -z "$file_dir_src" ]];then
    udp_broadcast "Error! -1"
    exit
fi
FP=$file_dir_src
##检查目录尾标是否标准
FINAL=`echo ${FP: -1}`
if [[ "$FINAL" != "/" ]];then
   FP=$FP"/"
fi

##判断是否需要重新引入ftp参数
if [[ -n "$ftp_conf_import" ]];then
    source $SCRIPT_DIR/$ftp_conf_import
fi

##检查ftp的参数是否正确
if [[ -z "$ftp_user" ]];then
    udp_broadcast "Error! -2"
    exit
fi
if [[ -z "$ftp_upload_url" ]];then
    udp_broadcast "Error! -4"
    exit
fi

LOG=$SCRIPT_DIR/dtfu.log
let FNumber=0
for fp in `ls -ltrh ${FP} | grep -v ^d | awk '{print $9}'`
do
    FN=$FP$fp
    rtn=`grep "$FN" $LOG | wc -l`
    if [[ $rtn -eq 0 ]];then
        ##通过lsof 命令来判断，文件是否被另一个程序使用。
        RES=`sudo lsof $FN | wc -l`
        if [ "$RES" -eq 0 ];then
            curl --connect-timeout 5 -sS -u $ftp_user $ftp_upload_url -T $FN
            if [[ $? -eq 0 ]];then
                echo "$APPIDN:uploaded "`date +"%Y-%m-%d %H:%M:%S"`" "$FN >> $LOG 
                udp_broadcast "Uploaded: "$FN" -> "$ftp_upload_url
                let FNumber=$FNumber+1
            fi
        else
            udp_broadcast "Wait: "$FN
        fi
    #else
        #echo "Exist: "$FN
    fi
done

echo "$APPIDN: OK! Upload completed. $FNumber"
udp_broadcast "$APPIDN: OK! Upload completed. $FNumber"

#正确执行后需要整体退出
