#!/bin/bash
#/usr/bin/env bash

##程序基本信息
APPIDN="dtfu"
APPDsp="Data ftp upload"

##程序版本
declare -a VER=(1 0 2)

function printHelp()
{
    echo "======================"
    echo "$APPIDN: $APPDsp"
    echo "Ver: "`echo ${VER[*]} | awk '{print $1"."$2"."$3}'`
    echo "----------------------"
    echo "-n: Name. default: 0"
    echo "-s: Source data dir."
    echo "-u: Ftp user name & passwd, e.g. -u usr:passwd"
    echo "-h: Ftp server ip addr. e.g. 112.72.32.155/temp/"
    echo "-t: Ftp connect timeout, default: $timeout"
    echo "-b: Udp broadcast port. e.g. 7070"
    echo "-I: Ignore files."
    echo "-i: Check time interval, default: 0"
    echo "-l: Log file, default: $APPIDN.log"
    echo "-D: Delete source data file."
    echo "----------------------"
}

let app_name=0
let check_interval=0
let process_udp_enable=1
let process_udp_port=7070
let file_src_delete=0
let timeout=10
IGNORE=""
log="${APPIDN}.log"

ARGS=`getopt -o n:s:u:h:b:I:i:l:t:DHV --long name:,source:,ftp-user:,broadcast-port:,ignore,interval:,log:,connect-timeout,delete-source,help,version -n 'dtfu.sh' -- "$@"`
eval set -- "${ARGS}"

while true ; do
    case "$1" in
        -n|--name)
            app_name=$2;
            shift 2
            ;;
        -s|--source)
            file_dir_src="$2";
            shift 2
            ;;
        -u|--ftp-user)
            ftp_user="$2";
            shift 2
            ;;
        -h|--ftp-host)
            ftp_upload_url="$2";
            shift 2
            ;;
        -b|--broadcast-port)
            process_udp_port=$2;
            shift 2
            ;;
        -I|--ignore)
            IGNORE=" -I \"${2}\"";
            shift 2
            ;;
        -i|--interval)
            check_interval=$2;
            shift 2
            ;;
        -l|--log)
            log="$2";
            shift 2
            ;;
        -t|--connect-timeout)
            timeout="$2";
            shift 2
            ;;
        -D|--delete-source)
            file_src_delete=1;
            shift
            ;;
        -H|--help)
            printHelp;
            exit
            ;;
        -V|--version)
            echo ${VER[*]} | awk '{print $1"."$2"."$3}';
            exit
            ;;
        --)
            shift;
            break
            ;;
        *)
            echo "Inner error!";
            exit 1
            ;;
    esac
done

##获取绝对路径
SOURCE=$0 # $0 is the shell name， maybe absolute path, relative path or symbolic link
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$SCRIPT_DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"  # script absolute path

##广播
function udp_broadcast()
{
    if [[ -z "$1" ]];then
        return -1
    fi
    if [ $process_udp_enable -ne 1 ];then
        return -2
    fi
    echo $APPIDN": "$1 | nc -w1 -b -u 255.255.255.255 $process_udp_port
}

##检查必须要的参数是否为空
if [[ -z "$file_dir_src" ]];then
    udp_broadcast "Error! -1"
    echo "-s: Source data dir."
    exit
fi
if [[ -z "$ftp_upload_url" ]];then
    udp_broadcast "Error! -2"
    echo "-h: Ftp server ip addr. e.g. 112.72.32.155/temp/"
    exit
fi
if [[ -z "$ftp_user" ]];then
    udp_broadcast "Error! -3"
    echo "-u: Ftp user name & passwd, e.g. -u usr:passwd"
    exit
fi

udp_broadcast "$APPIDN start..."
echo "-----------------"
echo "$APPIDN start..."

FP=$file_dir_src
##检查目录尾标是否标准
FINAL=`echo ${FP: -1}`
if [[ "$FINAL" != "/" ]];then
   FP=$FP"/"
fi

##为log文件加入绝对路径
if [[ "${log:0:1}" != "/" ]];then
    log="$SCRIPT_DIR/$log"
fi

let cycle_times=0

while true;
do
    let cycle_times=$cycle_times+1
    let FNumber=0

    udp_broadcast "$APPIDN start upload, times: $cycle_times."
    echo "-----------------"
    echo "$APPIDN start upload, times: $cycle_times."

    search="ls -ltrh ${IGNORE} ${FP} | grep -v ^d | awk '{print \$9}'"
    for fp in `eval $search`
    do
        FN=$FP$fp
        rtn=`grep "${app_name}:${fp}" $log| wc -l`
        if [[ $rtn -eq 0 ]];then
            ##通过lsof 命令来判断，文件是否被另一个程序使用。
            #RES=`sudo lsof $FN | wc -l`
            ##通过fuser命令判断是否文件正在操作
            RES=`fuser $FN | awk '{print $1}' | wc -l`
            if [ "$RES" -eq 0 ];then
                curl --connect-timeout $timeout -sS -u $ftp_user $ftp_upload_url -T $FN
                if [ $? -eq 0 ];then
                    echo `date +"%y%m%d%H%M%S"`" "${app_name}":"${fp} >> $log
                    udp_broadcast "Uploaded: "${app_name}":"$FN" -> "$ftp_upload_url
                    echo "Uploaded: "${app_name}":"$FN" -> "$ftp_upload_url
                    let FNumber=$FNumber+1
                    ##依据设置参数删除源文件
                    if [[ $file_src_delete -eq 1 ]];then
                        sudo rm -rf $FN
                    fi
                fi
            else
                udp_broadcast "Wait: "$FN
                echo "Wait: "$FN
            fi
        fi
    done

    echo "$APPIDN: OK! Upload completed; $FNumber files, $cycle_times times."
    udp_broadcast "$APPIDN: OK! Upload completed; $FNumber files, $cycle_times times."

    if [[ $check_interval -gt 0 ]];then
        sleep $check_interval
    fi
done
