#!/bin/bash
### BEGIN INIT INFO
###
### END INIT INFO

SOURCE=$0 # $0 is the shell name， maybe absolute path, relative path or symbolic link
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$SCRIPT_DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"  # script absolute path

APPIDN="dtfu"
APPName="dtfu.sh"
CONF_FILE="dtfu.cfg"
log_backup_days=15

CONF_FILE=$SCRIPT_DIR/$CONF_FILE
APP=$SCRIPT_DIR/$APPName

## Check config file exist.
rtn=`ls -f $CONF_FILE | wc -l`
if [[ $rtn -eq 0 ]];then
    echo "Error! Configure null on $CONF_FILE, need run './configure' to create configure file."
    exit -1
fi
## Import parameters from configure file.
source $CONF_FILE

#let log_backup_seconds=1000  ## Test
let log_backup_seconds=$log_backup_days*24*60*60
lastLogBkMonth_0=`date +"%Y-%m-%d"`" 00:00:00"
let lastLogBkMonth=`date -d "${lastLogBkMonth_0}" +%s`

LOG_DIR=$SCRIPT_DIR"/log/"
LOG=${SCRIPT_DIR}"/"${log}
mkdir -p ${LOG_DIR}

function log_backup(){
    rtn=`ls -f ${LOG} | wc -l`
    if [[ $rtn -eq 0 ]];then
        return
    fi

    let dateNow=`date +%s`
    let dateDiff=${dateNow}-${lastLogBkMonth}

    if [[ $dateDiff -gt $log_backup_seconds ]];then

        bkMonth=`date +"%Y%m"`
        let lastLogBkMonth=$dateNow

        bkFN=${LOG_DIR}${APPIDN}"-"$bkMonth".log"
        
        ##Backup rows.
        while read row
        do
            fp=`echo $row | awk '{print $2}' | awk -F":" '{print $2}'`
            rtn=`ls -f ${file_dir_src}${fp} | wc -l`
            if [[ $rtn -eq 0 ]];then
                echo $row >> $bkFN
            fi
        done < $LOG

        ##Delete source row.
        rtn=`ls -f ${bkFN} | wc -l`
        if [[ $rtn -gt 0 ]];then
            killall -9 $APPName

            while read row
            do
                sed -i "/${row}/d" $LOG 
            done < $bkFN
        fi
    fi
}

function run(){

    log_backup

    rtn=`ps -A | grep $APPName | grep -v grep | wc -l`
    if [[ $rtn -eq ${ftpNum} ]];then
        sleep 10
        return
    fi

    if [[ $rtn -ge 1 ]];then
        killall -9 $APPName
    fi

    if [[ -n "$ignore" ]];then
        ignore2=" -I ${ignore}" 
    fi
    broadcast=""
    if [ $process_udp_enable -ne 0 ];then
        broadcast=" -b "$process_udp_port
    fi
    del=""
    if [ $file_src_delete -ne 0 ];then
        del=" -D "
    fi

    for ((i=0; i<${ftpNum}; i++))
    do
        $APP -n $i -s $file_dir_src -u ${ftpUser[$i]} -h ${ftpUrl[$i]} -t $timeout $ignore2 $broadcast -i $check_interval $del -l $log &
    done
}

case $1 in
start)
        while true
        do
            run
        done
;;
stop)
        rtn=`ps -A | grep $APPName | grep -v grep | wc -l`
        if [[ $rtn -ge 1 ]];then
            killall -9 $APPName
        fi
;;
status)
        rtn=`ps -A | grep $APPName | grep -v grep | wc -l`
        if [[ $rtn -ge 1 ]];then
                echo "$APPName is running."
        else
                echo "$APPName is stoped."
        fi
;;
*)
        echo "$APPName start|stop|status"
        exit 1
esac

exit 0
