#!/bin/bash

##程序基本信息
APPIDN="dtfu_configure"
APPDsp="Data ftp upload configure"

##程序版本
declare -a VER=(1 0 1)

TIME_OUT=60

function printHelp()
{
    echo "## $APPIDN: $APPDsp"
    echo "## Ver: "`echo ${VER[*]} | awk '{print $1"."$2"."$3}'`
}

ARGS=`getopt -o HV --long help,version -n 'configure.sh' -- "$@"`
eval set -- "${ARGS}"

while true ; do
    case "$1" in
        -H|--help)
            printHelp;
            exit
            ;;
        -V|--version)
            echo ${VER[*]} | awk '{print $1"."$2"."$3}';
            exit
            ;;
        --)
            shift;
            break
            ;;
        *)
            echo "Inner error!";
            exit 1
            ;;
    esac
done

echo "##======================"
printHelp
echo "##----------------------"
echo "## Any time, type 'X' or 'exit' for exit!"
echo "##----------------------"

function exit_check()
{
    if [[ "$1" == "X" ]];then
        exit
    fi
    if [[ "$1" == "exit" ]];then
        exit
    fi
}

ftpNum=1
declare -a ftpUser=()
declare -a ftpUrl=()
declare -a yesno=("no" "yes")

cfg="dtfu.cfg"

log_backup_days=15
file_dir_src="/var/sa/data/rt/";
log="dtfu.log"
let process_udp_enable=1
let process_udp_port=7070
let check_interval=3
let file_src_delete=0
let timeout=30
ignore=""

conf_import="/var/sa/conf/data_save.json"

##获取绝对路径
SOURCE=$0 # $0 is the shell name， maybe absolute path, relative path or symbolic link
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$SCRIPT_DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
SCRIPT_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"  # script absolute path

function src_dir_input(){
    read -t $TIME_OUT -p "Source data dir [default: $file_dir_src] : " par
    if [[ -n "$par" ]];then
        exit_check $par
        file_dir_src=$par
    fi
}

function log_dir_input(){
    read -t $TIME_OUT -p "Log file [default: $log] : " par
    if [[ -n "$par" ]];then
        exit_check $par
        log=$par
    fi
}

function exclude_input(){
    read -t $TIME_OUT -p "Source data files ignored [default: $ignore] : " par
    if [[ -n "$par" ]];then
        exit_check $par
        ignore=$par
    fi
}

function del_input(){
    read -t $TIME_OUT -p "Source files deleted after uploaded, 'yes' or 'no' [default: ${yesno[$file_src_delete]}] : " par
    if [[ -n "$par" ]];then
        exit_check $par
        if [[ "$par" != "yes" ]];then
            if [[ "$par" != "no" ]];then
                del_input 
            else
                file_src_delete=0
            fi
        else
            file_src_delete=1
        fi
    else
        file_src_delete=0
    fi
}

function interval_input(){
    read -t $TIME_OUT -p "Check interval [default: $check_interval] : " par
    if [[ -n "$par" ]];then
        exit_check $par
        check_interval=$par
    fi
}

function ftpNum_check(){
    exit_check $1
    if [[ "$1" -lt 1 ]];then
        echo "FTP server number must great then 0."
        ftpNum_input
    fi
    if [[ "$1" -gt 10 ]];then
        echo "FTP server number must less then 10."
        ftpNum_input
    fi
    ftpNum=$1
}

function ftpNum_input(){
    read -t $TIME_OUT -p "FTP server number [default: $ftpNum] : " par
    if [[ -n "$par" ]];then
        ftpNum_check $par
    fi
}

function ftpUser_input(){
    read -t $TIME_OUT -p "User & Passwd [default: ${ftpUser[$1]}] : " par
    exit_check $par
    if [[ -n "$par" ]];then
        ftpUser[$1]=$par
    fi
}

##Test ftp link
## $1: user:passwd
## $2: ftp url
TestFile="./ftpLinkTest.txt"
function ftp_verify(){

    if [[ -z "$1" ]];then
        return -1
    fi
    if [[ -z "$2" ]];then
        return -2
    fi
    date +"%Y-%m-%d %H:%M:%S" > $TestFile
    curl --connect-timeout 10 -sS -u $1 $2 -T $TestFile
    rm -rf $TestFile 

    return $?
}

function ftpUrl_input(){
    read -t $TIME_OUT -p "URL [default: ${ftpUrl[$1]}]: " par 
    exit_check $par
    if [[ -z "$par" ]];then
        if [[ -z "${ftpUrl[$1]}" ]];then
            echo "Error! url null."
            ftpUrl_input $1
            return 0
        fi
    else
        ftpUrl[$1]=$par
    fi
    read -t $TIME_OUT -p "Test FTP link now? 'y' for yes. : " par 
    if [[ "$par" == "y" ]];then
        ftp_verify ${ftpUser[$1]} ${ftpUrl[$1]}
        return $?
    fi
    if [[ "$par" == "yes" ]];then
        ftp_verify ${ftpUser[$1]} ${ftpUrl[$1]}
        return $?
    fi

    return 0
}

function make_run_script_conf(){
    chmod +w $cfg
    printHelp > $cfg
    echo "##-------------" >> $cfg
    echo "## Auto created" >> $cfg
    echo "## Time: "`date +"%Y-%m-%d %H:%M:%S"` >> $cfg
    echo "log_backup_days=$log_backup_days" >> $cfg
    echo "file_dir_src=\"$file_dir_src\"" >> $cfg
    echo "log=\"$log\"" >> $cfg
    echo "ignore=\"$ignore\"" >> $cfg
    echo "file_src_delete="$file_src_delete >> $cfg
    echo "check_interval="$check_interval >> $cfg
    echo "process_udp_enable="$process_udp_enable >> $cfg
    echo "process_udp_port="$process_udp_port >> $cfg
    echo "timeout="$timeout >> $cfg
    echo "ftpNum="$ftpNum >> $cfg
    echo "ftpUser=(${ftpUser[*]})" >> $cfg
    echo "ftpUrl=(${ftpUrl[*]})" >> $cfg
    chmod -w $cfg

    if [ -f "$cfg" ];then
        echo "Configure completed in "$cfg
    else
        echo "Error! Can not configure in "$cfg
    fi
    echo "*End*"
}

function confirm_write(){
    read -t $TIME_OUT -p "Correctly configured and write now, 'yes' or 'no'? " par
    if [[ -n "$par" ]];then
        exit_check $par
        if [[ "$par" != "yes" ]];then
            if [[ "$par" != "no" ]];then
                confirm_write
            fi
        else
            make_run_script_conf
        fi
    else
        confirm_write
    fi
}

function log_backup_input(){
    read -t $TIME_OUT -p "Log backup days [default: $log_backup_days] : " par
    if [[ -n "$par" ]];then
        exit_check $par
        if [[ $par -ge 1 ]];then
            log_backup_days=$par
        else
            log_backup_days=3
        fi
    fi
    echo "Setting log backup days: "$log_backup_days
}

function main_run(){

    ##引入原来的配置
    cfg=$SCRIPT_DIR/$cfg
    if [ -f "$cfg" ];then
        source $cfg
    fi

    log_backup_input
    src_dir_input
    log_dir_input
    exclude_input
    del_input
    interval_input
    ftpNum_input

    for ((i=0; i<${ftpNum}; i++))
    do
        echo "--------"
        let j=$i+1
        echo "No."$j" server configur:"
        ##Check sa app ftp config file. 
        if [[ -n "$conf_import" ]];then
            rtn=`ls -f $conf_import | wc -l`
            if [[ $rtn -eq 1 ]];then
                read -t $TIME_OUT -p "Detect ftp config file: $conf_import, 'y' for load it: " par 
                if [[ "$par" == "y" ]];then
                    JSONCONF="json-conf -f $conf_import"
                    ftpUser[$i]=`$JSONCONF -i DS_UPLOAD_FTP_PASSWD`
                    ftpUrl[$i]=`$JSONCONF -i DS_UPLOAD_URL`
                    $JSONCONF -i DS_UPLOAD_ENABLE -v 0
                    conf_import=""
                fi
            fi
        fi
        ftpUser_input $i
        while true ; do #加入链接检测
            ftpUrl_input $i
            if [ $? -le 0 ];then
                echo "OK! ftp can be connected!"
                break
            else
                read -t $TIME_OUT -p "$1: Can not connect ftp server, 'y' for save it: " par 
                if [[ "$par" == "y" ]];then
                    break
                fi
            fi
        done
    done

    ##如果有两个以上的上传服务，禁用文件删除
    if [[ $ftpNum -gt 1 ]];then
        file_src_delete=0
    fi

    echo "**********************"
    echo "Setting completed, check follow parameters:"
    echo "----------------------"
    echo "Log backup days: "$log_backup_days
    echo "Source data dir: "$file_dir_src
    echo "Upload log: "$log
    echo "Ignore: "$ignore
    echo "Delete source after uploaded: "${yesno[$file_src_delete]}
    echo "Check interval: "$check_interval
    echo "--------"
    echo "FTP server: "$ftpNum
    for ((i=0; i<${ftpNum}; i++))
    do
        let j=$i+1
        echo "No."$j" server, user: "${ftpUser[$i]}", url: "${ftpUrl[$i]}
    done
    echo "**********************"

    confirm_write
}

main_run
